#ifndef SHAREPROGRAMDIALOG_H
#define SHAREPROGRAMDIALOG_H

#include <QDialog>

namespace Ui {
    class ShareProgramDialog;
}
class GoogleDocumentService;

class ShareProgramDialog : public QDialog
{
    Q_OBJECT

public:
    ShareProgramDialog(GoogleDocumentService *googleDoc,QWidget *parent = 0);
    ~ShareProgramDialog();

private slots:
    void downloadButtonClickedSlot();
    void uploadButtonClickedSlot();
    void refreshButtonClicked();
    void listDone(bool done);
    void downloadDone(bool done);
    void updateProgressBar(qint64 doneBytes, qint64 totalBytes);
    void browseButtonClicked();

protected:
    void changeEvent(QEvent *e);

private:
    Ui::ShareProgramDialog *ui;
    GoogleDocumentService *googleDoc;
    QString selectedFileName;
};

#endif // SHAREPROGRAMDIALOG_H
