#include<fcntl.h>
#include<unistd.h>
#include <stdlib.h>
#include <string.h>
#include <QDebug>
#include <QMessageBox>
#include <QFileDialog>
#include <QTextDocumentWriter>
#include <QTextStream>
#include <QPoint>
#include <QPainter>
#include <QAbstractScrollArea>
#include <QInputDialog>
#include <QScrollBar>
#include <QDirModel>
#include <QModelIndex>
#include <QScrollArea>
#include <QMaemo5InformationBox>

#include "mainwindow.h"
#include "ui_mainwindow.h"
#include "texteditautoresizer.h"
#include "shareProgram/logindialog.h"

MainWindow::MainWindow(int argc,char *argv[],QWidget *parent)
    : QMainWindow(parent),
      ui(new Ui::MainWindow),
      m_fsIcon(FS_BUTTON_PATH)
{
    ui->setupUi(this);
    this->showFullScreen();
    this->setProperty("FingerScrollable", true);

    /*!
     * Intialisation of the toolbar swithching button
     */
    m_dbButton = new QPushButton(this);
    Q_CHECK_PTR(m_dbButton);
    m_dbButton->setStyleSheet(FS_BUTTON_STYLE_SHEET);
    m_dbButton->resize(FS_BUTTON_SIZE*3, FS_BUTTON_SIZE*3);
    m_dbButton->setIcon(QIcon(":images/bug.png"));
    m_dbButton->setIconSize(QSize(35,35));
    m_dbButton->move(30 ,420 );
    m_dbButton->show();
    m_dbButton->resize(40,40);

    ui->tabWidget->removeTab(0);
    ui->actionFullScreen->setIcon(m_fsIcon);
    ui->breakLineEdit->hide();
    /*!
     * Intialising debug toolbar
     */
    ui->mainToolBar->addAction(ui->actionFullScreen);
    ui->mainToolBar->addAction(ui->actionStopDebug);
    ui->mainToolBar->addAction(ui->actionContinue);
    ui->mainToolBar->addAction(ui->actionBreakpoint);
    ui->mainToolBar->addAction(ui->actionWatchWindow);
    ui->mainToolBar->addAction(ui->actionStep);
    ui->mainToolBar->addAction(ui->actionCompile);
    ui->mainToolBar->addAction(ui->actionRun);
    ui->mainToolBar->addSeparator();
    /*!
     * Intialising edit toolbar
     */
    ui->editToolBar->addAction(ui->actionFullScreen);
    ui->editToolBar->addAction(ui->actionAddCode);
    ui->editToolBar->addSeparator();
    ui->editToolBar->addAction(ui->actionRedo);
    ui->editToolBar->addAction(ui->actionUndo);
    ui->editToolBar->addAction(ui->actionPaste);
    ui->editToolBar->addAction(ui->actionCopy);
    ui->editToolBar->addAction(ui->actionCut);
    ui->editToolBar->addAction(ui->actionOpen);
    ui->editToolBar->addAction(ui->actionNew);
    ui->editToolBar->addAction(ui->actionOpen);
    ui->editToolBar->addAction(ui->actionNew);

    ui->tabWidget->setTabsClosable(true);
    ui->mainToolBar->hide();
    ui->stackedWidget->setCurrentIndex(1);
    this->setContentsMargins(0, 0, 0, 0);
    ui->watchWindow->hide();

    listEvHandler = new RCEventHandler(this);
    // install event filter
    ui->watchWindow->installEventFilter(listEvHandler);


    watchMenu = new QMenu();
    actionNewWatch=new QAction("new",this);
    actionDeleteWatch=new QAction("delete",this);
    watchMenu->addAction(actionNewWatch);
    watchMenu->addAction(actionDeleteWatch);
    /*!
     * connect statements
     */
    connect(ui->actionOpen,SIGNAL(triggered()),this,SLOT(open()));
    connect(ui->actionNew,SIGNAL(triggered()),this,SLOT(fileNew()));
    connect(ui->actionSave,SIGNAL(triggered()),this,SLOT(fileSave()));
    connect(ui->actionSave_as,SIGNAL(triggered()),this,SLOT(fileSaveAs()));
    connect(ui->actionCompile,SIGNAL(triggered()),this,SLOT(compile()));
    connect(ui->actionRun,SIGNAL(triggered()),this,SLOT(run()));
    connect(ui->actionStep,SIGNAL(triggered()),this,SLOT(debug()));
    connect(ui->actionBreakpoint,SIGNAL(triggered()),this,SLOT(debug()));
    connect(ui->actionContinue,SIGNAL(triggered()),this,SLOT(debug()));
    connect(ui->actionStopDebug,SIGNAL(triggered()),this,SLOT(debug()));
    connect(ui->actionAbout,SIGNAL(triggered()),this,SLOT(showAbout()));
    connect(ui->breakLineEdit,SIGNAL(returnPressed()),this,SLOT(addBreakPoint()));

    connect(&gdbOutput,SIGNAL(updateLineNumber(QString)),this,SLOT(updateLineNumber(QString)));
    connect(&scanfThread,SIGNAL(stopDebug()),this,SLOT(stopDebug()));
    connect(&scanfThread,SIGNAL(showScanDialog(QString)),this,SLOT(showScanDialog(QString)));
    connect(&gdbOutput,SIGNAL(stopDebug()),this,SLOT(stopDebug()));
    connect(&outputThread,SIGNAL(update(QString )),this,SLOT(updateDisplay(QString)));
    connect(ui->actionFullScreen,SIGNAL(triggered()),this,SLOT(showFullScreenSlot()));
    connect(ui->tabWidget,SIGNAL(tabCloseRequested(int )),this,SLOT(maybeSave(int )));
    connect(ui->actionUndo,SIGNAL(triggered()),this,SLOT(textUndo()));
    connect(ui->actionRedo,SIGNAL(triggered()),this,SLOT(textRedo()));
    connect(ui->cancelButton,SIGNAL(clicked()),this,SLOT(cancelButtonClicked()));
    connect(ui->actionAddCode,SIGNAL(triggered()),this,SLOT(insertKeyword()));
    connect(ui->keywordList,SIGNAL(doubleClicked(QModelIndex)),this,SLOT(keywordSelected(QModelIndex)));
    connect(ui->upPushButton,SIGNAL(clicked()),this,SLOT(upPushButtonSlot()));
    connect(ui->downPushButton,SIGNAL(clicked()),this,SLOT(downPushButtonSlot()));
    connect(ui->deleteKeywordButton,SIGNAL(clicked()),this,SLOT(deleteKeywordList()));
    connect(ui->addKeywordButton,SIGNAL(clicked()),this,SLOT(addKeywordList()));
    connect(m_dbButton,SIGNAL(clicked()),this,SLOT(enableDebugingMode()));
    connect(ui->actionCopy,SIGNAL(triggered()),this,SLOT(textCopy()));
    connect(ui->actionCut,SIGNAL(triggered()),this,SLOT(textCut()));
    connect(ui->actionPaste,SIGNAL(triggered()),this,SLOT(textPaste()));
    connect(ui->actionWatchWindow,SIGNAL(triggered()),this,SLOT(setWatchWindowVisible()));
    connect(actionNewWatch,SIGNAL(triggered()),this,SLOT(addWatchItem()));
    connect(actionDeleteWatch,SIGNAL(triggered()),this,SLOT(deleteWatchItem()));
    connect(ui->actionShareProgramOnline,SIGNAL(triggered()),this,SLOT(shareOnlineSlot()));
    // connect signals
    connect(listEvHandler, SIGNAL(send_rightButtonClicked(const QPoint&)),this, SLOT(rightButtonClicked(const QPoint&)));

    init();
    fileNew();

        if(argc>1) {
            for(int i=1;i<argc;i++) {
                open(QString(QDir::currentPath()+"/"+argv[i]));
            }
        }
        else {
            QDir::setCurrent("/home/user");
        }
}

void MainWindow::init()
{
    QDir edicomDir("/home/user/edicom-examples");
    edicomDir.mkdir("/home/user/edicom-examples");

    mkfifo("/tmp/.INFIFO",0777);
    mkfifo("/tmp/.OUTFIFO",0777);
    mkfifo("/tmp/.PIN",0777);
    mkfifo("/tmp/.POUT",0777);

    QFile fileData("/tmp/.a");
    QString s="set logging file .gdb.txt\nset logging on\nstart\nbt\n";
    if (fileData.open(QFile::WriteOnly | QFile::Truncate)) {
        QTextStream out(&fileData);
        out <<s;
    }
    fileData.close();

    fileData.setFileName("/home/user/.edicom");
    if(!fileData.exists())
    {
        s="if() { }\nfor(;;) { }\nwhile( ) { }\n#include<>\nprintf(\"\");\nscanf(\"\");\n";
        if (fileData.open(QFile::WriteOnly | QFile::Truncate)) {
            QTextStream out(&fileData);
            out <<s;
        }
        fileData.close();
    }
    if (!fileData.open(QFile::ReadOnly | QFile::Text))
    {
        return;
    }

    QTextStream in(&fileData);
    QStringList text=in.readAll().split("\n");
    for(int i=0;i<text.length()-1;i++)
    {
        ui->keywordList->addItem(text[i]);
    }
}

MainWindow::~MainWindow()
{
    gdbThread.terminate();
    delete ui;
    if(gdbThread.isRunning())
        gdbThread.terminate();

    unlink(".c.txt");
    unlink(".compiled.txt");
    unlink(".temp.c");
    unlink(".temp");
}

void MainWindow::shareOnlineSlot()
{
    LoginDialog loginDialog;
    loginDialog.exec();
}

void MainWindow::rightButtonClicked(const QPoint &pos)
{
    if(ui->watchWindow->currentItem()!=NULL && ui->watchWindow->currentItem()->isSelected()==true) {
        watchMenu->addAction(actionDeleteWatch);
    }
    else
        watchMenu->removeAction(actionDeleteWatch);

    watchMenu->exec(pos);
}

void MainWindow::addWatchItem()
{
    bool ok;
         QString text = QInputDialog::getText(this, tr("Watch"),
                                              tr("Variable Name:"), QLineEdit::Normal,
                                              "", &ok);
         if (ok && !text.isEmpty())
         {
            QString temp="disp "+ text+"\n";
            ::write(flags.wr,temp.toAscii().data(),strlen(temp.toAscii().data()));
            watchVariablesList<<text;
            ui->watchWindow->addItem(text+" = ");
         }
}

void MainWindow::deleteWatchItem()
{
    QListWidgetItem *temp=ui->watchWindow->currentItem();
    int row=ui->watchWindow->currentRow();

    if(temp!=NULL && temp->isSelected()==true) {
        ui->watchWindow->takeItem(row);
        ui->watchWindow->repaint();
        watchVariablesList.removeAt(row);
    }
}

void MainWindow::setWatchWindowVisible()
{
    if(ui->watchWindow->isHidden())
    {
        ui->watchWindow->show();
        if(watchVariablesList.length()==0)
            QMaemo5InformationBox::information(0, "Make a deep press on watch window to add a watch variable",QMaemo5InformationBox::DefaultTimeout);
    }
    else
        ui->watchWindow->hide();
}

void MainWindow::textCopy()
{
    int currentTab;
    currentTab=ui->tabWidget->currentIndex();
    displayArea.at(currentTab)->copy();
}

void MainWindow::textPaste()
{
    int currentTab;
    currentTab=ui->tabWidget->currentIndex();
    displayArea.at(currentTab)->paste();
}

void MainWindow::textCut()
{
    int currentTab;
    currentTab=ui->tabWidget->currentIndex();
    displayArea.at(currentTab)->cut();
}

void MainWindow::enableDebugingMode()
{
    if(ui->mainToolBar->isHidden() && !ui->editToolBar->isHidden())
    {
        ui->mainToolBar->show();
        ui->editToolBar->hide();
        m_dbButton->setIcon(QIcon(":images/editmode.png"));
        m_dbButton->show();
    }
    else
    {
        ui->mainToolBar->hide();
        ui->editToolBar->show();
        m_dbButton->setIcon(QIcon(":images/bug.png"));
        m_dbButton->show();
    }

}

void MainWindow::addKeywordList()
{
    bool ok;
    QString text = QInputDialog::getText(this, tr("add keyword"),
                                         tr("Keyword:"), QLineEdit::Normal, "", &ok);

    if(text!="") {
        ui->keywordList->insertItem(0,text);
    }
}

void MainWindow::upPushButtonSlot()
{

    if(ui->keywordList->currentItem()!=NULL && ui->keywordList->currentItem()->isSelected()==true) {
        QListWidgetItem *item=ui->keywordList->currentItem();
        QString text=item->text();
        int pos=ui->keywordList->row(item);
        ui->keywordList->takeItem(pos);
        ui->keywordList->insertItem(pos-1,text);
        ui->keywordList->setCurrentItem(ui->keywordList->item(pos-1));
    }
}

void MainWindow::downPushButtonSlot()
{
    if(ui->keywordList->currentItem()!=NULL && ui->keywordList->currentItem()->isSelected()==true) {
        QListWidgetItem *item=ui->keywordList->currentItem();
        QString text=item->text();
        int pos=ui->keywordList->row(item);
        ui->keywordList->takeItem(pos);
        ui->keywordList->insertItem(pos+1,text);
        ui->keywordList->setCurrentItem(ui->keywordList->item(pos+1));
    }
}

void MainWindow::keywordSelected(QModelIndex index)
{
    if(ui->tabWidget->count()==0)
        return;

    int currentTab;
    currentTab=ui->tabWidget->currentIndex();
    displayArea.at(currentTab)->insertPlainText(ui->keywordList->item(index.row())->text());
    ui->stackedWidget->setCurrentIndex(1);
    ui->editToolBar->show();
    m_dbButton->show();
    m_dbButton->setIcon(QIcon(":images/bug.png"));;
}

void MainWindow::deleteKeywordList()
{
    if(ui->keywordList->currentItem()!=NULL && ui->keywordList->currentItem()->isSelected()==true)
    {
        QListWidgetItem *item=ui->keywordList->currentItem();
        QString text=item->text();
        int pos=ui->keywordList->row(item);
        ui->keywordList->takeItem(pos);
    }
}

void MainWindow::insertKeyword()
{
    ui->stackedWidget->setCurrentIndex(2);
    ui->editToolBar->hide();
    ui->mainToolBar->hide();
    m_dbButton->hide();
}

void MainWindow::cancelButtonClicked()
{
    ui->stackedWidget->setCurrentIndex(1);
    ui->editToolBar->show();
    m_dbButton->show();
    m_dbButton->setIcon(QIcon(":images/bug.png"));;
}

void MainWindow::showFullScreenSlot()
{
    if(this->isFullScreen())
    {
        m_dbButton->move(30 ,365 );
        this->showNormal();
    }
    else
    {
        m_dbButton->move(30 ,420 );
        this->showFullScreen();
    }
}

void MainWindow::textUndo()
{
    if(ui->tabWidget->count()==0)
        return;
    displayArea.at(ui->tabWidget->currentIndex())->undo();
}

void MainWindow::textRedo()
{
    if(ui->tabWidget->count()==0)
        return;
    displayArea.at(ui->tabWidget->currentIndex())->redo();
}

void MainWindow::documentModified()
{
    int currentTab=ui->tabWidget->currentIndex();
    if(!ui->tabWidget->tabText(currentTab).startsWith("*"))
    {
        if(displayArea.at(currentTab)->document()->isModified())
        {
            ui->tabWidget->setTabText(currentTab,"*"+ui->tabWidget->tabText(currentTab));
        }
    }
    else if(!displayArea.at(currentTab)->document()->isModified())
        ui->tabWidget->setTabText(currentTab,ui->tabWidget->tabText(currentTab).mid(1));
}

void MainWindow::showAbout()
{
    QMessageBox::about(this,"About","Developed by:\n            Sugnan Prabhu S\n            VTU nokia Lab\n            SJCE college\n");
}

bool MainWindow::maybeSave(int i)
{
    ui->tabWidget->setCurrentIndex(i);
    if(flags.debugging==true) {
        if(i==compiledTab || i==currentFileTab) {
            return false;
        }
    }

    if (!displayArea.at(i)->document()->isModified()) {
        closeTab(i);
        return true;
    }

    QMessageBox::StandardButton ret;
    ret = QMessageBox::warning(this, tr("Application"),
                                       "The document "+ fileName.at(i) +" has been modified.\n"
                                       "Do you want to save your changes?",
                                    QMessageBox::Save | QMessageBox::Discard
                                    | QMessageBox::Cancel);

    if (ret == QMessageBox::Save) {
        ui->tabWidget->setCurrentIndex(i);
        fileSave();
    }
    else if (ret == QMessageBox::Cancel)
        return false;

    closeTab(i);
    return true;
 }

bool MainWindow::fileSave()
 {
    if(ui->tabWidget->count()==0)
        return false;

    int currentTab=ui->tabWidget->currentIndex();

    if(displayArea.at(currentTab)->document()->isModified()) {

        if (fileName.at(currentTab).compare("")==0)
            return fileSaveAs();

        QFile fileData(fileName.at(currentTab));
        fileData.remove();

        if (!fileData.open(QFile::WriteOnly | QFile::Truncate))
           return false;

        QTextStream out(&fileData);
        out <<displayArea.at(currentTab)->toPlainText();
        fileData.close();

        displayArea.at(currentTab)->document()->setModified(false);
        ui->tabWidget->setTabText(currentTab,ui->tabWidget->tabText(currentTab).mid(1));
    }
    return true;
 }

bool MainWindow::fileSaveAs()
 {
    if(ui->tabWidget->count()==0)
        return false;

    int currentTab=ui->tabWidget->currentIndex();
     QString fn = QFileDialog::getSaveFileName(this, tr("Save as..."),
                                               QString(), "C File (*.c);;CPP files (*.cpp);;All Files (*)");

     if (fn.isEmpty())
         return false;

     if (! (fn.endsWith(".c", Qt::CaseInsensitive) || fn.endsWith(".cpp", Qt::CaseInsensitive) || fn.endsWith(".txt", Qt::CaseInsensitive)) )
         fn += ".c";

     QFile fileData(fn);
     if (!fileData.open(QFile::WriteOnly | QFile::Truncate))
            return false;

    QTextStream out(&fileData);
    out <<displayArea[currentTab]->toPlainText();

    fileName.removeAt(ui->tabWidget->currentIndex());
    fileName.insert(ui->tabWidget->currentIndex(),fn);
    ui->tabWidget->setTabText(currentTab,fn.mid(fn.lastIndexOf("/"),5));
     return fileSave();
 }

void MainWindow::open(QString fname)
{
    if(ui->tabWidget->count()==0) {
        return;
    }

    QString selectedFileName;

    if(fname.isEmpty())
        selectedFileName = QFileDialog::getOpenFileName(this,tr("Open File"), QDir::currentPath(),"*.c *.cpp *.cc *.txt");
    else
        selectedFileName=fname;

    QFile file(selectedFileName);
     if (!file.open(QFile::ReadOnly | QFile::Text))
         return;

     int tabCount=ui->tabWidget->count();

     int currentTab=ui->tabWidget->currentIndex();
     /*!
      * check whether the current document is modified or its already a new tab
      */
     if(displayArea.at(currentTab)->document()->isModified() || fileName.at(currentTab).compare("")!=0)
         fileNew();

     ui->tabWidget->setTabText(ui->tabWidget->currentIndex(),selectedFileName.mid(selectedFileName.lastIndexOf("/")+1,4));

     currentTab=ui->tabWidget->currentIndex();

     /*!
      * set text of file, to the current tab
      */
     fileName.removeAt(currentTab);
     fileName.insert(currentTab,selectedFileName);

     QTextStream in(&file);
     QApplication::setOverrideCursor(Qt::WaitCursor);
     disconnect(displayArea.at(currentTab),SIGNAL(textChanged()),this,SLOT(documentModified()));
     displayArea.at(ui->tabWidget->currentIndex())->setPlainText(in.readAll());
     connect(displayArea.at(currentTab),SIGNAL(textChanged()),this,SLOT(documentModified()));
     QApplication::restoreOverrideCursor();
 }

void MainWindow::fileNew()
 {
    int tabCount=ui->tabWidget->count();

    QWidget *tempTab = new QWidget();

    QGridLayout *tempGridLayout= new QGridLayout(tempTab);
    tempGridLayout->setSpacing(0);
    tempGridLayout->setContentsMargins(0, 0, 0, 0);

    QScrollArea *tempScrollArea = new QScrollArea(tempTab);
    tempScrollArea->setWidgetResizable(true);

    QWidget *tempScrollAreaWidgetContents = new QWidget();
    tempScrollAreaWidgetContents->setGeometry(QRect(0, 0, 376, 247));

    QGridLayout *tempGridLayout2 = new QGridLayout(tempScrollAreaWidgetContents);
    tempGridLayout2->setSpacing(0);
    tempGridLayout2->setContentsMargins(0, 0, 0, 0);

    CodeEditor *tempDisplayArea = new CodeEditor(tempScrollAreaWidgetContents);
    tempDisplayArea->setVerticalScrollBarPolicy(Qt::ScrollBarAsNeeded);
    tempDisplayArea->setHorizontalScrollBarPolicy(Qt::ScrollBarAsNeeded);
    tempDisplayArea->setLineWrapMode(QPlainTextEdit::NoWrap);
    tempDisplayArea->setTabStopWidth(80);

    Highlighter *tempHighlighter = new Highlighter(tempDisplayArea->document());
    tempGridLayout2->addWidget(tempDisplayArea, 0, 0, 1, 1);
    new TextEditAutoResizer(tempDisplayArea);
    tempGridLayout2->addWidget(tempDisplayArea, 0, 0, 1, 1);


    tempScrollArea->setWidget(tempScrollAreaWidgetContents);
    tempGridLayout->addWidget(tempScrollArea, 0, 0, 1, 1);

    ui->tabWidget->addTab(tempTab, "ut");
    ui->tabWidget->setTabText(tabCount,"ut");
    QString tempFileName="";
    tempDisplayArea->setProperty("FingerScrollable", true);
    tempDisplayArea->clear();
    tempDisplayArea->setInputMethodHints(Qt::ImhNoAutoUppercase);
    connect(tempDisplayArea,SIGNAL(textChanged()),this,SLOT(documentModified()));

    tab.append(tempTab);
    highlighter.append(tempHighlighter);
    gridLayout.append(tempGridLayout);
    gridLayout2.append(tempGridLayout2);
    displayArea.append(tempDisplayArea);
    scrollArea.append(tempScrollArea);
    fileName.append(tempFileName);
    scrollAreaWidgetContents.append(tempScrollAreaWidgetContents);

    ui->tabWidget->setCurrentIndex(tabCount);
 }

void MainWindow::closeTab(int index)
{
        ui->tabWidget->removeTab(index);
        /*!
         * as the display area document is passed in the constuctor deleting the parents lead to the delete of child
         * hence highlighter should not be deleted
         * the distructor of the highlighter is called by display area it self
         */
        highlighter.removeAt(index);

        delete displayArea.at(index);
        displayArea.removeAt(index);

        delete gridLayout2.at(index);
        gridLayout2.removeAt(index);

        delete scrollAreaWidgetContents.at(index);
        scrollAreaWidgetContents.removeAt(index);

        delete scrollArea.at(index);
        scrollArea.removeAt(index);

        delete gridLayout.at(index);
        gridLayout.removeAt(index);

        delete tab.at(index);
        tab.removeAt(index);

        fileName.removeAt(index);

        if(ui->tabWidget->count()==0)
            this->close();

}

void MainWindow::closeEvent(QCloseEvent *event)
 {
    if(flags.debugging==true) {
        QMaemo5InformationBox::information(0, "Program is in Debuggin mode stop it before closeing",QMaemo5InformationBox::DefaultTimeout);
        event->ignore();
        return;
    }

    bool closeFlag=true;

    QFile fileData("/home/user/.edicom");
    fileData.open(QFile::WriteOnly | QFile::Truncate);


    QString text="";
    for(int i=0;i<ui->keywordList->count();i++) {
        text+=ui->keywordList->item(i)->text()+"\n";
    }
    QTextStream out(&fileData);
    out <<text;
    fileData.close();

    if(gdbThread.isRunning())
        gdbThread.terminate();
    if(scanfThread.isRunning())
        scanfThread.terminate();


    for(int i=0;i<ui->tabWidget->count();i++) {
        if(!maybeSave(i))
            closeFlag=false;
        else
            i--;

    }

     if (closeFlag) {
        event->accept();
     } else {
         event->ignore();
     }


 }

void MainWindow::compile()
 {
    if(ui->tabWidget->count()==0)
        return;

    if(flags.running==true) {
        QMaemo5InformationBox::information(0, "Program is in Execution mode",QMaemo5InformationBox::DefaultTimeout);
        return;
    }

    if(flags.debugging==true) {
        QMaemo5InformationBox::information(0, "Program is in Debuggin mode",QMaemo5InformationBox::DefaultTimeout);
        return;
    }

    int currentTab=ui->tabWidget->currentIndex();
    QFile data(".temp.c");
        if (data.open(QFile::WriteOnly | QFile::Truncate)) {
            QTextStream out(&data);
            QString str=displayArea.at(currentTab)->toPlainText();
            if(str.contains("fcntl.h")==false)
            {
                disconnect(displayArea.at(currentTab),SIGNAL(textChanged()),this,SLOT(documentModified()));
                displayArea.at(currentTab)->setPlainText("#include<fcntl.h>\n"+str);
                connect(displayArea.at(currentTab),SIGNAL(textChanged()),this,SLOT(documentModified()));
                str="#include<fcntl.h>\n"+str;
            }
            int ind=str.indexOf("main()\n{",0);
            str.insert(ind+8,"setvbuf(stdout,NULL,_IONBF,0);int fdesc=open(\"/tmp/.PIN\",O_RDONLY);close(0);if(fcntl(fdesc,F_DUPFD,0)==-1){printf(\"counldn\");}fdesc=open(\"/tmp/.POUT\",O_WRONLY);close(1);if(fcntl(fdesc,F_DUPFD,1)==-1){printf(\"counldn\");}FILE *f=fopen(\"/tmp/pid.ec\",\"w\");fprintf(f,\"%d\",getpid());fclose(f);");
            out <<str;
         }

    if(system("gcc -g -o .temp .temp.c 2>.compiled.txt")==0)
    {
        flags.setCompiledStatus(true);
        this->compiledTab=currentTab;
        currentFileTab=currentTab;
        QMaemo5InformationBox::information(0, "Compiled successfully",QMaemo5InformationBox::DefaultTimeout);
    }
    else
    {
         QFile file(".compiled.txt");
         file.open(QFile::ReadOnly | QFile::Text);
         QTextStream in(&file);
         QApplication::setOverrideCursor(Qt::WaitCursor);
         QMessageBox::warning(this,tr("Compilation"), in.readAll());
         QApplication::restoreOverrideCursor();
         flags.setCompiledStatus(false);
    }
}

void MainWindow::run()
{
    if(ui->tabWidget->count()==0)
        return;

    compile();
    if(flags.running==true) {
        QMaemo5InformationBox::information(0, "Program is already Executing",QMaemo5InformationBox::DefaultTimeout);
        return;
    }

    if(flags.debugging==true) {
        QMaemo5InformationBox::information(0, "Program is in Debugging mode",QMaemo5InformationBox::DefaultTimeout);
        return;
    }

     if(flags.getCompiledStatus() && flags.debugging==false) {
        system("killall .temp 2> /tmp/.wst");
        system("killall gdb 2> /tmp/.wst");
        flags.running=true;

         if(flags.firstRun==false)
             delete t;
         this->hide();
         t=new Terminal();
         t->show();
         connect(t,SIGNAL(terminalExiting()),this,SLOT(terminalExiting()));
         flags.firstRun=false;
     }
     else
         QMaemo5InformationBox::information(0, "Program has few errors",QMaemo5InformationBox::DefaultTimeout);
}

void MainWindow::highlightDebuggingLine(int linenum,int color)
 {
    ui->tabWidget->setCurrentIndex(this->currentFileTab);

    QTextBlock block=displayArea.at(currentFileTab)->firstVisibleBlk();
    block.begin();
    int first_vis_line=block.firstLineNumber();
    for(int i=0;i<linenum-first_vis_line;i++)
        block=block.next();

    QScrollBar *sb=scrollArea.at(currentFileTab)->verticalScrollBar();
    if(sb->value()<(30*(linenum-8)) || sb->value()>(30*(linenum+4)))
    {
        QScrollBar *sb=scrollArea.at(currentFileTab)->verticalScrollBar();
        sb->setSliderPosition(25*linenum-1);

        block=displayArea.at(currentFileTab)->firstVisibleBlk();
        block.begin();
        first_vis_line=block.firstLineNumber();
        for(int i=0;i<linenum-first_vis_line;i++)
            block=block.next();
    }
         QTextCursor cur(block);
         QList<QTextEdit::ExtraSelection> extraSelections;
         QTextEdit::ExtraSelection selection;

         QColor lineColor;
         if(color==0)
            lineColor = QColor(Qt::lightGray);
         else
            lineColor = QColor(Qt::white);

         selection.format.setBackground(lineColor);
         selection.format.setProperty(QTextFormat::FullWidthSelection, true);
         selection.cursor = cur;
         selection.cursor.clearSelection();
         extraSelections.append(selection);
         displayArea.at(currentFileTab)->setExtraSelections(extraSelections);
 }

void MainWindow::addBreakPoint()
{
    if(ui->tabWidget->count()==0)
        return;

    QString temp="b "+ui->breakLineEdit->text()+"\n";
    if(ui->breakLineEdit->text()!="\n")
        ::write(flags.wr,temp.toAscii().data(),temp.length());

    ui->breakLineEdit->hide();
}

void MainWindow::debug()
{
    if(ui->tabWidget->count()==0)
        return;

    char str[]="s\nbt\n",temp[500];
    if(flags.running==true) {
        QMaemo5InformationBox::information(0, "Program is in Execution mode",QMaemo5InformationBox::DefaultTimeout);
        return;
    }

    if(flags.getCompiledStatus())
    {
        if(!scanfThread.isRunning())
            scanfThread.start();

        if(!gdbThread.isRunning())
        {
            QAction *c=qobject_cast<QAction *>(sender());
            QString menuClicked=c->text();
            if(menuClicked=="stopdebug") {
                QMaemo5InformationBox::information(0, "No debugging program to stop from debugging",QMaemo5InformationBox::DefaultTimeout);
                return;
            }

            displayArea.at(compiledTab)->setReadOnly(true);
            outputString="";
            ::unlink("/tmp/.buf");

            /*!
             * temp
             */
            QFile dat(".temp.c");
            QByteArray line;
            int lineNum=0;
            dat.open(QFile::ReadOnly | QFile::Text);

            while((line=dat.readLine(100))!="") {
                QString temp=QString(line);
                lineNum++;
                if(temp.contains("main()"))
                    break;
            }
            dat.close();

            QFile fileData("/tmp/.a");
            QString s="set logging file .gdb.txt\nset logging on\nstart\nb "+QString::number(lineNum+2)+"\nc\nbt\n";
            if (fileData.open(QFile::WriteOnly | QFile::Truncate)) {
                QTextStream out(&fileData);
                out <<s;
             }
            fileData.close();

//--------------------------------------------------------------------------------------------------------------------

            system("killall .temp 2> /tmp/.wst");
            system("killall gdb 2> /tmp/.wst");
            flags.debugging=true;

            scanfThread.scanfParam="";
            outputString="";
            gdbThread.start();
            scanfThread.start();
            gdbOutput.start();
            outputThread.start();

            flags.wr=::open("/tmp/.INFIFO",O_WRONLY,0);
            flags.rd=::open("/tmp/.OUTFIFO",O_RDONLY,0);

            sleep(1);
            strcpy(temp,"bt\n");
            ::write(flags.wr,temp,strlen(temp));

            QString temporary="";
            for(int i=0;i<watchVariablesList.length();i++)
            {
                temporary+="disp "+watchVariablesList[i]+"\n";
            }
            ::write(flags.wr,temporary.toAscii().data(),strlen(temporary.toAscii().data()));

            return;
        }
        QAction *c=qobject_cast<QAction *>(sender());
        QString menuClicked=c->text();

        if(menuClicked=="step")
        {
            ::write(flags.wr,str,strlen(str));
        }
        if(menuClicked=="continue")
        {
            strcpy(str,"c\nbt\n");
            ::write(flags.wr,str,strlen(str));
        }
        if(menuClicked=="breakpoint")
        {
            ui->breakLineEdit->show();
            ui->breakLineEdit->focusWidget();
        }
        if(menuClicked=="stopdebug" && flags.debugging==true)
        {
            stopDebug();
        }
    }
    else
        QMaemo5InformationBox::information(0, "Program is not in debugging mode",QMaemo5InformationBox::DefaultTimeout);
}

void MainWindow::updateLineNumber(QString str)
{
    QStringList line= str.split("\n");
    for(int i=0;i<line.length();i++) {

        if(line[i].contains("#0")) {

            if(line[i].endsWith("/lib/libc.so.6")) {
                stopDebug();
                return;
            }

            QStringList lineContent= line[i].split(" ");
            QStringList lineNum=lineContent[lineContent.length()-1].split(":");
            QString file=lineNum[0];

            /*!
             * check whether the extra selection moved to other file
             */
            if(file.compare(".temp.c")!=0 || currentFileTab!=compiledTab) {
                int k;
                if(!file.startsWith("/") && file.compare(".temp.c")!=0) {
                    file=QDir::currentPath()+"/"+file;
                }

                for(k=0;k<ui->tabWidget->count();k++) {
                    qDebug()<<"not same file hiya "<<fileName.at(k)<<" : "<<QDir::currentPath()+"/"+file;
                    if(file.compare(fileName.at(k))==0)
                        break;
                }

                if(file.compare(".temp.c")==0){
                    highlightDebuggingLine(0,1);
                    currentFileTab=compiledTab;
                    ui->tabWidget->setCurrentIndex(currentFileTab);
                    highlightDebuggingLine(0,1);
                }else if(k==ui->tabWidget->count()) {
                    highlightDebuggingLine(0,1);
                    open(file);
                    displayArea.at(currentFileTab)->setReadOnly(true);
                    currentFileTab=ui->tabWidget->count()-1;
                    ui->tabWidget->setCurrentIndex(currentFileTab);
                    highlightDebuggingLine(0,1);
                }
                else
                {
                    highlightDebuggingLine(0,1);
                    currentFileTab=k;
                    displayArea.at(k)->setReadOnly(true);
                    ui->tabWidget->setCurrentIndex(currentFileTab);
                    highlightDebuggingLine(0,1);
                }
            }
//////////////////////////////////////////////////////////////
            bool bo;
            int num=lineNum[1].toInt(&bo,10);

            if(num==0)
            {
                stopDebug();
                return;
            }
                flags.debugging_line=num-1;
                highlightDebuggingLine(flags.debugging_line);
        }
        for(int j=0;j<watchVariablesList.length();j++)
        {
            if(line[i].contains(QRegExp("[0-9]+[:][ ]"+watchVariablesList[j]))) {
                ui->watchWindow->item(j)->setText(( line[i].mid(line[i].indexOf(watchVariablesList[j]+" = ")) ));
            }
        }
    }
}

void MainWindow::stopDebug()
{
    if(ui->tabWidget->count()==0)
        return;

    if(gdbOutput.stopFlag==false)
    {
        QString str="q\ny\n";

        gdbOutput.stopFlag=true;
        outputThread.stopFlag=true;
        sleep(1);
        highlightDebuggingLine(0,1);
        flags.debugging=false;
        scanfThread.stopFlag=true;
        flags.setCompiledStatus(false);
        displayArea.at(compiledTab)->setReadOnly(false);
        ::write(flags.wr,str.toAscii().data(),str.length());

        QMaemo5InformationBox::information(0, "program exited from debuggging mode",QMaemo5InformationBox::DefaultTimeout);

        compiledTab=-1;
        currentFileTab=-1;
        for(int i=0;i<ui->tabWidget->count();i++)
            displayArea.at(i)->setReadOnly(false);
    }
}

void MainWindow::updateDisplay(QString str)
{
    QFile file("/tmp/.buf");
    QString temp="";
    if(file.open(QFile::ReadOnly | QFile::Text))
    {
        QTextStream data(&file);
        temp=data.readAll();
    }
    str=temp+str;

    outputString+=str;
    scanfThread.scanfParam=outputString;

    QFile d("/tmp/.buf");
    if (!d.open(QFile::WriteOnly | QFile::Truncate))
    {
        d.close();
    }
}

void MainWindow::showScanDialog(QString str)
{
}

void MainWindow::terminalExiting()
{
    this->show();
    flags.running=false;
}
