#include "terminal.h"
#include "ui_terminal.h"
#include<fcntl.h>
#include<unistd.h>
//#include<QDebug>

#include "exethread.h"
#include "outputthread.h"

Terminal::Terminal(QWidget *parent) :
    QMainWindow(parent),
    m_ui(new Ui::Terminal)
{
    m_ui->setupUi(this);
            mkfifo("/tmp/.INFIFO",0777);
            mkfifo("/tmp/.OUTFIFO",0777);
            mkfifo("/tmp/.PIN",0777);
            mkfifo("/tmp/.POUT",0777);

    connect(&outputThread,SIGNAL(update(QString )),this,SLOT(updateDisplay(QString)));
    connect(&exeThread,SIGNAL(finished()),this,SLOT(killer()));

    connect(&scanfThread,SIGNAL(showScanDialog()),this,SLOT(showScanDialog()));
    exeThread.start();
    outputThread.start(QThread::HighPriority);
    scanfThread.start();
    m_ui->dispArea->setReadOnly(true);
    charCountBefourScanf=0;
    fl=::open("/tmp/.PIN",O_RDWR|O_NONBLOCK|O_NOCTTY);
    fpointer=::open("/tmp/.POUT",O_RDWR|O_NONBLOCK|O_NOCTTY);
    m_ui->dispArea->installEventFilter(this);
}

Terminal::~Terminal()
{
    delete m_ui;
}
void Terminal::showScanDialog()
{
    m_ui->dispArea->setReadOnly(false);
    scanfThread.suspend();
    charCountBefourScanf=m_ui->dispArea->toPlainText().length();
    connect(m_ui->dispArea,SIGNAL(textChanged()),this,SLOT(returnPressed()));
    endPoint=m_ui->dispArea->textCursor().position();
}
void Terminal::returnPressed()
{
    if(m_ui->dispArea->toPlainText().endsWith("\n"))
    {
        QString enteredStr=m_ui->dispArea->toPlainText().mid(charCountBefourScanf);
        if(enteredStr!="\n" && enteredStr.length()>1)
        {
            char str[200];
            strcpy(str,"scanf 1 \"");
            strcat(str,enteredStr.toAscii().data());
            strcat(str,"\" ");
            //write(fl,str,strlen(str));
            //qDebug()<<str;
            system(str);
            disconnect(m_ui->dispArea,SIGNAL(textChanged()),this,SLOT(returnPressed()));
            scanfThread.resume();
            m_ui->dispArea->moveCursor(QTextCursor::End,QTextCursor::MoveAnchor);
            m_ui->dispArea->setReadOnly(true);
            /*
            enteredStr=enteredStr.trimmed();
            char str[20];
            m_ui->lineEdit->setText(enteredStr);
            system("scanf");
            m_ui->dispArea->setReadOnly(true);
            scanfThread.resume();
            disconnect(m_ui->dispArea,SIGNAL(textChanged()),this,SLOT(returnPressed()));*/
        }
    }
}
void Terminal::killer()
{
    sleep(1);
    scanfThread.stopFlag=true;
    outputThread.stopFlag=true;
}
void Terminal::changeEvent(QEvent *e)
{
    QMainWindow::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        m_ui->retranslateUi(this);
        break;
    default:
        break;
    }
}
void Terminal::updateDisplay(QString str)
{
    //m_ui->dispArea->appendPlainText(str);
    m_ui->dispArea->insertPlainText(str);
    endPoint=m_ui->dispArea->textCursor().position();
}
void Terminal::closeEvent(QCloseEvent *event)
{
    ::close(fl);
    ::close(fpointer);
    scanfThread.stopFlag=true;
    outputThread.stopFlag=true;
    sleep(1);

    if(scanfThread.isRunning())
        scanfThread.terminate();
    if(outputThread.isRunning())
        outputThread.terminate();
    if(exeThread.isRunning())
        exeThread.terminate();

    emit terminalExiting();
    event->accept();
}
bool Terminal::eventFilter(QObject *obj, QEvent *event)
{
//       qDebug()<<"reached";
    int p=m_ui->dispArea->textCursor().position();
    if (obj == m_ui->dispArea)
    {
        if (event->type() == QEvent::KeyPress)
        {
            QKeyEvent *keyEvent = static_cast<QKeyEvent*>(event);
            //qDebug() << "Ate key press" << keyEvent->key();  //16777219
            //qDebug()<<"p    :"<<p;
            //qDebug()<<"endPoint:"<<endPoint;

            if(keyEvent->key()==16777234 || keyEvent->key()==16777219)
            {
                if(p-1>=endPoint)
                {
                    return false;
                }
                else
                    return true;
            }
            if(keyEvent->key()==16777236 )
            {
                if(p+1>=endPoint)
                {
                    return false;
                }
                else
                    return true;
            }
            return false;
        }
        else
        {
            return false;
        }
    }
    else
    {
        return Terminal::eventFilter(obj, event);
    }
}
