#ifndef UICONTROLLER_H
#define UICONTROLLER_H

#include "routedata.h"
#include "logic/location.h"

#include <QObject>

class UiClass;

class UiController : public QObject
{
  Q_OBJECT

public:
  UiController( UiClass *ui );
  ~UiController();

public Q_SLOTS:
  void displayRoute( const QList<RouteData> &routeData );
  //void updateLocationSelectors();
  void changeFrom();
  void changeTo();
  void gpsBecameValid();

Q_SIGNALS:
  void routeSearchRequested();
  void fromChanged(Location *newFromLocation);
  void toChanged(Location *newToLocation);

private Q_SLOTS:
  void changeRoute( int id );
  void displayRouteDetail( int id );
  void findRoute();

private:
  QList<RouteData> m_routeData;
  UiClass *m_ui;
  int m_currentRoute;
};
#endif // UICONTROLLER_H

