#!/usr/bin/env python

import os
import sys


import msgfmt # also distributed with zim


# Some constants

PO_FOLDER = sys.argv[1]
LOCALE_FOLDER = sys.argv[2]


# Helper routines

def get_mopath(pofile):
	# Function to determine right locale path for a .po file
	lang = os.path.basename(pofile)[:-3] # len('.po') == 3
	modir = os.path.join(LOCALE_FOLDER, lang, 'LC_MESSAGES')
	mofile = os.path.join(modir, 'zim.mo')
	return modir, mofile



for pofile in [f for f in os.listdir(PO_FOLDER) if f.endswith('.po')]:
	pofile = os.path.join(PO_FOLDER, pofile)
	modir, mofile = get_mopath(pofile)

	if not os.path.isdir(modir):
		os.makedirs(modir)

	if not os.path.isfile(mofile):
		print 'compiling %s' % mofile
		msgfmt.make(pofile, mofile)