#!/usr/bin/env python
# -*- coding: utf-8 -*-

# Copyright (c) 2011 Boris Pohler <boris@pohlers-web.de>

# Permission is hereby granted, free of charge, to any person obtaining a
# copy of this software and associated documentation files (the "Software"),
# to deal in the Software without restriction, including without limitation
# the rights to use, copy, modify, merge, publish, distribute, sublicense,
# and/or sell copies of the Software, and to permit persons to whom the
# Software is furnished to do so, subject to the following conditions:

# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.

# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
# THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
# FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
# DEALINGS IN THE SOFTWARE.


# Importe
import sys
import os
import pickle
from PyQt4.uic import loadUi
from PyQt4.QtGui import QMainWindow, QApplication, QInputDialog, QMenu, \
                        QCursor, QMessageBox, QDialog
from PyQt4.QtCore import QObject, QString, QTimer, QTime, Qt
from PyQt4.QtMaemo5 import *

class Zeitkonto():
    def __init__(self, name = "Projekt"):
        self.name = name
        self.zeit = 0

class Dialog_Zeit(QDialog):
    def __init__(self,parent):
        QDialog.__init__(self,parent=None)
        self.ui = loadUi("dialog_zeit.ui")
        #self.ui.show()

class Fenster_Zeitkonto(QMainWindow):
    def __init__(self):
        QMainWindow.__init__(self)
        # Oberfläche abbilden     
        self.ui = loadUi("zeitkonto.ui")
        self.ui.show()
 
        self.zeitkonten_liste= [Zeitkonto()]
       
        if os.path.isfile("/home/user/MyDocs/.zeitkonto/zeitkonten.db"):
           print "File existiert"
        else:
           os.makedirs("/home/user/MyDocs/.zeitkonto")
           print "Verzeichnis erstellt"
           self.liste_speichern()
           print "Datei gespeichert"
        
       
        self.liste_laden()
        self.anzeige_aktualisieren()

        self.timer = QTimer()
        self.timer.setInterval(500)
        self.zeit = QTime()

        self.zeit0 = 0

        self.ui.listWidget.setContextMenuPolicy(Qt.CustomContextMenu)
	self.ui.listWidget.currentRowChanged.connect(self.auswahl_geaendert)
        self.ui.listWidget.customContextMenuRequested.connect(self.zeigeKontextMenu)
        self.ui.knopf_start.clicked.connect(self.timer_starten)
        self.ui.knopf_stopp.clicked.connect(self.timer_stoppen)
        self.timer.timeout.connect(self.zeitanzeige_aktualisieren)
        self.ui.action_ueber.triggered.connect(self.zeige_ueber)       


    def zeigeKontextMenu(self):
        menu = QMenu()
        menu.addAction(u'Konto hinzufügen')
        menu.addAction(u'Konto löschen')
        menu.addAction(u'Zeit bearbeiten')
        menu.addAction(u'Kontoname bearbeiten')
	pos = QCursor.pos()
        id = menu.exec_(pos)
  
        if id and id.text() == u'Konto hinzufügen':
            self.zeitkonto_anlegen()
        if id and id.text() == u'Konto löschen':
            self.zeitkonto_loeschen()
        if id and id.text() == u'Kontoname bearbeiten':
            self.konto_name_bearbeiten()
        if id and id.text() == u'Zeit bearbeiten':
            self.konto_zeit_bearbeiten()

    def anzeige_aktualisieren(self):
        self.ui.listWidget.clear()
        for konto in self.zeitkonten_liste:
            self.ui.listWidget.addItem(konto.name)

    def auswahl_geaendert(self, zeile):
        if self.zeitkonten_liste:
            self.zeile = zeile
            self.konto = self.zeitkonten_liste[zeile]
            self.zeit0 = self.konto.zeit
            msecs = self.zeit0
            msecs /= 1000
            sec = msecs % 60
            msecs /= 60
            min = msecs % 60
            msecs /= 60
            hours = msecs
            timestring = '%02d:%02d:%02d' % (hours, min, sec)
            self.ui.label_zeit.setText(timestring)
            self.ui.label_name.setText(self.konto.name)
        else:
            self.ui.label_zeit.setText("00:00:00")
            self.ui.label_name.setText("")
        
    def zeitkonto_anlegen(self):
        text, ok = QInputDialog.getText(self, u'Zeitkonto anlegen', 
                                              u'Gib dem Konto einen Namen:')
        if ok:
            konto = Zeitkonto(text)
            self.zeitkonten_liste.append(konto)
            self.anzeige_aktualisieren()
            self.liste_speichern()

    def zeitkonto_loeschen(self):
        reply = QMessageBox.question(self, u"Achtung!",
                                           u"Wollen sie das Konto wirklich löschen?",
                                           QMessageBox.No | QMessageBox.Yes)
        if reply == QMessageBox.Yes:
            del self.zeitkonten_liste[self.zeile]
            self.anzeige_aktualisieren()
            self.liste_speichern()

    def konto_name_bearbeiten(self):
        text, ok = QInputDialog.getText(self, u'Name ändern', 
                                              u'Gib den neuen Namen ein:')
        if ok:
            self.zeitkonten_liste[self.zeile].name = text
            self.anzeige_aktualisieren()
            self.liste_speichern()

    def konto_zeit_bearbeiten(self):
        self.dialog = QDialog(self)
        self.dialog.ui = loadUi("dialog_zeit.ui") 
	if self.dialog.ui.exec_() == 1:
           stunden = self.dialog.ui.stunden.value()
           minuten = self.dialog.ui.minuten.value()
           sekunden = self.dialog.ui.sekunden.value()
           self.konto.zeit = stunden * 3600000 \
                           + minuten * 60000 \
                           + sekunden * 1000
           self.zeit0 = self.konto.zeit
           msecs = self.zeit0
           msecs /= 1000
           sec = msecs % 60
           msecs /= 60
           min = msecs % 60
           msecs /= 60
           hours = msecs
           timestring = '%02d:%02d:%02d' % (hours, min, sec)
           self.ui.label_zeit.setText(timestring)
           #self.ui.label_name.setText(self.konto.name)
           

    def liste_laden(self):
        f = open("/home/user/MyDocs/.zeitkonto/zeitkonten.db",'r')
   	self.zeitkonten_liste = pickle.load(f)
        f.close()
    
    def liste_speichern(self):
        f = open("/home/user/MyDocs/.zeitkonto/zeitkonten.db",'w')
   	pickle.dump(self.zeitkonten_liste,f)
        f.close()

    def timer_starten(self):
        self.ui.listWidget.hide()
        self.ui.label_2.hide()
        self.zeit.start()
        self.timer.start()
        self.ui.knopf_start.setEnabled(False)

    def timer_stoppen(self):
        self.ui.listWidget.show()
        self.ui.label_2.show()
        timestring = self.ui.label_zeit.text().split(QString(':'))
        zeit0 = int(timestring[0])*3600000 \
              + int(timestring[1])*60000 \
              + int(timestring[2])*1000
        self.konto.zeit = zeit0
        self.ui.knopf_start.setEnabled(True)
        self.timer.stop()
        self.liste_speichern()
    
    def zeitanzeige_aktualisieren(self):
        msecs = self.konto.zeit + self.zeit.elapsed()
        msecs /= 1000
        sec = msecs % 60
        msecs /= 60
        min = msecs % 60
        msecs /= 60
        hours = msecs
        timestring = '%02d:%02d:%02d' % (hours, min, sec)
        self.ui.label_zeit.setText(timestring)

    def zeige_ueber(self):
        QMessageBox.about(self, 
                          u"Über das Programm",u"""<b>Zeitkonten</b>
                          <p>Das Programm bietet die Möglichkeit, Zeitkonten für
                             verschiedene Aufgaben anzulegen und die verwendete Zeit
                             dafür zu stoppen. 
                             Mit einem langen Druck auf die Liste öffnet sich ein Menü.
                          <p>Wünsche oder Kritik bitte an 
                          <p>boris@pohlers-web.de""")

# Starten des Programms
if __name__=="__main__":
    # Qt-Umgebung erzeugen
    app=QApplication(sys.argv)
    # ein Objekt mit dem Namen fenster aus unserer Klasse
    # Minimalbeispiel erzeugen
    fenster=Fenster_Zeitkonto()
    # Programmende
    sys.exit(app.exec_())


