# -.- coding: utf-8 -.-

# Zeitgeist FTS Extension Test Harness
#
# Copyright © 2010 Canonical Ltd
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU Lesser General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
# Author:
#         Mikkel Kamstrup Erlandsen <mikkel.kamstrup@canonical.com>
#

import os, sys
if not os.getenv("ZEITGEIST_FTS_TESTS"):
	print >> sys.stderr, " ** Please only run the Zeitgeist FTS test via the test.sh script"
	raise SystemExit(1)

import dbus
from zeitgeist.client import ZeitgeistDBusInterface
from zeitgeist.datamodel import Event, Subject, TimeRange, ResultType, Interpretation, Manifestation

_bus = dbus.SessionBus()
_fts = _bus.get_object('org.gnome.zeitgeist.Engine',
                      '/org/gnome/zeitgeist/index/activity')
fts = dbus.Interface(_fts, 'org.gnome.zeitgeist.Index')
client = ZeitgeistDBusInterface()
result_type_relevancy=100

ev = Event.new_for_values(actor="application://firefox.desktop",
                          subject_interpretation=Interpretation.RASTER_IMAGE,
                          subject_manifestation=Manifestation.REMOTE_DATA_OBJECT,                          
                          subject_uri="http://example.com/image.jpg",
                          subject_text="text")
ids = client.InsertEvents([ev])

# Searching, unfiltered, for 'text' should give us our single event
results, count = fts.Search('text', TimeRange.always(), [],
                            0, 10, result_type_relevancy)
results = map(Event, results)
assert len(results) == 1, len(results)
assert len(results[0].subjects) == 1, len(results[0].subjects)
assert results[0].subjects[0].interpretation == Interpretation.RASTER_IMAGE, results[0].interpretation
assert results[0].subjects[0].uri == "http://example.com/image.jpg", results[0].subjects[0].uri
assert count == 1, count

# Searching for 'text' but filtering on DOCUMENTs should give 0 results
template = Event.new_for_values(subject_interpretation=Interpretation.DOCUMENT)
results, count = fts.Search('text', TimeRange.always(), [template],
                            0, 10, result_type_relevancy)
results = map(Event, results)
assert len(results) == 0, len(results)
assert count == 0, count

# Searching for 'text' and filtering on IMAGEs should still give 1 result
template = Event.new_for_values(subject_interpretation=Interpretation.IMAGE)
results, count = fts.Search('text', TimeRange.always(), [template],
                            0, 10, result_type_relevancy)
results = map(Event, results)
assert len(results) == 1, len(results)
assert len(results[0].subjects) == 1, len(results[0].subjects)
assert results[0].subjects[0].interpretation == Interpretation.RASTER_IMAGE, results[0].interpretation
assert results[0].subjects[0].uri == "http://example.com/image.jpg", results[0].subjects[0].uri
assert count == 1, count

