#
# Copyright 2010 Ruediger Gad <r.c.g@gmx.de>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

import gtk
import hildon
import string

keymap = {
  32: "space",
  65507: "Control_L",
  65288: "Backspace",
  65361: "Left",
  65362: "Up",
  65363: "Right",
  65364: "Down",
  65421: "Return",
  65505: "Shift_L"
  }

buttonLabelMap = {
  'A': 'A',
  'B': 'B',
  'C': 'C',
  'D': 'D',
  'GL': 'Left',
  'GR': 'Right',
  'GU': 'Up',
  'GD': 'Down'
  }

class MappingField():
  def __init__ (self, box, parent, k, v):
      self.parent = parent
      self.k = k

      hbox = gtk.HBox(False, 0)
      box.add(hbox)

      button = gtk.Button(buttonLabelMap[k])
      button.connect("clicked", self.callback)
      hbox.pack_start(button, True, True, 0)
      button.show()

      self.label = gtk.Label(string.split(v[0], ' ')[1])
      hbox.pack_start(self.label, True, True, 0)
      self.label.show()

  def callback(self, button):
      self.dialog = gtk.Dialog()
      self.dialog.set_transient_for(self.parent.getWindow())
      self.dialog.set_title("Press Key")
      self.dialog.connect("key-press-event", self.keyPressed, button.get_label())
      self.dialog.show_all()
      
  def keyPressed(self, dialog, event, b_title):
      keyval = event.keyval

      print "Key pressed. Got value: %d" % keyval

      if keyval != 32 and keyval < 256 :
        key = chr(event.keyval)
      else :
        key = keymap[keyval]

      print "Setting '" + key + "' for " + self.k
      self.dialog.destroy()

      mapping = self.parent.getMapping()
      mapping[self.k] = ["a " + key]
      self.label.set_label(key)

