#
# Copyright 2010 Ruediger Gad <r.c.g@gmx.de>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

import dbus
import gconf
import gtk
import os
import sys
from threading import Thread
import time

from XControl import XControl
from Zeemote import ZeeDiscover, Zeemote, buttonmap

# If a user config directory is present try to load mappings
# from there.
userConfigPath = os.getenv("HOME") + "/.zeecontrol"
sys.path.append(userConfigPath)
import UserMappings

class ZeemoteEventThread(Thread):
  def __init__ (self, zeeBtn):
    Thread.__init__(self)
    self.setDaemon(True)
    self.zeeBtn = zeeBtn
    self.control = XControl()

    self.mapping = UserMappings.mappingA
    self.altMapping = UserMappings.altMappingA

    self.pressed={
      'A': [False],
      'B': [False],
      'C': [False],
      'D': [False],
      'GU': [False],
      'GD': [False],
      'GL': [False],
      'GR': [False]
      }

    self.altPressed={
      'A': [False],
      'B': [False],
      'C': [False],
      'D': [False],
      'GU': [False],
      'GD': [False],
      'GL': [False],
      'GR': [False]
      }

    bus = dbus.SystemBus()
    mceObj = bus.get_object("com.nokia.mce", "/com/nokia/mce/request")
    self.mceIf = dbus.Interface(mceObj, "com.nokia.mce.request")
    displayTimeout = gconf.client_get_default().get_int("/apps/osso/applet/osso-applet-display/brightness_period") 
    self.timeout = displayTimeout * 0.5

  def run(self):
    buttons='ABCD'
    xpon=False
    ypon=False
    xnon=False
    ynon=False
    TOLERANCE=18000

    discover = ZeeDiscover()
    self.zee = discover.getZeemote( (self.zeeBtn.getId() - 1) )
    state = self.zee.getState()

    timestamp = time.time()
    self.mceIf.req_tklock_mode_change("unlocked")
    self.zeeBtn.signalConnected()

    while state.isConnected() :
      self.zee.waitForData()
      state = self.zee.getState()

      # This hack is used to avoid the system going into standby mode.
      # This is needed because the xtest events used by zeecontrol for 
      # "emulating" keyboard actions etc. seem not to be taken as "real" 
      # user input, hence the standby timeout is not being reset.
      currentTime = time.time()
      if (currentTime - timestamp) > self.timeout:
        timestamp = currentTime
        self.mceIf.req_tklock_mode_change("unlocked")

#      print "button mask %d" % state.getButtonMask()

      # Adjust sign and axis association here in order
      # to keep the code taken from wiicontrol below.
      gy=-state.getX()
      gx=-state.getY()

#      print str(gx)+ " " + str(gy)
      buttonmask = state.getButtonMask()

      #X is positive
      if gx > TOLERANCE and not xpon:
        xpon = True
        if not UserMappings.useAlt:
          self.control.executeScript(self.mapping["GU"])
        else:
          if buttonmask & buttonmap[UserMappings.altButton]:
            self.control.executeScript(self.altMapping["GU"])
          else:
            self.control.executeScript(self.mapping["GU"])
      if xpon and gx < TOLERANCE and gx > -TOLERANCE:
        xpon = False
        self.control.executeReleasedScript(self.mapping["GU"])
        if UserMappings.useAlt:
          self.control.executeReleasedScript(self.altMapping["GU"])
      #X is negative
      if gx < -TOLERANCE and not xnon:
        xnon = True
        if not UserMappings.useAlt:
          self.control.executeScript(self.mapping["GD"])
        else: 
          if buttonmask & buttonmap[UserMappings.altButton]:
            self.control.executeScript(self.altMapping["GD"])
          else:
            self.control.executeScript(self.mapping["GD"])
      if xnon and gx < TOLERANCE and gx > -TOLERANCE:
        xnon = False
        self.control.executeReleasedScript(self.mapping["GD"])
        if UserMappings.useAlt:
          self.control.executeReleasedScript(self.altMapping["GD"])
             
      #Y is positive
      if gy > TOLERANCE and not ypon:
        ypon = True
        if not UserMappings.useAlt:
          self.control.executeScript(self.mapping["GL"])
        else:
          if  buttonmask & buttonmap[UserMappings.altButton]:
            self.control.executeScript(self.altMapping["GL"])
          else:
            self.control.executeScript(self.mapping["GL"])
      if ypon and gy < TOLERANCE and gy > -TOLERANCE:
        ypon = False
        self.control.executeReleasedScript(self.mapping["GL"])
        if UserMappings.useAlt:
          self.control.executeReleasedScript(self.altMapping["GL"])
      #Y is negative
      if gy < -TOLERANCE and not ynon:
        ynon = True
        if not UserMappings.useAlt:
          self.control.executeScript(self.mapping["GR"])
        else:
          if buttonmask & buttonmap[UserMappings.altButton]:
            self.control.executeScript(self.altMapping["GR"])
          else:
            self.control.executeScript(self.mapping["GR"])
      if ynon and gy < TOLERANCE and gy > -TOLERANCE:
        ynon = False
        self.control.executeReleasedScript(self.mapping["GR"])
        if UserMappings.useAlt:
          self.control.executeReleasedScript(self.altMapping["GR"])

      for bb in buttons:
        if (buttonmask & buttonmap[bb]):          
          if not UserMappings.useAlt:
            self.control.executeScript(self.mapping[bb])
            self.pressed[bb]=True
          elif bb != UserMappings.altButton:
            if buttonmask & buttonmap[UserMappings.altButton] :
              self.control.executeScript(self.altMapping[bb])
              self.altPressed[bb]=True                      
            else:
              self.control.executeScript(self.mapping[bb])
              self.pressed[bb]=True
        elif (not (buttonmask & buttonmap[bb])):
          if self.pressed[bb] :
            self.pressed[bb]=False                          
            self.control.executeReleasedScript(self.mapping[bb])
          if UserMappings.useAlt and self.altPressed[bb] :
            self.altPressed[bb] = False
            self.control.executeReleasedScript(self.altMapping[bb])

      while gtk.events_pending():
      	gtk.main_iteration()                

    print "Leaving event thread..."

    for bb in buttons:
      if self.pressed[bb]==True:
        self.pressed[bb]=False                          
        self.control.executeReleasedScript(self.mapping[bb])

    gtk.main_quit()

  def getAltMapping(self):
    return self.altMapping

  def getMapping(self):
    return self.mapping

  def setAltMapping(self, newAltMapping):
    self.altMapping = newAltMapping

  def setMapping(self, newMapping):
    self.mapping = newMapping


