# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

# To generate X-window events, we use XTest library
# Use XTest extensions, by directly loading the shared library
import time
from ctypes import CDLL
Xtst = CDLL("libXtst.so.6")
Xlib = CDLL("libX11.so.6")

class XControl():
  def __init__(self):
    # Get the current display
    self.d = Xtst.XOpenDisplay(None)

  # Generate a keypress, given the keyname.
  def sendKey(self, key):
    sym = Xlib.XStringToKeysym(key)
    code = Xlib.XKeysymToKeycode(self.d, sym)
    Xtst.XTestFakeKeyEvent(self.d, code, True, 0)
    Xtst.XTestFakeKeyEvent(self.d, code, False, 0)
    Xlib.XFlush(self.d)

  def sendKeyDown(self, key):
    sym = Xlib.XStringToKeysym(key)
    code = Xlib.XKeysymToKeycode(self.d, sym)
    Xtst.XTestFakeKeyEvent(self.d, code, True, 0)
    Xlib.XFlush(self.d)

  def sendKeyUp(self, key):
    sym = Xlib.XStringToKeysym(key)
    code = Xlib.XKeysymToKeycode(self.d, sym)
    Xtst.XTestFakeKeyEvent(self.d, code, False, 0)
    Xlib.XFlush(self.d)

  def sendCtrlKey(self, key):
    self.sendKeyDown("Control_R")
    self.sendKey(key)
    self.sendKeyUp("Control_R")

  # Move the mouse to the given (absolute) coordinates
  def mouseMove(self, x, y):
    Xtst.XTestFakeMotionEvent(self.d, -1, x, y, 0);
    Xlib.XFlush(self.d)

  def mouseMoveRelative(self, x, y):
    Xtst.XTestFakeRelativeMotionEvent(self.d, -1, x, y, 0);
    Xlib.XFlush(self.d)

  # Click a mouse button (1:left, 2:right)
  def mouseClick(self, button):
    Xtst.XTestFakeButtonEvent( self.d, button, True, 0 );
    Xtst.XTestFakeButtonEvent( self.d, button, False, 0 );
    Xlib.XFlush(self.d)

  def stylusTap(self, x, y):
    Xtst.XTestFakeMotionEvent(self.d, -1, x, y, 0)
    Xtst.XTestFakeButtonEvent(self.d, 1, True, 0 );
    Xtst.XTestFakeButtonEvent(self.d, 1, False, 0 );
    Xlib.XFlush(self.d)

# Given a list of strings, each one being a valid command, execute the script
# Valid commands are:
#   "k name"   -> Sendkey(name)
#   "m x y"    -> MouseMove(x,y)
#   "b button" -> MouseClick(button)
#   "t x y"    -> StylusTap(x,y)
#   "s time"   -> sleep(time)
  def executeScript(self, script):
    for c in script:
      cmd=c.split()
      if cmd[0]=='k':
        aux=cmd[1].split('-')
        if len(aux)==1:
          self.sendKey(cmd[1])
        else:
          self.sendCtrlKey(aux[1])
      elif cmd[0]=='a':
        self.sendKeyDown(cmd[1])              
      elif cmd[0]=='b':
        self.mouseClick(int(cmd[1]))
      elif cmd[0]=='m':
        self.mouseMove(int(cmd[1]), int(cmd[2]))
      elif cmd[0]=='r':
        self.mouseMoveRelative(int(cmd[1]), int(cmd[2]))
      elif cmd[0]=='t':
        self.stylusTap(int(cmd[1]), int(cmd[2]))
      elif cmd[0]=='s':
        sleep(float(cmd[1]))
      else: break

  def executeReleasedScript(self, script):
    for c in script:
      cmd=c.split()  
      if cmd[0]=='a':
        self.sendKeyUp(cmd[1])
      else: break

