#
# Copyright 2010 Ruediger Gad <r.c.g@gmx.de>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

import gtk
import hildon
import string

from MappingField import MappingField

def open_mapping_settings(button, title, mapping):
  MappingSettings(title, mapping)

class MappingSettings():
  def __init__(self, title, mapping):
    self.mapping = mapping
    self.window = hildon.StackableWindow()
    self.window.set_title(title)

    self.fillWindow()

    stack = hildon.WindowStack.get_default()
    stack.push(self.window)
    self.window.show_all()

  def fillWindow(self):
    hbox = gtk.HBox(False, 0)
    self.window.add(hbox)
    hbox.show()

    vbox1 = gtk.VBox(False, 0)
    hbox.add(vbox1)
    vbox1.show()

    vbox2 = gtk.VBox(False, 0)
    hbox.add(vbox2)
    vbox2.show()

    n = 1
    for (k, v) in self.mapping.items():
      if n <= 4 :
        MappingField(vbox1, self, k, v)        
      else :
        MappingField(vbox2, self, k, v)        
      n+=1

  def getWindow(self):
    return self.window

  def getMapping(self):
    return self.mapping

