# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

import hildon
import gtk
import os
import sys

from KeyMappings import *
from ZeeButton import ZeeButton
from Zeemote import ZeeDiscover

# If a user config directoryis present try to load mappings
# from there.
userConfigPath = os.getenv("HOME") + "/.zeecontrol"
if os.path.isdir(userConfigPath):
  sys.path.append(userConfigPath)
  from UserMappings import *

class ZeecontrolGUI(hildon.Program):
  def __init__(self):
    hildon.Program.__init__(self)
    self.window = hildon.Window()
    self.window.connect("destroy", gtk.main_quit)  
    self.add_window(self.window)

    vbox = gtk.VBox(False, 0)
    self.window.add(vbox)
    vbox.show()
        
    self.image = gtk.Image()
    self.image.show()
        
    self.label = gtk.Label("")
    vbox.pack_start(self.label, True, True, 0)        
    self.label.show()   

    zeeButtonBox = gtk.HBox(False, 0)
    vbox.pack_start(zeeButtonBox)
    zeeButtonBox.show()

    zeeDiscover = ZeeDiscover()
    deviceCount = zeeDiscover.getZeemoteCount()
    print "Found %d Zeemote(s)." % deviceCount
    for i in range (1, deviceCount+1):
      zeeButton = ZeeButton(self, zeeButtonBox, i)
      if i == 1:
        self.selectedZeeButton = zeeButton

    buttonBox1 = gtk.HBox(False, 0)        
    vbox.pack_start(buttonBox1)
    buttonBox1.show()

    buttonBox2 = gtk.HBox(False, 0)        
    vbox.pack_start(buttonBox2)
    buttonBox2.show()

    self.buttonA = gtk.Button("A")
    self.buttonA.connect("clicked", self.setMapping, mappingA, altMappingA)
    buttonBox1.pack_start(self.buttonA, True, True, 0)
    self.buttonA.show()

    self.buttonB = gtk.Button("B")
    self.buttonB.connect("clicked", self.setMapping, mappingB, altMappingB)
    buttonBox1.pack_start(self.buttonB, True, True, 0)
    self.buttonB.show()

    self.buttonC = gtk.Button("C")
    self.buttonC.connect("clicked", self.setMapping, mappingC, altMappingC)
    buttonBox1.pack_start(self.buttonC, True, True, 0)
    self.buttonC.show()

    self.buttonD = gtk.Button("D")
    self.buttonD.connect("clicked", self.setMapping, mappingD, altMappingD)
    buttonBox1.pack_start(self.buttonD, True, True, 0)
    self.buttonD.show()

    self.buttonE = gtk.Button("E")
    self.buttonE.connect("clicked", self.setMapping, mappingE, altMappingE)
    buttonBox2.pack_start(self.buttonE, True, True, 0)
    self.buttonE.show()

    self.buttonF = gtk.Button("F")
    self.buttonF.connect("clicked", self.setMapping, mappingF, altMappingF)
    buttonBox2.pack_start(self.buttonF, True, True, 0)
    self.buttonF.show()

    self.buttonG = gtk.Button("G")
    self.buttonG.connect("clicked", self.setMapping, mappingG, altMappingG)
    buttonBox2.pack_start(self.buttonG, True, True, 0)
    self.buttonG.show()

    self.buttonH = gtk.Button("H")
    self.buttonH.connect("clicked", self.setMapping, mappingH, altMappingH)
    buttonBox2.pack_start(self.buttonH, True, True, 0)
    self.buttonH.show()
        
    self.window.show_all()

    while gtk.events_pending():
      gtk.main_iteration()                
   
  def setMapping(self, widget, newMapping=None, newAltMapping=None):
    self.selectedZeeButton.setMapping(newMapping, newAltMapping)

  def setSelectedZeeButton(self, zeeButton):
    self.selectedZeeButton = zeeButton

  def signalUser(self, usertext):
    self.label.set_text(usertext)
    while gtk.events_pending():
      gtk.main_iteration()     
    print usertext  
        
