# 
# Copyright 2010 Ruediger Gad
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
from ctypes import *
import time

CDLL("libglib-2.0.so.0", RTLD_GLOBAL)
CDLL("libbluetooth.so.3", RTLD_GLOBAL)
gconf = CDLL("libgconf-2.so.4", RTLD_GLOBAL)
gobj = CDLL("libgobject-2.0.so.0", RTLD_GLOBAL)
zeemote = CDLL("libzeemote.so.1")
zeemoteConf = CDLL("libzeemote-conf.so.1")

buttonmap = {
    'A': 0x0001,
    'B': 0x0002,
    'C': 0x0004,
    'D': 0x0008
} 
 
class BdAddr(Structure):
  _fields_ = [("b", c_char * 6)]

class ZeemoteState(Structure):
  _fields_ = [("state", c_int),
              ("axis", c_int * 4),
              ("buttons", c_ulong),
              ("battery", c_int)]

getState = zeemote.zeemote_get_state
getState.restype = POINTER(ZeemoteState)

class Zeemote():
  def __init__(self, pointer):
    self.p = pointer
  def getX(self):
    state = getState(self.p)
    return state[0].axis[0]
  def getY(self):
    state = getState(self.p)
    return state[0].axis[1]
  def isConnected(self):
    state = getState(self.p)
    return (state[0].state == 3)
  def getButtonMask(self):
    state = getState(self.p)
    return state[0].buttons
  def disconnect(self):
    zeemote.zeemote_disconnect(self.p)    

class ZeemoteDevice(Structure):
  _fields_ = [("type", c_int),
              ("bdaddr", BdAddr)]

class ZeemoteScanResult(Structure):
  _fields_ = [("number_of_devices", c_int),
              ("device", ZeemoteDevice)]

class ZeeDiscover():
  def __init__(self):
    gobj.g_type_init()

  def getZeemote(self):
    getScanResults = zeemoteConf.zeemote_get_scan_results_from_gconf
    getScanResults.restype = POINTER(ZeemoteScanResult)
    result = getScanResults()

    connect = zeemote.zeemote_connect
    connect.restype = c_int
    dev = connect(byref(result[0].device.bdaddr))
 
    state = getState(dev)
    while state[0].state != 3:
      time.sleep(0.2)
      state = getState(dev)
      if state[0].state == 2:
        zeemote.zeemote_disconnect(dev)
        dev = connect(byref(result[0].device.bdaddr))

    return Zeemote(dev)

