import sys
import time
import pickle
import zbrowse as webbrowser
import pygame
import zconfig

import zfoursquare
import zfacebook
# import zgowalla

database = None

def get():
    global database
    try:
        f = open("/home/user/.zaploc/consolidated.db")
        database = pickle.load(f)
        f.close()        
        
        #for x in database:
        #    print x
    except:
        database = []
        
def put():
    global database

    if database == None:
        return
    
    try:
        f = open("/home/user/.zaploc/consolidated.db", "w")
        pickle.dump(database, f)
        f.close()        
    except:        
        webbrowser.dialog("Error saving ZapLoc database")    

def release():
    global database
    database = None

def add(item):
    global database

    svcs = ( "foursquare", "gowalla", "facebook" )

    for s in svcs:
        if s in item:    
            for x in database:
                if s in x and x[s] == item[s]:
                    database.remove(x)

    idnumber = 0
    
    for x in database:
        q = int(x["id"])
        if q > idnumber:
            idnumber = q
                    
    idnumber += 1
    item["id"] = "%d" % idnumber    

    # print item
    
    database.append(item)
    put()
    
    return item["id"]

def remove(item):
    global database
    
    for x in database:
        if item == x["id"]:
            database.remove(x)
    
    put()

#
#  Cleans out any specific settings of twitter or facebook 
#  in the database
#
def desalinate():
    global database

    print "Cleaning explicit twitter/facebook settings from database..."
    
    for item in database:
        try:
            if item["fb_poster"] != "" or item["tw_poster"] != "":
                print "Location %s cleaned from explicit twitter/facebook settings" % item["name"]
                item["fb_poster"] = ""
                item["tw_poster"] = ""
                item["description"] += "\nCHANGED: (Using DEFAULT fb/tw WHATEVER above says!)"
        except:
            pass
    put()
    
    print "Done!"
    

def getlastcheckin():
    try:
        f = open("/home/user/.zaploc/lastcheckin.db")
        checkins = pickle.load(f)
        f.close()

        return checkins[-1]["id"]
    except:
        return None
    
def addcheckin(checkin):
    checkins = None

    checkin["checkintime"] = time.time()
    
    try:
        f = open("/home/user/.zaploc/lastcheckin.db")
        checkins = pickle.load(f)
        f.close()
    except:
        pass

    if checkins == None: 
        checkins = []
    
    # Add the checkin
    checkins.append(checkin)
    
    # More than 20 - kill the first (oldest) checkin
    if len(checkins) > 20:
        checkins.remove(checkins[0])
        
    try:
        f = open("/home/user/.zaploc/lastcheckin.db", "w")
        pickle.dump(checkins, f)
        f.close()        
    except:        
        webbrowser.dialog("Error saving ZapLoc checkin log")    

    
class Service():
        
    def is_authorized(self):            
        return True
        
    def authorize(self):                        
        pass

    def list_spots(self, my_pos, radius):
        global database

        output = []
        
        for spot in database:            
            checkinradius = 0.0
            if spot["auto-check"]:
                checkinradius = spot["auto-distance"]
            # print spot
            output.append((
                spot["id"], 
                float(spot["lat"]), float(spot["lng"]), 
                spot["name"],                                    
                spot["image"],
                spot["scale"],
                checkinradius
            ))
        
        return output
            
            

    def list_friends(self, my_pos):
        return []

    def get_description(self, spot):
        global database

        for o in database:
            if o["id"] == spot[0]:
                return ( o["description"], o["link"] )
            
        return ( "No Description", None )
    
    def check_in(self, spot, my_pos, text, twitter, facebook, photo = None):
        global database        
        
        result = [ " Check in Failed for Some Reason(tm) " ]

        for item in database:
            if item["id"] == spot[0]:                
                result = [ "Doing Consolidated Check-in at " + spot[3] ]
                svcs = ( zfoursquare.Service(), zfacebook.Service() )

                config = zconfig.get()
                
                no_facebook_photo = False
                
                fs_on = "foursquare" in item
                gw_on = "gowalla"    in item

                tw_ap = ""
                fb_ap = ""

                for svc in svcs:
                    cfgname = svc.cfgname()
                                        
                    if config[cfgname] and svc.is_authorized():
                        if cfgname in item:
                            tw = 0
                            fb = 0                            

                            # If one in the spot is defined...
                            if   item["tw_poster"] == cfgname:  # ...use that
                                tw = twitter
                            elif item["tw_poster"] == "" and (tw_ap == cfgname or tw_ap == ""):
                                tw = twitter
                                tw_ap = "-" # ..which if it was empty... isn't anny more.
                            
                            if   item["fb_poster"] == cfgname:
                                fb = twitter
                            elif item["fb_poster"] == "" and (fb_ap == cfgname or fb_ap == ""):
                                fb = twitter
                                fb_ap = "-"

                            # Avoid the facebook double posting thing
                            if cfgname == "facebook" and no_facebook_photo:
                                res = svc.check_in((item[cfgname],item["lat"],item["lng"],item["name"]), my_pos, text, tw, fb, None)
                            else:
                                res = svc.check_in((item[cfgname],item["lat"],item["lng"],item["name"]), my_pos, text, tw, fb, photo)
                            
                            if res != None:
                                for a in res:
                                    result.append(a)                                    
                                
                                # IF:
                                # - we have a photo
                                # - ...we are foursquare
                                # - ...we are set to post to FACEBOOK
                                # - ...and to post to the checkin (not venue)
                                # - ...and we have the "don't double post to facebook" flag on
                                # - ...then we assume the photo was already posted that way                                
                                # - ...so we set the flag not to post the photo to facebook
                                if photo and svc.cfgname() == "foursquare" and fb and zfoursquare.post_photos_to_venue != 1 and config["avoid-double-photo"]:
                                    no_facebook_photo = True
                                
                # Save it as "last checkin"
                addcheckin(item)
        
        return result

    def can_post_photo(self):
        return True
    
    def name(self):
        return "ZapLoc"
    
    def cfgname(self):
        return "zaploc"
    
    def onimg(self):
        return "gfx/zlon.png"
    
    def offimg(self):
        return "gfx/zloff.png"    
    
    def tweetable(self):
        return False
        
    def facebookable(self):
        return False
    
    def poscheckin(self):
        return False
    
    
