import os
import pygame
import urllib, urllib2
import BaseHTTPServer

try:
    from urlparse import parse_qsl
except ImportError:
    from cgi import parse_qsl

class RedirectHandler(BaseHTTPServer.BaseHTTPRequestHandler):
  """A handler for OAuth 2.0 redirects back to localhost.

  Waits for a single request and parses the query parameters
  into the servers query_params and then stops serving.
  """
  
  def do_GET(s):
    """Handle a GET request

    Parses the query parameters and prints a message
    if the flow has completed. Note that we can't detect
    if an error occurred.
    """
    s.send_response(200)
    s.send_header("Content-type", "text/html")
    s.end_headers()
    query = s.path.split('?', 1)[-1]
    query = dict(parse_qsl(query))

    # print query
    
    s.server.query_params = query
    s.wfile.write("<html><head><font face=\"Arial,Helvetica\"><title>Authentication Status</title></head>")
    if s.token and s.token in query:
        s.wfile.write("<body>Authorization complete, redirecting....")
        s.wfile.write("<script>window.location = 'http://zaptronic.com/zaploc/success.html?svc=" + s.service + "';</script>")
    else:
        s.wfile.write("<body>Authorization problem, redirecting....")
        s.wfile.write("<script>window.location = 'http://zaptronic.com/zaploc/fail.html?svc=" + s.service + "';</script>")        
    s.wfile.write("</body></html>")

  def log_message(self, format, *args):
    """Do not log messages to stdout while running as command line program."""
    pass


def load_url_image(url, scale, tempfile = None):    
    # print "load_url_image = " + url

    # Parse the URL
    split = urllib2.urlparse.urlsplit(url)    

    if tempfile == None:
        cachefile = "/home/user/MyDocs/.maps/cache" + split[2]
    else:
        cachefile = "/home/user/MyDocs/.maps/cache/%s.jpg" % tempfile
    
    if not os.path.isfile(cachefile) or tempfile != None:    
        path = os.path.dirname(cachefile)
        if not os.path.exists(path):
            try:
                os.makedirs(path)
            except:
                pass
            
        result   = urllib.urlopen(url) 
        content  = result.read()    
        fout     = open(cachefile, "wb")
        fout.write(content)
        fout.close()    
    
    try:        
        return ( cachefile, scale )

    except:
        print "Failed to load " + cachefile
        os.remove(cachefile)            
        return ( "gfx/unknown.png", 1.0 )
