import os
import math
import pygame
import zspin
import zgui
from pygame.locals import *
import threading

try:
    import osso
    photodirs = ( "/home/user/MyDocs/DCIM", "/media/mmc1/DCIM" )
except:
    photodirs = ( "i:\\downloads", )

SHOFF  = 16
shadow = None

def center_blit(screen, image, pos):
    r = image.get_rect()
    screen.blit(image, (pos[0] - r.width / 2, pos[1] - r.height / 2))        


def add_shadow(image):
    return image
"""
    siz         = image.get_size()
    target      = pygame.Surface((siz[0]+SHOFF, siz[1]+SHOFF), SRCALPHA, shadow)
    scaleshadow = pygame.transform.scale(shadow, siz)
    target.blit(scaleshadow, (SHOFF,SHOFF))
    target.blit(image, (0,0))
    return target
"""

def compute_scale(image, maxwidth, maxheight):
    
    scalea = 1.0 * maxheight / image.get_height()
    scaleb = 1.0 * maxwidth  / image.get_width()
    
    if scalea > scaleb:
        return scaleb
    else:
        return scalea

def mk_scaled_photo(item, wdt, hgt):
    img = pygame.image.load(item["file"]).convert()
    scale = compute_scale(img, wdt, hgt)
    scaleimage = pygame.transform.rotozoom(img, 0.0, scale)
    img = None # Ditch this
    item["scaleimage"] = add_shadow(scaleimage)

class photomaker(threading.Thread):
    def __init__(self, item, wdt, hgt):
        self.item   = item
        self.wdt    = wdt
        self.hgt    = hgt
        threading.Thread.__init__(self)
        
    def run(self):
        mk_scaled_photo(self.item, self.wdt, self.hgt)
    
def get_photo_list():
    result = []
    
    for dir_name in photodirs:
        #for root, dirs, files in os.walk(dir_name):
	if os.access(dir_name, 0):
            for filename in os.listdir(dir_name):
                fname = os.path.join(dir_name, filename)
                if fname[-4:] == ".jpg" or fname[-4:] == ".JPG":
                    result.append((os.path.getmtime(fname), fname))
                    print filename

    result.sort(reverse=True)
    
    return result

def photo_dialog(screen):
    global shadow
    result = None
    
    background = screen.copy()    
    window = pygame.image.load("gfx/consolidate.png").convert_alpha()
    scl    = pygame.transform.scale(window, (850,550))
    window.blit(scl, (-25, -25))
    
    working = True    

    clock = pygame.time.Clock()

    my_font = pygame.font.Font(None, 32)

    my_string = "Set up Services"
    my_rect = pygame.Rect((200, 50, 400, 100))       

    """
    try:
        rendered_text = ztext.render_textrect(my_string, my_font, my_rect, (255,255,255), 1, -1, (120,120,120))    
        if rendered_text:
            window.blit(rendered_text, my_rect.topleft)    
    except:
        pass
            
    my_font = pygame.font.Font(None, 30)    
    """
    
    screen.set_clip(None)

    pos = - 800

    ui = []

    BOTY = 400
    
    #ui.append(zgui.Button    (650-75, BOTY, "Older > ",     True,  -1))
    #ui.append(zgui.Button    (150-75, BOTY, "< Newer",     True,   1))
    ui.append(zgui.Button    (300-75, BOTY, "OK",          True,   39))
    ui.append(zgui.Button    (500-75, BOTY, "Cancel",      True,   38))
    
    SX = 180
    DX = 250
    
    SY = 100
    DY = 65

    zspin.start(screen)

    photos = get_photo_list()

    plist = []

    shadow = pygame.image.load("gfx/shadow.png").convert_alpha()
    
    loading = pygame.image.load("gfx/loading.png").convert()
    # loading = add_shadow(loading)
    
    for p in photos:
        x = dict()
        x["file"] = p[1]
        plist.append(x)

    start_x = 0
    move_speed = 0

    zspin.stop()

    slide_dir = 0
    down_x = 0
    down_pos = None
    
    while working:
        start_x += slide_dir * 40
        
        if start_x / 60 % 10 == 0:
            slide_dir = 0
            start_x /= 60
            start_x *= 60
        
        for event in pygame.event.get():
            if event.type == QUIT:
                working = False
            if event.type == MOUSEBUTTONDOWN and event.button == 1:
                if event.pos[1] < BOTY:
                    down_pos = event.pos
                    down_x   = start_x
            if event.type == MOUSEMOTION:
                if event.pos[1] < BOTY:
                    if down_pos:
                        start_x = down_x + event.pos[0] - down_pos[0]
            if event.type == MOUSEBUTTONUP and event.button == 1:                
                event_res = None
                if event.pos[1] < BOTY:

                    if down_pos and abs(event.pos[0] - down_pos[0]) < 15 and abs(event.pos[1] - down_pos[1]) < 15:
                        event_res = 39
                    
                    if down_x < start_x - 50:
                        slide_dir =  1
                    elif down_x < start_x:
                        slide_dir = -1
                    if down_x > start_x + 50:
                        slide_dir = -1
                    elif down_x > start_x:
                        slide_dir = 1
                    if start_x > 0:
                        slide_dir = -1
                    
                    down_pos = None                        
                else:
                    for u in ui:
                        x = u.doevent(event)
                        if x:
                            event_res = x
    
                if event_res == 1 or event_res == -1:
                    slide_dir = event_res

                if event_res == 39:
                    result = plist[abs(start_x) / 600]["file"]
                    working = False
                if event_res == 38:
                    result = None
                    working = False

        screen.set_clip(None)
        screen.blit(background, (0,0))
        screen.blit(window, (0, pos))
        # screen.set_clip(pygame.Rect(50,0,600,400))

         
        x = 400 + start_x - abs(math.sin(math.radians(start_x / 600.0 * 180.0))) * 150
        for img in plist:
            if slide_dir != 0:
                more = 0
            else:
                more = 600
            if x < 800+400+more and x > -400:
                if not "scaleimage" in img:
                    #mk_scaled_photo(img, 550, 350)                    
                    img["scaleimage"] = loading
                    photomaker(img, 550, 350).run()                    
                center_blit(screen, img["scaleimage"], (x, pos+210))
            x += 600
        
        for u in ui:
            u.draw(screen, pos)
            
        pos *= 0.6
        if pos > -1:
            pos = 0
                
        clock.tick(30)
        pygame.display.flip()                                   
        
    pos = -5
    while pos > -800:
        for event in pygame.event.get():
            pass

        screen.blit(background, (0,0))
        screen.blit(window, (0,pos))                

        x = 400 + start_x - abs(math.sin(math.radians(start_x / 600.0 * 180.0))) * 150
        for img in plist:
            if slide_dir != 0:
                more = 0
            else:
                more = 600
            if x < 800+400+more and x > -400:
                if not "scaleimage" in img:
                    img["scaleimage"] = loading
                center_blit(screen, img["scaleimage"], (x, pos+210))
            x += 600
        
        for u in ui:
            u.draw(screen, pos)        
            
        pos *= 1.5            
            
        clock.tick(30)
        pygame.display.flip()                                   
        
    return result
    
try:
    import gobject
    import hildon
    import gtk
    
    def file_dialog(screen):
        fcd = gobject.new(hildon.FileChooserDialog, action=gtk.FILE_CHOOSER_ACTION_OPEN)
        fcd.set_default_response(gtk.RESPONSE_OK)
        ret = fcd.run()
        if ret == gtk.RESPONSE_OK:
            return fcd.get_filename()
        else:
            return None
            
except:
    def file_dialog(screen):
        photo_dialog(screen)


if __name__ == '__main__': 
    
    # file_dialog(None)
    
    os.chdir("/opt/zaploc")
    
    pygame.init()
    pygame.font.init()
    
    info  = pygame.display.Info()
    flags = NOFRAME | HWSURFACE | DOUBLEBUF
    
    screen_x = info.current_w
    screen_y = info.current_h

    if screen_x <= 800 or screen_y <= 480:
        pygame.mouse.set_visible(False)    
        flags |= FULLSCREEN
    
    screen = pygame.display.set_mode((800,480), flags)

    # We need key repeat for typin'
    pygame.key.set_repeat(150, 40)    
    
    logo   = pygame.image.load("gfx/titlecard.png")    
    screen.blit(logo, (0,0))
    pygame.display.flip()    
    
    result = photo_dialog(screen)

    print result

