pos = (59.37096, 16.51406, 35, 50)

control = None
device  = None


try:
    import gtk
    import location
    import gobject
    import threading
    import conic
    from dbus.mainloop.glib import DBusGMainLoop

    wlan_id   = None
    wlan_name = ""

    loop = None
    
    def connection_cb(connection, event):
        global wlan_id, wlan_name
        # print "connection_cb(%s, %s)" % (connection, event)
    
        status = event.get_status()
        error  = event.get_error()
        iap_id = event.get_iap_id()               
        bearer = event.get_bearer_type()               
    
        name = ""
        try:
            iaps = connection.get_all_iaps()
            for iap in iaps:
                if iap.get_id() == iap_id:
                    name = iap.get_name()
        except:
            pass
    
        if status == conic.STATUS_CONNECTED:
            # if verbose: print time.strftime('%H:%M:%S') + ": CONNECTED (%s, %s, %s, %i, %i)"     % (name, iap_id, bearer, status, error)
	    if bearer[0] == "W": # WLAN
		wlan_id   = iap_id        
		wlan_name = name
	    else:
		wlan_id   = None
		wlan_name = ""
            #elif status == conic.STATUS_DISCONNECTED:
            # if verbose: print time.strftime('%H:%M:%S') + ": DISCONNECTED (%s, %s, %s, %i, %i)"  % (name, iap_id, bearer, status, error)
            #wlan_id   = None
            #wlan_name = ""
        elif status == conic.STATUS_DISCONNECTING:
            # if verbose: print time.strftime('%H:%M:%S') + ": DISCONNECTING (%s, %s, %s, %i, %i)" % (name, iap_id, bearer, status, error)
            wlan_id   = None
            wlan_name = ""
            
    def get_wifi():
        if wlan_id:
            return ( wlan_name, wlan_id )
        else:
            return None
    
    def on_error(control, error, data):
        print "location error: %d... quitting" % error
     
    def on_changed(device, data):
        global pos
        if not device:
            return
        if device.fix:
            if device.fix[1] & location.GPS_DEVICE_LATLONG_SET:
                try:
                    acc = device.fix[6]/100
                except:
                    acc = 0
                    
                pos = ( device.fix[4], device.fix[5], acc, device.fix[7] )
                # print pos
               
    def get_location():
        # Pump GTK events
        #while gtk.events_pending(): 
        #    gtk.main_iteration()
        return pos
    
    def enable(state):
        global control
        if state:
            control.start()
        else:
            control.stop()    

    class runner(threading.Thread):
	def __init__(self):
	    global control, device, loop

	    control = location.GPSDControl.get_default()
	    device  = location.GPSDevice()
	    control.set_properties(preferred_method  =location.METHOD_AGNSS,
		                   preferred_interval=location.INTERVAL_10S)
	    threading.Thread.__init__(self)
	    
	def run(self):
	    global control, device, loop

	    DBusGMainLoop(set_as_default=True)
    
	     
	    control.connect("error-verbose", on_error)
	    device.connect ("changed",       on_changed, control)      
	    
	    connection = conic.Connection()
	    connection.set_property("automatic-connection-events", True)
	    connection.connect("connection-event", connection_cb)
	    
	    loop = gobject.MainLoop()
	    context = loop.get_context()
	    loop.run()
	    
    def open():
	gobject.threads_init()
        runner().start()
        
    def close():
        global control, device, loop
	loop.quit()
        control.stop()
        control = None
        device  = None
	loop    = None
            
except:    
    def get_location():
        return pos
    
    def enable(state):
        pass
    
    def open():
        pass
    
    def close():
        pass

    def get_wifi():
        return ( "My Netwoik", "12-22-33-44-55-66-1024" )
    