import os
import cgi
import urllib
import urllib2
import simplejson as json
import zbrowse as webbrowser
import BaseHTTPServer
import logging
import socket
import pickle
import sys
import time

import zurl

class Service:
    code = None

    #client OAuth keys
    key    = '9791be3718fe4464a7f337847d8c36af'
    secret = 'bcfe7a4128b74bd99febd572b0e805fb'
    
    #gowalla URIs and callbacks
    callback_url           = "http://localhost:8080"
    authorization_endpoint = "https://gowalla.com/api/oauth/new"
    access_token_endpoint  = "https://api.gowalla.com/api/oauth/token"

    def refresh_auth(self):
        #construct POST object for access token fetch request
        print "Refreshing Gowalla auth token...."
        postvals = {'grant_type': 'refresh_token', 'client_id': self.key, 'client_secret': self.secret, 'refresh_token': self.token["refresh_token"], 'redirect_uri': self.callback_url}
        
        #make request to capture access token
        params = urllib.urlencode(postvals)
        f = urllib.urlopen(self.access_token_endpoint, params)
        self.token = json.load(f)

        # Compute actual expiration time
        self.token["expiration_time"] = self.token["expires_in"] + time.time() - (24*60*60)
        
        # print self.token
        
        f = open("/home/user/.zaploc/gowalla.dat", "w")
        pickle.dump(self.token, f)
        f.close()
        
        print "Completed token refresh!"
    
    def is_authorized(self):    
        #get query string parameters
        # params = cgi.FieldStorage()
           
        try:
            f = open("/home/user/.zaploc/gowalla.dat")
            if f:
                self.token = pickle.load(f)
            f.close();

            # print self.token

            expired = False
            
            try:
                expiry_time = self.token["expiration_time"]
                if time.time() > expiry_time:
                    expired = True
            except:
                expired = True
            
            if expired:
                self.refresh_auth()
            
            return True
        except:            
            return False
    
    def authorize(self):                        
        host_name = 'localhost'
        port_numbers = [8080, 8090]
        if True:
          server_class = BaseHTTPServer.HTTPServer
          zurl.RedirectHandler.service = "Gowalla"
          zurl.RedirectHandler.token   = "code"
          try:
            port_number = port_numbers[0]
            httpd = server_class((host_name, port_number), zurl.RedirectHandler)
          except socket.error:
            port_number = port_numbers[1]
            try:
              httpd = server_class((host_name, port_number), zurl.RedirectHandler)
            except socket.error:
              options.localhost = False
    
        #construct Gowalla authorization URI
        auth_url = self.authorization_endpoint + "?redirect_uri=" + self.callback_url + "&client_id=" + self.key + "&scope=read-write"
        
        #redirect the user to the Gowalla authorization URI
        webbrowser.open(auth_url)
              
        if True:
          httpd.handle_request()
          if 'error' in httpd.query_params:
            sys.exit('Authentication request was rejected.')
          if 'code' in httpd.query_params:
            code = httpd.query_params['code']
            if code != None:
                #construct POST object for access token fetch request
                postvals = {'grant_type': 'authorization_code', 'client_id': self.key, 'client_secret': self.secret, 'code': code, 'redirect_uri': self.callback_url}
                
                #make request to capture access token
                params = urllib.urlencode(postvals)
                f = urllib.urlopen(self.access_token_endpoint, params)
                self.token = json.load(f)
                
                # Compute actual expiration time
                self.token["expiration_time"] = self.token["expires_in"] + time.time() - (24*60*60)
            
                f = open("/home/user/.zaploc/gowalla.dat", "w")
                pickle.dump(self.token, f)
                f.close()

    def get_icon(self):
        """ Get your own user Icon on the service """
        #build headers for protected data request
        headers = { 'Accept': 'application/json',
                    'X-Gowalla-API-Key' : self.key }
        try:
            list_url = "https://api.gowalla.com/users/me?oauth_token="
            list_url += self.token['access_token']
        
            request  = urllib2.Request(list_url, None, headers)
            response = urllib2.urlopen(request)
            
            data = json.load(response)       
    
            result = ""
            link   = ""
    
            pic = zurl.load_url_image(data["image_url"], 1.0, "gwicon")[0]
            
            return pic
        except:
            return None

    def list_spots(self, my_pos, radius):
        """ Get a list of 'spots' near the geo-center"""
        #build headers for protected data request
        headers = { 'Accept': 'application/json',
                    'X-Gowalla-API-Key' : self.key }
        
        #make OAuth signed request for protected user profile
        # profile_url = "https://api.gowalla.com/users/me?oauth_token=" + token['access_token']
        list_url = "https://api.gowalla.com/spots?lat=%g&lng=%g&radius=%g&page=1&per_page=30&oauth_token=" % ( my_pos[0], my_pos[1], radius )
        list_url += self.token['access_token']
        request  = urllib2.Request(list_url, None, headers)
        response = urllib2.urlopen(request)
        result  = json.load(response)

        # print result["spots"][0]
        
        if "spots" in result:
            spots  = result["spots"]
            output = []
            
            for spot in spots:
                img = zurl.load_url_image(spot["image_url"], 0.75)

                id = spot["url"].split('/')[2]
                
                # print spot
                output.append((
                    id, 
                    float(spot["lat"]), float(spot["lng"]), 
                    spot["name"],                                    
                    img[0],
                    img[1],
                    0.0
                ))
            
            return output
        else:
            return None

    def list_friends(self, my_pos):
        return None

    def get_description(self, spot):
        """ Get the spot description """
        #build headers for protected data request
        headers = { 'Accept': 'application/json',
                    'X-Gowalla-API-Key' : self.key }
        
        list_url = "https://api.gowalla.com/spots/%s&oauth_token=%s" % ( spot[0], self.token['access_token'] )
        request  = urllib2.Request(list_url, None, headers)
        response = urllib2.urlopen(request)
        
        result  = json.load(response)

        # print result       
        
        link = ""
        str  = "No description"

        try:
            link = "http://www.gowalla.com" + result["url"]
        except:
            pass
        
        try:
            str = result["description"]
            str += "\n\nCreator: %s %s" % ( result["creator"]["first_name"], result["creator"]["last_name"])

            if result["twitter_username"] != None: 
                str += "\nTwitter: %s" % result["twitter_username"]
                
        except:
            pass
        
        return (str, link)
                
    
    def check_in(self, spot, my_pos, text, twitter, facebook, photo = None):
        # print spot

        twitter  = int(twitter)
        facebook = int(facebook)
        
        """ Check in to a spot """
        #build headers for protected data request
        headers = { 'Accept': 'application/json',
                    'X-Gowalla-API-Key' : self.key }

        checkin_url = 'https://api.gowalla.com/checkins' # + '/test'
        
        postvals = { 
            'spot_id': spot[0], 
            'lat': my_pos[0], 
            'lng': my_pos[1], 
            'comment': text, 
            'post_to_twitter': twitter, 
            'post_to_facebook' : facebook, 
            'oauth_token' : self.token['access_token']}

        try:
            params = urllib.urlencode(postvals)
            request  = urllib2.Request(checkin_url, params, headers)
            f = urllib2.urlopen(request)
                            
            result = json.load(f)

            result = result["detail_text"]
            
            # Short messages - show as-is.
            if result and len(result) < 100:
                return ["Checked in on Gowalla!", result]
            else: # Long return messages - make prettier!
                # Clean off whitespace 
                result.strip()
                foo = result.split(".")
                bar = [ "Checked in on Gowalla" ]
                # Clean out whitespace on individual lines
                # and prepend "GW:" to it
                for a in foo:
                    stripped = a.strip()
                    if len(stripped) > 0:
                        bar.append(stripped)

                # Return the beautified string
                return bar                
        except:
            print "Unexpected error: ", sys.exc_info()[0]
            return None

    def can_post_photo(self):
        return False
        
    def name(self):
        return "Gowalla"
    
    def cfgname(self):
        return "gowalla"
    
    def onimg(self):
        return "gfx/gwon.png"
    
    def offimg(self):
        return "gfx/gwoff.png"    

    def tweetable(self):
        return True
        
    def facebookable(self):
        return True
    
    def poscheckin(self):
        return False
    