# Load the configuration

import pickle
import os

def get():
    try:
        f = open("/home/user/.zaploc/config.dat")
        conf = pickle.load(f)
        f.close()        
    except:                
        conf = dict()
        
    default = dict()

    default["fullscreen"]             = True
    
    default["gowalla"]                = False
    default["foursquare"]             = False
    default["facebook"]               = False
    default["latitude"]               = False
    default["gpsstate"]               = 2    
    default["mapmode"]                = 0
    
    default["tw_poster"]              = "foursquare"
    default["fb_poster"]              = "foursquare"
    default["avoid-double-photo"]     = False
    
    default["daemon-enable"]          = False
    default["daemon-start-on-boot"]   = True
    default["daemon-never-stop"]      = True

    default["daemon-gps-timeout"]     = 30
    default["daemon-method"]          = 1  #  1 = GPS, 0 = Cell towers
    default["daemon-interval"]        = 1  #  5, 10, 15, 30, 60, CELLTOWER
    default["daemon-autocheck"]       = False
    default["daemon-autocheck-delay"] = 2
    default["daemon-latitude"]        = False
    default["daemon-latitude-freq"]   = 2
    
    default["daemon-force-connection"]   = 1

    default["checkin-filedialog"]     = 0    
    default["checkin-foursquare"]     = 0    
    default["foursquare-homes"]       = False
    
    default["lat"] = 59.37096 
    default["lng"] = 16.51406

    # Set defaults for any parameter not in the config file
    # (which is all of them if this is the 1st start)
    for key in default.iterkeys():
        if not key in conf:
            conf[key] = default[key]
    
    return conf

def put(conf):
    try:
        f = open("/home/user/.zaploc/config.dat", "w")
        pickle.dump(conf, f)
        f.close()        
    except:        
        os.remove("/home/user/.zaploc/zaploc.dat")
