#!/usr/bin/python

#
#   System imports
#
from   random import randint
import threading
import string
import os, sys, pygame, math
from   pygame.locals import *
import urllib2
import BaseHTTPServer
import socket

SOCKET_TIMEOUT = 20

#
#   Zap's Helper Modules
#
import zmaps       # Map display code
import ztext       # Wrapping text + cursor display code
import zconfig     # Configuration file management
import zgps        # Abstraction of the GPS module
import zbrowse     # OS abstraction for stuff like opening webbpages and popping dialogs
import zdaemon     # The Daemon module
import zgui        # The GUI module
import zspin       # The "please wait" spinner module
import zphotoui    # Photo selection UI

#
#   The various services we support
#
import zzaloc      # The ZapLoc (meta) service
# import zgowalla    # Gowalla service
import zlatitude   # Google Latitude (and in future "places") service
import zfoursquare # FourSquare service
import zfacebook   # Facebook Places service

from   zdaemon  import  meter_distance, daemonize, test_if_running

#
#   Various messages the dialogs send
#
SHOW_ON_WEB       = 1
CONSOLIDATE       = 2
CHECK_IN          = 3
TWITTERON         = 4
FBON              = 5
CFG_SERVICES      = 6
CFG_MAPMODE       = 7
CFG_DAEMON        = 8
CFG_DAEMONON      = 9
CFG_CREATE_SPOT   = 10
CFG_DELETE_SPOT   = 11
CFG_IMAGE_CHANGED = 12
EDIT_SPOT         = 13
ADJUST_LOCATION   = 14
CFG_AUTOCHECK     = 15
CFG_RELOAD_DAEMON = 16
ADD_PHOTO         = 17
CFG_CHECKINS      = 18
CFG_CELL          = 19
CFG_GPS           = 20

thread_busy   = None
thread_result = []

image_cache = dict()

# Make a nifty image for me
def make_adjust_image(image):
    img = image.copy()
    
    y = 0
    while y < img.get_height():
        x = 0
        while x < img.get_width():
            color = img.get_at((x,y))
            
            img.set_at((x,y), ( color[0], color[1], color[2], color[3] * 0.25 ))
            
            x += 1
        y += 1                
    
    return img

def load_cached_image( path, scale ):
    global image_cache
    if path in image_cache:
        return image_cache[path]
    
    try:
        img = pygame.image.load(path).convert_alpha()
        if scale == 2.0:
            img = pygame.transform.scale2x(img)
        elif scale != 1.0:
            img = pygame.transform.rotozoom(img, 0.0, scale)                

        image_cache[path] = img
        return img
    except:
        print "Error loading image '" + path + "'!"
        try:
            return pygame.image.load("gfx/unknown.png").convert_alpha()
        except:
            return pygame.Surface((20,20))
        

def bottom_center_blit(screen, image, pos, flags=0):
    r = image.get_rect()
    screen.blit(image, (pos[0] - r.width / 2, pos[1] - r.height), None, flags)

def center_blit(screen, image, pos):
    r = image.get_rect()
    screen.blit(image, (pos[0] - r.width / 2, pos[1] - r.height / 2))        

def new_spot_effect(screen, pxl, time):
    img = pygame.image.load("gfx/glowy.png")
    img = pygame.transform.rotozoom(img, time * 2, 1.0 + time / 10.0)

    center_blit(screen, img, ( pxl[0], pxl[1]-30 ))    
    
def edit_spot(screen, clicked_object, svcs, new = False):
    result = None

    spotidx = -1
    
    if zzaloc.database != None:
        for i in range(len(zzaloc.database)):
            if zzaloc.database[i]["id"] == clicked_object[0]:
                spotidx = i
                break        
            
    if spotidx == -1:
        zbrowse.dialog("Error: Can't find spot in database!")
        return

    spot = zzaloc.database[spotidx]
    
    background = screen.copy()    
    window = pygame.image.load("gfx/consolidate.png").convert_alpha()
    
    working = True    

    clock = pygame.time.Clock()

    my_font = pygame.font.Font(None, 32)

    my_string = "ZapLoc settings for " + clicked_object[3]
    my_rect = pygame.Rect((100, 50, 600, 100))           
    
    try:
        rendered_text = ztext.render_textrect(my_string, my_font, my_rect, (255,255,255), 1, -1, (120,120,120))    
        if rendered_text:
            window.blit(rendered_text, my_rect.topleft)    
    except:
        pass
            
    my_font = pygame.font.Font(None, 30)    
    
    screen.set_clip(None)

    twitter_svcs = []
    facebook_svcs = []
    
    for svc in svcs:
        if svc[0].cfgname() in spot:
            if svc[0].tweetable():
                twitter_svcs.append( svc[0].name())
            if svc[0].facebookable():
                facebook_svcs.append( svc[0].name())
            
    
    pos = - 800

    d = spot["auto-distance"]
    
    if d <= 0:
	ditem = 1 # Default to 50 m
    elif d <= 30:
        ditem = 0
    elif d <= 75:
        ditem = 1
    elif d <= 200:
        ditem = 2
    elif d <= 300:
        ditem = 3
    else:
        ditem = 4    

    try: 
	# If we have wifi settings, and the spot is not new...
	wifi_name = spot["wifi-name"]
	wifi_id   = spot["wifi-id"]
    except:
	wifi_name = ""
	wifi_id   = None
	
    if wifi_id == None:
	wifi = zgps.get_wifi()
	if wifi:
	    wifi_name = wifi[0]
	    wifi_id   = wifi[1]
    elif not new:
	ditem = 5
	    
    itemlist = [ "25 m", "50 m", "100 m", "200 m", "500 m" ]
    
    if wifi_id:
	itemlist.append("'" + wifi_name + "' range")
	    
    ui = []        
    ui.append(zgui.Checkbox  (80,   120, "Check in Automatically when within", spot["auto-check"],  True,  CFG_AUTOCHECK))  
    ui.append(zgui.PopupList (490,  130, 185, itemlist, ditem,  True, -1))  
    ui.append(zgui.Checkbox  (150,   170, "Twitter",    spot["auto-tweet"],     True, -1))  
    ui.append(zgui.Checkbox  (300,   170, "Facebook",   spot["auto-facebook"],  True, -1))  

    if new:
        ui.append(zgui.Button    (550, 250, "Cancel",       True,  CFG_DELETE_SPOT))
        ui.append(zgui.Button    (550, 320, "OK",           True,  CFG_CREATE_SPOT))
    else:
        ui.append(zgui.Button    (550, 250, "Delete",       True,  CFG_DELETE_SPOT))
        ui.append(zgui.Button    (550, 320, "Adjust Loc.",  True,  ADJUST_LOCATION))

    def toggle_buttons():
        on = ui[0].on
        ui[1].set_enabled(on)
        ui[2].set_enabled(on)
        ui[3].set_enabled(on)

    toggle_buttons()
        
    checkin_text = spot["auto-message"] + " "        
    cursor_pos   = len(checkin_text) - 1
    
    my_rect = pygame.Rect((160, 250, 350, 100))        
    
    window.fill((255,255,255), my_rect)
    pygame.draw.rect(window, (100,80,80), my_rect, 2)
    
    my_rect.inflate_ip(-10,-10)
    
    ignorekeys = (K_F1,K_F2,K_F3,K_F4,K_F5,K_F6,K_F7,K_F8,K_F9,K_F10,K_F11,K_F12,K_F13,K_F14,K_F15,K_NUMLOCK,K_CAPSLOCK,K_SCROLLOCK,
                  K_RSHIFT,K_LSHIFT,K_RCTRL,K_LCTRL,K_RALT,K_LALT,K_RMETA,K_LMETA,K_LSUPER,K_RSUPER,K_MODE,K_HELP,K_PRINT,K_SYSREQ,K_BREAK,K_MENU,K_POWER,
                  K_TAB,K_RETURN,K_CLEAR,K_ESCAPE,K_PAUSE )
    
    while working:
	zgps.get_location()
        for event in pygame.event.get():
            if event.type == QUIT:
                working = False
            if event.type == KEYDOWN and ui[0].on:
                if event.key == K_LEFT:
                    if cursor_pos > 0:
                        cursor_pos -= 1
                elif event.key == K_RIGHT:
                    if cursor_pos < len(checkin_text):
                        cursor_pos += 1
                elif event.key == K_BACKSPACE:
                    if cursor_pos > 0:
                        checkin_text = checkin_text[:cursor_pos-1] + checkin_text[cursor_pos:]
                        cursor_pos -= 1
                elif event.key == K_DELETE:
                    if cursor_pos < len(checkin_text):
                        checkin_text = checkin_text[:cursor_pos] + checkin_text[cursor_pos+1:]                    
                elif event.key in ignorekeys:
                    pass
                else:
                    if len(checkin_text) < 101:
                        checkin_text = checkin_text[:cursor_pos] + event.unicode + checkin_text[cursor_pos:]                                            
                        cursor_pos += 1
            if event.type == MOUSEBUTTONUP and event.button == 1:                
                event_res = None
                
                for u in ui:
                    x = u.doevent(event)
                    if x:
                        event_res = x

                if event_res == CFG_AUTOCHECK:
                    toggle_buttons()

                result = event_res
                    
                if event_res == ADJUST_LOCATION or event_res == CFG_DELETE_SPOT or event_res == CFG_CREATE_SPOT:
                    working = False

                if event_res == None and not my_rect.collidepoint(event.pos) and not new:
                    working = False
		    result = EDIT_SPOT

        screen.blit(background, (0,0))
        screen.blit(window, (0, pos))

        srf = my_font.render("Chars left: %d" % ( 101 - len(checkin_text)), True, (150,120,90))
        screen.blit(srf, (160, my_rect.top + 105 + pos))

        if ui[0].on:
            textcol = (0,0,0)
        else:
            textcol = (140,140,140)
        
        rendered_text = ztext.render_textrect(checkin_text, my_font, my_rect, textcol, 0, cursor_pos)        
        if rendered_text:
            screen.blit(rendered_text, ( my_rect.left, my_rect.top + pos))                    
        
        for u in ui:
            u.draw(screen, pos)
            
        pos *= 0.6
        if pos > -1:
            pos = 0
                
        clock.tick(30)
        pygame.display.flip()                                   

    spot["auto-check"]     = ui[0].on
    spot["auto-message"]   = checkin_text.strip()
    spot["auto-distance"]  = ( 25, 50, 100, 250, 500, 10 ) [ui[1].selected]
    if ui[1].selected == 5:
	spot["wifi-name"] = wifi_name
	spot["wifi-id"]   = wifi_id
    else:
	spot["wifi-name"] = ""
	spot["wifi-id"]   = None
	
    spot["auto-tweet"]     = ui[2].on
    spot["auto-facebook"]  = ui[3].on
        
    pos = -5
    while pos > -800:
        for event in pygame.event.get():
            pass

        screen.blit(background, (0,0))
        screen.blit(window, (0,pos))                

        rendered_text = ztext.render_textrect(checkin_text, my_font, my_rect, (0,0,0), 0, cursor_pos)        
        if rendered_text:
            screen.blit(rendered_text, ( my_rect.left, my_rect.top + pos))                            
        
        for u in ui:
            u.draw(screen, pos)        
            
        pos *= 1.5            
            
        clock.tick(30)
        pygame.display.flip()                                   

    zzaloc.database[spotidx] = spot
    zzaloc.put()
        
    return result        

def consolidate(screen, clicked_object, my_pos, center_pos, svc, svcs, desc):
    result = None
    
    background = screen.copy()    
    window = pygame.image.load("gfx/consolidate.png").convert_alpha()
    
    working = True    

    clock = pygame.time.Clock()

    my_font = pygame.font.Font(None, 32)

    my_string = "Make ZapLoc from " + clicked_object[3]
    my_rect = pygame.Rect((100, 50, 600, 100))       

    try:
        rendered_text = ztext.render_textrect(my_string, my_font, my_rect, (255,255,255), 1, -1, (120,120,120))    
        if rendered_text:
            window.blit(rendered_text, my_rect.topleft)    
    except:
        pass

    screen.set_clip(None)

    pos = - 800

    ui = []

    #
    #  Slide screen in
    #
    
    while pos < -1 and working:
        for event in pygame.event.get():
            if event.type == QUIT:
                working = False
            if event.type == MOUSEBUTTONUP and event.button == 1:                
                event_res = None
                
                for u in ui:
                    x = u.doevent(event)
                    if x:
                        event_res = x
                        
                if event_res == None:
                    working = False

        screen.blit(background, (0,0))
        screen.blit(window, (0, pos))
        
        for u in ui:
            u.draw(screen, pos)
            
        pos *= 0.6

        clock.tick(30)
        pygame.display.flip()                                   

    # 
    #   Fill in the UI
    #
        
    y = 100

    svcresults = []

    i = 0        
    for service in svcs:
        if service[0].cfgname() == "zaploc":
            continue

        # For the active service, search from the objects location
        # but for other services search from screen center
        if service[0].cfgname() == svc.cfgname():
            search_lat = clicked_object[1]
            search_lng = clicked_object[2]
        else:
            search_lat = center_pos[0]
            search_lng = center_pos[1]
                    
        zspin.start(screen)                

        try:
            searchresult = service[0].list_spots((search_lat, search_lng), 2000)
        except:
            searchresult = []

        def distance(a):            
            dist = meter_distance(search_lat, search_lng, a[1], a[2])
            return dist
        
        searchresult.sort(key=distance)
                        
        zspin.stop()                                
        
        if len(searchresult) > 0:
            
            items = []
            
            for item in searchresult:
                if len(items) < 8:
                    items.append(item[3])        
                    
            chkbox = zgui.Checkbox      (100, y-10,   service[0].name(), True, True, 100 + i)
            popup  = zgui.PopupList     (350, y, 300, items, 0,                True, 200 + i)
            i += 1
                    
            ui.append(chkbox)
            ui.append(popup)

            svcresults.append( ( service[0], searchresult, chkbox, popup, y ) )
                        
            y += 50

        # pygame.time.wait(500)
        
        screen.blit(background, (0,0))
        screen.blit(window, (0, pos))
        
        for u in ui:
            u.draw(screen, pos)
        
        pygame.display.flip()

    #
    #  Fill in rest of UI
    #

    svcnames = []
    
    for service in svcresults:
        svcnames.append(service[0].name())

    y -= 10
    
    anames = svcnames[:]
    anames.append("ZapLoc")    
    image_popup = zgui.PopupList (106,   y+30, 130, anames, 0 , True, CFG_IMAGE_CHANGED)
    ui.append(zgui.StaticText(100,   y, "Icon"))
    ui.append(image_popup)    

    bnames = svcnames[:]
    bnames.append("- Auto -")
    
    twitter_popup = zgui.PopupList (350,   y+30, 130,  bnames, len(bnames) - 1 , True, 1)
    ui.append(zgui.StaticText(344,   y, "Twitter via"))
    ui.append(twitter_popup)    
    
    facebook_popup = zgui.PopupList (520,   y+30, 130, bnames, len(bnames) - 1 , True, 1)
    ui.append(zgui.StaticText(514,   y, "Facebook via"))
    ui.append(facebook_popup)        
    
    i = load_cached_image(svcresults[0][1][0][4], svcresults[0][1][0][5])
    
    image  = zgui.TwoStateButton(146, y+75, i , i, True, 1)
    ui.append(image)

    create = zgui.Button    (550, 350, "Create >>",          True,  CFG_CREATE_SPOT)
    ui.append(create)            

    avg_lat = 0
    avg_lng = 0
    
    #
    #  The main UI loop
    #
        
    while working:
	zgps.get_location()
	
        for event in pygame.event.get():
            if event.type == QUIT:
                working = False
            if event.type == MOUSEBUTTONUP and event.button == 1:                
                event_res = None
                
                for u in ui:
                    x = u.doevent(event)
                    if x:
                        event_res = x
                        
                if event_res == None:
                    working = False
                elif event_res >= 200 or event_res == CFG_IMAGE_CHANGED: # spot name changed
                    svcnr = image_popup.selected
                    if svcnr < len(svcresults):
                        resnr = svcresults[svcnr][3].selected                    
                        image.onimg = load_cached_image(svcresults[svcnr][1][resnr][4], svcresults[svcnr][1][resnr][5]) 
                    else:
                        image.onimg = pygame.image.load("gfx/zaplocspot.png")
                        
                    image.set_enabled(True)
                elif event_res >= 100: # checkbox changed
                    svcresults[event_res-100][3].set_enabled(svcresults[event_res-100][2].on)
                    # If any of the checkboxes are selected, we can push "create"
                    any = False
                    for svc in svcresults:
                        if svc[2].on:
                            any = True
                    create.set_enabled(any)                    
                elif event_res == CFG_CREATE_SPOT:
                    result = dict()

                    # svcnr = position_popup.selected                        
                    # if svcnr < len(svcresults):
                    avg_lat = 0
                    avg_lng = 0
                    divisor = 0                    
                    description = ""
                    
                    # Loop over all services, building a list
                    for svc in svcresults:
                        if svc[2].on:
                            sel_item = svc[3].selected
                            result[svc[0].cfgname()] = svc[1][sel_item][0]
                            avg_lat  += svc[1][sel_item][1]
                            avg_lng  += svc[1][sel_item][2]
                            divisor  += 1.0
                            description += svc[0].name() + ": " + svc[1][sel_item][3] + "\n"


                    def posting_truename(item):
                        if item < len(svcresults):
                            return svcresults[item][0].name()
                        else:
                            return ""
                        
                    x = posting_truename(twitter_popup.selected)
                    if x != "":
                        description += "Twitter posts by: " + x + "\n"
                    x = posting_truename(facebook_popup.selected)
                    if x != "":
                        description += "Facebook posts by: " + x + "\n"                                                        
                            
                    avg_lat /= divisor
                    avg_lng /= divisor
                        
                    result["lat"] = avg_lat
                    result["lng"] = avg_lng
                                        
                    result["name"]        = clicked_object[3]
                    result["description"] = description
                    result["link"]        = None

                    def posting_name(item):
                        if item < len(svcresults):
                            return svcresults[item][0].cfgname()
                        else:
                            return ""
                        
                    result["fb_poster"]   = posting_name(facebook_popup.selected)
                    result["tw_poster"]   = posting_name(twitter_popup.selected)
                    
                    result["auto-check"]     = False
                    result["auto-message"]   = "ZapLoc Auto-Checkin"
                    result["auto-tweet"]     = False
                    result["auto-facebook"]  = False
                    result["auto-distance"]  = 50
                    
                    svcnr = image_popup.selected
                    if svcnr < len(svcresults):
                        resnr = svcresults[svcnr][3].selected                    
                        result["image"] = svcresults[svcnr][1][resnr][4]
                        result["scale"] = svcresults[svcnr][1][resnr][5]
                    else:
                        result["image"] = "gfx/zaplocspot.png"
                        result["scale"] = 1.0
			
		    wifi = zgps.get_wifi()
		    
		    if wifi:
			result["wifi-name"] = wifi[0]
			result["wifi-id"]   = wifi[1]

                    new_spot = zzaloc.add(result)
                    
                    clicked_object = ( new_spot, clicked_object[1], clicked_object[2], clicked_object[3], clicked_object[4] )
                    
                    result = CFG_CREATE_SPOT
                    
                    working = False

        screen.blit(background, (0,0))
        screen.blit(window, (0, pos))
        
        for u in ui:
            u.draw(screen, pos)                                        
                
        clock.tick(30)
        pygame.display.flip()                                           
        
        
    pos = -5
    while pos > -800:
        for event in pygame.event.get():
            pass

        screen.blit(background, (0,0))
        screen.blit(window, (0,pos))                

        for u in ui:
            u.draw(screen, pos)        
            
        pos *= 1.5            
            
        clock.tick(30)
        pygame.display.flip()                                   
        
    if result == CFG_CREATE_SPOT:
        res = edit_spot(screen, clicked_object, svcs, True)
        if res == CFG_CREATE_SPOT:
            result = ( avg_lat, avg_lng )
            
        if res == CFG_DELETE_SPOT:
            zzaloc.remove(new_spot)

    return result


auth_busy   = None

# Run authorizations in a separate thread
class authorizer(threading.Thread):
    def __init__(self, svc):
        self.svc    = svc
        threading.Thread.__init__(self)
        
    def run(self):
        global auth_busy, auth_result
	auth_busy = self
	self.svc.authorize()
	auth_busy = False


def do_auth(screen, service):
    global auth_busy

    socket.setdefaulttimeout(None)
    
    screen.set_clip(None)
    
    background = screen.copy()
    
    window = pygame.image.load("gfx/dialog.png")
    zaploc = pygame.image.load("gfx/zaploc64x64.png")
    svci   = pygame.image.load(service.onimg())
    
    screen.blit(window, (0,0))
    screen.blit(zaploc, (250-28,205))
    screen.blit(svci,   (550-32,200))

    ui = []
    ui.append(zgui.Button    (400-75, 300, "Abort",       True,  1))    

    for u in ui:
	u.draw(screen, 0)
    
    auth_busy = True

    # Start Authorizer thread
    authorizer(service).start()

    angle = 0.0
    clock = pygame.time.Clock()

    is_spinning = False

    my_font = pygame.font.Font(None, 28)

    my_string = "Authorizing ZapLoc with " + service.name()
    my_rect = pygame.Rect((100, 150, 600, 100))           
    
    try:
        rendered_text = ztext.render_textrect(my_string, my_font, my_rect, (255,255,255), 1, -1, (120,120,120))    
        if rendered_text:
            screen.blit(rendered_text, my_rect.topleft)    
    except:
        pass

    wait = pygame.image.load("gfx/download.png").convert()
    is_spinning = True                    
    
    while auth_busy:
	# zgps.get_location()
	for event in pygame.event.get():
	    if event.type == pygame.MOUSEBUTTONDOWN: 
		for i in ui:
		    if i.doevent(event) != None:
			try:
			    headers = { 'Accept': 'application/json' }
			    request  = urllib2.Request("http://127.0.0.1:8080/?q=Fail", None, headers)
			    response = urllib2.urlopen(request)
			except:
			    print "Failed sending HTTP abort request :-("

	screen.set_clip(Rect(300,210,200,40))        
	screen.blit(wait, (300 - randint(1,100), 198))                    			
			
	pygame.display.flip()
	    
	clock.tick(6) 

    screen.set_clip(None)
	
    screen.blit(background, (0,0))
    is_spinning = False

    socket.setdefaulttimeout(SOCKET_TIMEOUT)
    
    
def config_services(screen, config):
    result = None
    
    background = screen.copy()    
    window = pygame.image.load("gfx/consolidate.png").convert_alpha()

    working = True    
    
    clock = pygame.time.Clock()

    my_font = pygame.font.Font(None, 32)

    my_string = "Set up Services"
    my_rect = pygame.Rect((200, 40, 400, 100))       

    try:
        rendered_text = ztext.render_textrect(my_string, my_font, my_rect, (255,255,255), 1, -1, (120,120,120))    
        if rendered_text:
            window.blit(rendered_text, my_rect.topleft)    
    except:
        pass
            
    my_font = pygame.font.Font(None, 30)    
    
    screen.set_clip(None)

    pos = - 800

    ui = []

    while pos < -1 and working:
        for event in pygame.event.get():
            if event.type == QUIT:
                working = False
            if event.type == MOUSEBUTTONUP and event.button == 1:                
                event_res = None
                
                for u in ui:
                    x = u.doevent(event)
                    if x:
                        event_res = x
                        
                if event_res == None:
                    working = False

        screen.blit(background, (0,0))
        screen.blit(window, (0, pos))
        
        for u in ui:
            u.draw(screen, pos)
            
        pos *= 0.6

        clock.tick(30)
        pygame.display.flip()                                   
    
    SX = 200
    DX = 250
    
    SY = 85
    DY = 60

    svcs = [
        # zgowalla.Service(),
        zfoursquare.Service(),
        zfacebook.Service(),
        zlatitude.Service()
    ]
    
    svcsi = dict()

    blank = pygame.Surface((0,0))
    
    for i in range(len(svcs)):        
	zspin.start(screen)
	
        ui.append(zgui.Checkbox(SX, SY+i*DY,    svcs[i].name(),    config[svcs[i].cfgname()],    True,  100 + i))
        ui.append(zgui.Button  (SX+DX, SY+i*DY, "Authorize...",    config[svcs[i].cfgname()],    200 + i))
    
        on  = pygame.image.load(svcs[i].onimg()). convert_alpha()
        off = pygame.image.load(svcs[i].offimg()).convert_alpha()
        ui.append(zgui.TwoStateButton(SX-70, SY+i*DY, on, off, config[svcs[i].cfgname()] and svcs[i].is_authorized(),  None))    

        on  = pygame.image.load("gfx/lighton.png"). convert_alpha()
        off = pygame.image.load("gfx/lightoff.png").convert_alpha()
	
        try:
	    if config[svcs[i].cfgname()] and svcs[i].is_authorized():
	        pic = svcs[i].get_icon()
	    else:
	        pic = None
	    
	    img = pygame.image.load(pic)
	    img = pygame.transform.scale(img, (50,50))
	except:
	    img = pygame.Surface((0,0))

	ui.append(zgui.TwoStateButton(SX+430, SY+i*DY-5, on, off, pic != None,  None))    
	ui.append(zgui.TwoStateButton(SX-120, SY+i*DY+8, img, blank, config[svcs[i].cfgname()],  None))    

        screen.blit(background, (0,0))
        screen.blit(window, (0, pos))
	
	zspin.stop()
	# pygame.time.wait(200)
	
	# Clean event queue
	for event in pygame.event.get():
	    pass
        
        for u in ui:
            u.draw(screen, pos)
            
        clock.tick(10)
        pygame.display.flip()                                   

    ui.append(zgui.Button  (400-75, 360, "Done",  True,  300))
	
    while working:
	zgps.get_location()
        for event in pygame.event.get():
            if event.type == QUIT:
                working = False
            if event.type == MOUSEBUTTONUP and event.button == 1:                
                event_res = None
                
                for u in ui:
                    x = u.doevent(event)
                    if x:
                        event_res = x

                for i in range(len(svcs)):        
                    if event_res == 100 + i:
                        r = ui[i*5].on
                        config[svcs[i].cfgname()] = r
                        ui[i*5+1].set_enabled(r)
                        zspin.start(screen)

			if svcs[i].is_authorized():
			    pic = svcs[i].get_icon()
			else:
			    pic = None

			# Default to nuttin'
			img = pygame.Surface((0,0))
			
			try:
			    if pic != None:	    
				img = pygame.image.load(pic)
				img = pygame.transform.scale(img, (50,50))
			except:
			    pass
			
			ui[i*5+4].onimg = img			
                        ui[i*5+4].set_enabled(r)
			ui[i*5+2].set_enabled(r and pic != None and svcs[i].is_authorized())
                        ui[i*5+3].set_enabled(pic != None and svcs[i].is_authorized())
                        zspin.stop()
                        # We need an update
                        result = True
                        
                    if event_res == 200 + i:
                        svcs[i].is_authorized()
			do_auth(screen, svcs[i])

			zspin.start(screen, svcs[i].name())
                        
			is_auth = svcs[i].is_authorized()
			if is_auth:
			    pic     = svcs[i].get_icon()
			else:
			    pic     = None
			
			if pic != None:	    
			    img = pygame.image.load(pic)
			    img = pygame.transform.scale(img, (50,50))
			else:
			    img = pygame.Surface((0,0))
			    is_auth = False
			    
			ui[i*5+4].onimg = img
			ui[i*5+4].set_enabled(True)
                        ui[i*5+2].set_enabled(is_auth)
                        ui[i*5+3].set_enabled(is_auth)
			
                        zspin.stop()
                        # We need an update
                        result = True
                        
                if event_res == 300:
                    working = False

        screen.blit(background, (0,0))
        screen.blit(window, (0, pos))
        
        for u in ui:
            u.draw(screen, pos)
            
        clock.tick(30)
        pygame.display.flip()                                   
    
    """
    if config["fb_poster"] == "" or config["tw_poster"] == "":
	for s in ( "foursquare", "gowalla" ):
	    if config[s]:
		config["fb_poster"] = s
		config["tw_poster"] = s
    """
	
    pos = -5
    while pos > -800:
        for event in pygame.event.get():
            pass

        screen.blit(background, (0,0))
        screen.blit(window, (0,pos))                

        for u in ui:
            u.draw(screen, pos)        
            
        pos *= 1.5            
            
        clock.tick(30)
        pygame.display.flip()                                   
        
    return result

def config_daemon(screen, config):
    result = None
    
    background = screen.copy()    
    window = pygame.image.load("gfx/consolidate.png").convert_alpha()
    
    working = True    

    clock = pygame.time.Clock()

    my_font = pygame.font.Font(None, 32)

    my_string = "Background Update Settings"
    my_rect = pygame.Rect((200, 50, 400, 100))           
    
    try:
        rendered_text = ztext.render_textrect(my_string, my_font, my_rect, (255,255,255), 1, -1, (120,120,120))    
        if rendered_text:
            window.blit(rendered_text, my_rect.topleft)    
    except:
        pass
            
    my_font = pygame.font.Font(None, 30)    
    
    screen.set_clip(None)

    pos = - 800

    ui = []

    #ui.append(zgui.StaticText(80,   90, "Start"))
    #ui.append(zgui.PopupList (145,  90, 200, ("when app starts", "on device boot"), config["daemon-start-on-boot"] , True, CFG_MAPMODE))    

    #ui.append(zgui.StaticText(400,  90, "Stop"))
    #ui.append(zgui.PopupList (460,  90, 200, ("when app closes", "never"), config["daemon-never-stop"] , True, CFG_MAPMODE))    
    
    ui.append(zgui.StaticText(80,  90,       "Check if location has changed"))
    gps_interval = zgui.PopupList (390, 90, 270, ("every 5 minutes", "every 10 minutes", "every 15 minutes", "every 30 minutes", "every hour", "every 2 hours" ), config["daemon-interval"] , True, CFG_MAPMODE)
    ui.append(gps_interval)        

    # ui.append(zgui.StaticText(80,  140,       "Background Location method"))
    # gps_method = zgui.PopupList (390, 140, 270, ("Cell Towers only", "GPS + Cell Towers", "GPS Only"), config["daemon-method"] , True, CFG_MAPMODE)
    # ui.append(gps_method) 
    
    ui.append(zgui.StaticText(80,  130,       "using"))
    goo = (config["daemon-gps-timeout"] / 10) - 1    
    use_cell    = zgui.Checkbox  (150,  120, "Cell-tower", False,  True,  CFG_CELL)
    ui.append(use_cell)
    use_gps     = zgui.Checkbox  (320,  120, "GPS with timeout", False,  True,  CFG_GPS)
    ui.append(use_gps)
    gps_timeout = zgui.PopupList (580,  130, 80, ("10 s", "20 s", "30 s", "40 s", "50 s", "60 s"), goo , True, CFG_MAPMODE)
    ui.append(gps_timeout)
    

    if config["daemon-method"] == 0:
	use_gps.on  = False
	use_cell.on = True
    elif config["daemon-method"] == 1:
	use_gps.on  = True
	use_cell.on = True
    elif config["daemon-method"] == 2:
	use_gps.on  = True
	use_cell.on = False
    else:
	use_gps.on  = False
	use_cell.on = False

    latitude = config["latitude"]
	
    if latitude:
        y = 190
    else:
        y = 210

    autocheck = zgui.Checkbox  (80,  y, "Check in Automatically to Auto-Check enabled Spots", config["daemon-autocheck"],  True,  CFG_DAEMONON)
    ui.append(autocheck)  
    ui.append(zgui.StaticText(145, y+45, "after"))   
    autocheck_delay = zgui.PopupList (220, y+45, 125, ("1 interval", "2 intervals", "3 intervals", "4 intervals", "5 intervals" ), config["daemon-autocheck-delay"] , True, CFG_MAPMODE)
    ui.append(autocheck_delay)    

    min_display = zgui.StaticText(380, y+45, "(about x minutes)")
    ui.append(min_display)

   
    if latitude:
	latitude = zgui.Checkbox  (80,  y+100, "Update Google Latitude", config["daemon-latitude"],  True,  CFG_DAEMONON)
        ui.append(latitude)  
	latitude_interval = zgui.PopupList (390, y+110, 270, ("when position changes", "at LEAST every hour", "at LEAST every 2 hours", "at LEAST every 6 hours", "at LEAST every day"), config["daemon-latitude-freq"] , True, CFG_MAPMODE)
        ui.append(latitude_interval)
	y += 50

    ui.append(zgui.StaticText(80, y+120, "If no network connection"))   
    force_connection = zgui.PopupList (390, y+120, 270, ("do not post anything", "try to connect, then post"), config["daemon-force-connection"] , True, CFG_MAPMODE)
    ui.append(force_connection)
	
    def grayout():
        autocheck_delay.set_enabled(autocheck.on)
        if latitude:
            latitude_interval.set_enabled(latitude.on)
        delay = ( 5, 10, 15, 30, 60, 120)[gps_interval.selected] * (autocheck_delay.selected + 1)
        if delay:
            min_display.text = "(about %d minutes)" % delay
        else:
            min_display.text = ""
        min_display.set_enabled(True)
	gps_timeout.set_enabled(use_cell.on or use_gps.on) 

    grayout()
    
    while working:
	zgps.get_location()
        for event in pygame.event.get():
            if event.type == QUIT:
                working = False
            if event.type == MOUSEBUTTONUP and event.button == 1:                
                event_res = None
                
                for u in ui:
                    x = u.doevent(event)
                    if x:
                        event_res = x
                        
			
		if event_res == CFG_CELL or event_res == CFG_GPS:
		    if not use_gps.on and not use_cell.on:
			zbrowse.notification("With both cell-tower and GPS off, only WiFi locations are used. For this to work, you MUST associate every ZapLoc with a WiFi network")
		    
                # Any other button than disabled buttons (-1)
                # Should trigger a reload
                if event_res != -1:
                    result = CFG_RELOAD_DAEMON
                    grayout()
                        
                if event_res == None:
                    working = False

        screen.blit(background, (0,0))
        screen.blit(window, (0, pos))
        
        for u in ui:
            u.draw(screen, pos)
            
        pos *= 0.6
        if pos > -1:
            pos = 0
                
        clock.tick(30)
        pygame.display.flip()                                   

    
    config["daemon-start-on-boot"]  = True
    config["daemon-never-stop"]     = True

    config["daemon-interval"]        = gps_interval.selected    
       
    if use_cell.on:
	if use_gps.on:
	    config["daemon-method"]          = 1
	else:
	    config["daemon-method"]          = 0
    else:
	if use_gps.on:
	    config["daemon-method"]          = 2
	else:
	    config["daemon-method"]          = 3
	    
    
    config["daemon-autocheck"]       = autocheck.on
    config["daemon-autocheck-delay"] = autocheck_delay.selected

    config["daemon-gps-timeout"]     = (gps_timeout.selected + 1) * 10
    
                
    if config["latitude"]:
        config["daemon-latitude"]        = latitude.on
        config["daemon-latitude-freq"]   = latitude_interval.selected     

    config["daemon-force-connection"]    = force_connection.selected    
	
    pos = -5
    while pos > -800:
        for event in pygame.event.get():
            pass

        screen.blit(background, (0,0))
        screen.blit(window, (0,pos))                

        for u in ui:
            u.draw(screen, pos)        
            
        pos *= 1.5            
            
        clock.tick(30)
        pygame.display.flip()                                   

	
    return result


def config_checkins(screen, config):
    result = None
    
    background = screen.copy()    
    window = pygame.image.load("gfx/consolidate.png").convert_alpha()
    
    working = True    

    clock = pygame.time.Clock()

    my_font = pygame.font.Font(None, 32)

    my_string = "ZapLoc Check-in Settings"
    my_rect = pygame.Rect((200, 50, 400, 100))           
    
    try:
        rendered_text = ztext.render_textrect(my_string, my_font, my_rect, (255,255,255), 1, -1, (120,120,120))    
        if rendered_text:
            window.blit(rendered_text, my_rect.topleft)    
    except:
        pass
            
    my_font = pygame.font.Font(None, 30)    
    
    screen.set_clip(None)

    pos = - 800

    ui = []

    x = 130
    y =  120

    ui.append(zgui.StaticText(x    , y, "User interface for photos"))
    ui.append(zgui.PopupList (x+300, y, 200, ("ZapLoc Picker", "Maemo Dialog"), config["checkin-filedialog"] , True, CFG_MAPMODE))        
    
    ui.append(zgui.StaticText(x,     y+65, "FourSquare: Photos attach to:"))    
    ui.append(zgui.PopupList (x+300, y+65, 200, ("each check-in", "the Venue (public)"), config["checkin-foursquare"] , config["foursquare"], CFG_MAPMODE))        

    ui.append(zgui.Checkbox(x, y+180, "Avoid double-posting photos to Facebook", config["avoid-double-photo"], True,  TWITTERON))
    ui.append(zgui.Checkbox(x, y+ 95, "Include 'Homes' in FourSquare listings", config["foursquare-homes"], True,  TWITTERON))
    
    while working:
	zgps.get_location()
        for event in pygame.event.get():
            if event.type == QUIT:
                working = False
            if event.type == MOUSEBUTTONUP and event.button == 1:                
                event_res = None
                
                for u in ui:
                    x = u.doevent(event)
                    if x:
                        event_res = x
                        
                # Any other button than disabled buttons (-1)
                # Should trigger a reload
                if event_res != -1:
                    result = CFG_CHECKINS
                    # grayout()
                        
                if event_res == None:
                    working = False

        screen.blit(background, (0,0))
        screen.blit(window, (0, pos))
        
        for u in ui:
            u.draw(screen, pos)
            
        pos *= 0.6
        if pos > -1:
            pos = 0
                
        clock.tick(30)
        pygame.display.flip()                                   
	
    config["checkin-filedialog"] = ui[1].selected
    config["checkin-foursquare"] = ui[3].selected
    config["tw_poster"]          = "foursquare" # Legacy
    config["fb_poster"]          = "foursquare" # Legacy
    config["avoid-double-photo"] = ui[4].on
    config["foursquare-homes"]   = ui[5].on
    
    zfoursquare.post_photos_to_venue = config["checkin-foursquare"]

    pos = -5
    while pos > -800:
        for event in pygame.event.get():
            pass

        screen.blit(background, (0,0))
        screen.blit(window, (0,pos))                

        for u in ui:
            u.draw(screen, pos)        
            
        pos *= 1.5            
            
        clock.tick(30)
        pygame.display.flip()                                   

	
    return result


#
# Main setup dialog
#
def config_dialog(screen, config, zmap):
    result = None
    
    background = screen.copy()    
    window = pygame.image.load("gfx/dialog.png").convert_alpha()
    
    working = True    

    clock = pygame.time.Clock()

    my_font = pygame.font.Font(None, 32)

    my_string = "Settings"
    my_rect = pygame.Rect((200, 85, 400, 100))       

    try:
        rendered_text = ztext.render_textrect(my_string, my_font, my_rect, (255,255,255), 1, -1, (120,120,120))    
        if rendered_text:
            window.blit(rendered_text, my_rect.topleft)    
    except:
        pass
            
    my_font = pygame.font.Font(None, 30)    
    
    screen.set_clip(None)

    pos = - 800

    ui = []

    ui.append(zgui.StaticText(180, 120, "Maps"))
    ui.append(zgui.PopupList (250, 120, 200, zmaps.providers, zmap.get_mode(),          True, CFG_MAPMODE))    
    
    ui.append(zgui.Checkbox  (180, 170, "Background Updates", config["daemon-enable"],  True,  CFG_DAEMONON))    
    ui.append(zgui.Button    (455, 170, "Settings...",                                  config["daemon-enable"],  CFG_DAEMON))    

    ui.append(zgui.StaticText(240, 245, "Attached Services"))
    ui.append(zgui.Button    (455, 235, "Settings...",                                  True,  CFG_SERVICES))

    ui.append(zgui.StaticText(240, 310, "ZapLoc Checkins"))
    ui.append(zgui.Button    (455, 300, "Settings...",                                  True,  CFG_CHECKINS))
    
    while working:
	zgps.get_location()
        for event in pygame.event.get():
            if event.type == QUIT:
                working = False
            if event.type == MOUSEBUTTONUP and event.button == 1:                
                event_res = None
                
                for u in ui:
                    x = u.doevent(event)
                    if x != None:
                        event_res = x

                if event_res == CFG_MAPMODE:
                    zmap.set_mode(ui[1].selected)
                    working = False # Should we?
                        
                if event_res == CFG_SERVICES:
                    result = CFG_SERVICES
		    working = False

                if event_res == CFG_DAEMON:
                    result  = config_daemon(screen, config)
                    working = False                    

                if event_res == CFG_CHECKINS:
                    result  = config_checkins(screen, config)
                    working = False                    
		    
                if event_res == CFG_DAEMONON:
                    config["daemon-enable"] = ui[2].on
                    ui[3].set_enabled(config["daemon-enable"])                    
                    result = CFG_RELOAD_DAEMON
                    
                if event_res == None:
                    working = False

        screen.blit(background, (0,0))
        screen.blit(window, (0, pos))
        
        for u in ui:
            u.draw(screen, pos)
            
        pos *= 0.6
        if pos > -1:
            pos = 0
                
        clock.tick(30)
        pygame.display.flip()                                   
        
    pos = -5
    while pos > -800:
        for event in pygame.event.get():
            pass

        screen.blit(background, (0,0))
        screen.blit(window, (0,pos))                

        for u in ui:
            u.draw(screen, pos)        
            
        pos *= 1.5            
            
        clock.tick(30)
        pygame.display.flip()                                   
        
    zconfig.put(config)
	
    return result


# Allowing searches to be multithreaded
class searcher(threading.Thread):
    def __init__(self, svc, pos, friends, radius=50000):
        self.svc    = svc
        self.pos    = pos
        self.friends= friends
	if radius < 50000:
	    self.radius = radius
	else:
	    self.radius = 50000
        threading.Thread.__init__(self)
        
    def run(self):
        global thread_result, thread_busy
        thread_busy = self

        # Create a dictionary for de-duping
        d = dict()
        
        # Fill in old results
        for o in thread_result:
            d[o[0]] = o
        
        try:
            if self.friends:
                result = self.svc.list_friends(self.pos)
            else:
                result = self.svc.list_spots(self.pos, self.radius)        
               
            # Fill in  new results
            for o in result:                
                img = load_cached_image(o[4], o[5])                                                        
                d[o[0]] = ( o[0],o[1],o[2],o[3],img, o[6] )

            # Create values
            vals = d.values()
                
            # Put 'em in thread_results
            thread_result = vals
	except urllib2.URLError, e:
	    print e
	    try:
		zbrowse.dialog("HTTP Error: %d: %s :(" % ( e.code, BaseHTTPServer.BaseHTTPRequestHandler.responses[e.code][0] ))
	    except:
		zbrowse.dialog("HTTP Error: Timeout" )
        except:
            print "Unexpected error: ", sys.exc_info()[0]
            zbrowse.dialog("Error")
            
        thread_busy = None

# Allowing check-ins to be multithreaded
class checker(threading.Thread):
    def __init__(self, svc, a, b, c, d, e, f):
        self.svc    = svc
        self.a  = a
        self.b  = b
        self.c  = c
        self.d  = d
        self.e  = e
	self.f  = f
        
        threading.Thread.__init__(self)
        
    def run(self):
        global thread_busy
        thread_busy = self
        result = self.svc.check_in(self.a, self.b, self.c, self.d, self.e, self.f)
        thread_busy = None
        
        if result != None:
            for line in result:
                zbrowse.notification(line)
                pygame.time.wait(3000)
                    
def check_in(svc, a, b, c, d, e, f):
    if f != None:
	try:
	    print "Loading photo " + f
	    img = pygame.image.load(f)
	    print "Done"
	    ws  = 1024.0 / img.get_width() 
	    if ws > 1.0: ws = 1.0
	    hs  = 1024.0 / img.get_height()
	    if hs > 1.0: hs = 1.0
	    if ws > hs:
		s = hs
	    else:
		s = ws
	    if s != 1.0:
		print "Scaling photo %g percent" % (s * 100)
		img = pygame.transform.rotozoom(img, 0.0, s)
		print "Done"
		
	    print "Saving scaled image"
	    pygame.image.save(img, "/home/user/MyDocs/.maps/cache/photo.jpg")
	    print "Done"
	    
	    f = open("/home/user/MyDocs/.maps/cache/photo.jpg", "rb")
	except:
	    f = None
    
    checker(svc, a, b, c, d, e, f).start()                        
        
def check_in_dialog(screen, clicked_object, svc, config):   
    result = None
    
    background = screen.copy()    
    window = pygame.image.load("gfx/checkin.png").convert_alpha()
    
    working = True    

    clock = pygame.time.Clock()

    my_font = pygame.font.Font(None, 32)

    my_string = clicked_object[3]     
    my_rect = pygame.Rect((230, 130, 300, 300))       

    try:
        rendered_text = ztext.render_textrect(my_string, my_font, my_rect, (255,255,255), 0, -1, (120,120,120))    
        if rendered_text:
            window.blit(rendered_text, my_rect.topleft)    
    except:
        pass
    
    window.blit(clicked_object[4], (220 - clicked_object[4].get_rect().width,105))
        
    my_font = pygame.font.Font(None, 30)    
    
    screen.set_clip(None)

    pos = - 800

    ui = []

    pon  = pygame.image.load("gfx/photoon.png")
    poff = pygame.image.load("gfx/photooff.png")
    
    ui.append(zgui.Checkbox(550, 180, "Twitter",   True, True,  TWITTERON))
    ui.append(zgui.Checkbox(550, 240, "Facebook",  True, True,  FBON))              
    ui.append(zgui.Button  (550, 310, "Check In",  True,        CHECK_IN))
    
    if svc.can_post_photo():
	ui.append(zgui.TwoStateButton(470, 305, poff, poff,   True,  ADD_PHOTO))
    
    cursor_pos   = 0
    checkin_text = " "
    
    my_rect = pygame.Rect((160, 190, 350, 100))        
    
    window.fill((255,255,255), my_rect)
    pygame.draw.rect(window, (100,80,80), my_rect, 2)
    
    my_rect.inflate_ip(-10,-10)

    photo = None
    
    ignorekeys = (K_F1,K_F2,K_F3,K_F4,K_F5,K_F6,K_F7,K_F8,K_F9,K_F10,K_F11,K_F12,K_F13,K_F14,K_F15,K_NUMLOCK,K_CAPSLOCK,K_SCROLLOCK,
                  K_RSHIFT,K_LSHIFT,K_RCTRL,K_LCTRL,K_RALT,K_LALT,K_RMETA,K_LMETA,K_LSUPER,K_RSUPER,K_MODE,K_HELP,K_PRINT,K_SYSREQ,K_BREAK,K_MENU,K_POWER,
                  K_TAB,K_RETURN,K_CLEAR,K_ESCAPE,K_PAUSE )
    
    while working:
	zgps.get_location()
        for event in pygame.event.get():
            if event.type == QUIT:
                working = False
            if event.type == KEYDOWN:
                if event.key == K_LEFT:
                    if cursor_pos > 0:
                        cursor_pos -= 1
                elif event.key == K_RIGHT:
                    if cursor_pos < len(checkin_text):
                        cursor_pos += 1
                elif event.key == K_BACKSPACE:
                    if cursor_pos > 0:
                        checkin_text = checkin_text[:cursor_pos-1] + checkin_text[cursor_pos:]
                        cursor_pos -= 1
                elif event.key == K_DELETE:
                    if cursor_pos < len(checkin_text):
                        checkin_text = checkin_text[:cursor_pos] + checkin_text[cursor_pos+1:]                    
                elif event.key in ignorekeys:
                    pass
                else:
                    if len(checkin_text) < 101:
                        checkin_text = checkin_text[:cursor_pos] + event.unicode + checkin_text[cursor_pos:]                                            
                        cursor_pos += 1
            if event.type == MOUSEBUTTONUP and event.button == 1:                
                event_res = None
                
                for u in ui:
                    x = u.doevent(event)
                    if x:
                        event_res = x

                if event_res == ADD_PHOTO:
		    if config["checkin-filedialog"]:
			photo = zphotoui.file_dialog(screen)
		    else:
			photo = zphotoui.photo_dialog(screen)

		    if photo:
			ui[3].onimg = pon
		    else:
			ui[3].onimg = poff
			
		    ui[3].set_enabled(True)
			
                if event_res == CHECK_IN:
                    result = ( checkin_text, int(ui[0].on), int(ui[1].on), photo)
                    working = False
                        
                if event_res == None and not my_rect.collidepoint(event.pos):
                    working = False

        screen.blit(background, (0,0))
        screen.blit(window, (0, pos))

        
        srf = my_font.render("Chars left: %d" % ( 101 - len(checkin_text)), True, (150,120,90))
        screen.blit(srf, (160,295+pos))
        
        rendered_text = ztext.render_textrect(checkin_text, my_font, my_rect, (0,0,0), 0, cursor_pos)        
        if rendered_text:
            screen.blit(rendered_text, ( my_rect.left, my_rect.top + pos))            

        for u in ui:
            u.draw(screen, pos)
            
        pos *= 0.6
        if pos > -1:
            pos = 0
                
        clock.tick(30)
        pygame.display.flip()                                   
        
    pos = -5
    while pos > -800:
        for event in pygame.event.get():
            pass

        screen.blit(background, (0,0))
        screen.blit(window, (0,pos))                

        for u in ui:
            u.draw(screen, pos)        

        if rendered_text:
            screen.blit(rendered_text, ( my_rect.left, my_rect.top + pos))                        
            
        pos *= 1.5            
            
        clock.tick(30)
        pygame.display.flip()                                   
        
    return result


def show_info(screen, clicked_object, my_pos, center_pos, svc, svcs, config):

    result = None
    
    if my_pos[2] == my_pos[2]:
        acc = 1500 + abs(3 * my_pos[2])
    else:
        acc = 1500

    checkable = meter_distance(my_pos[0], my_pos[1],
                clicked_object[1], clicked_object[2]) < acc

    #if not checkable:
    #    zbrowse.dialog( "Site is more than %g away, can't check in" % acc)

    background = screen.copy()
    
    window = pygame.image.load("gfx/window.png").convert_alpha()
    
    working = True    

    clock = pygame.time.Clock()

    my_font = pygame.font.Font(None, 32)

    # print clicked_object
    
    my_string = clicked_object[3] 

    # print my_string
    
    my_rect = pygame.Rect((230, 115, 300, 150))    
    
    try:
        rendered_text = ztext.render_textrect(my_string, my_font, my_rect, (255,255,255), 0, -1, (120,120,120))    
    
        if rendered_text:
            window.blit(rendered_text, my_rect.topleft)    
    except:
        pass

    window.blit(clicked_object[4], (220 - clicked_object[4].get_rect().width,90))
        
    my_font = pygame.font.Font(None, 26)

    zspin.start(screen)
        
    try:
        clock.tick(10)
        desc = svc.get_description(clicked_object)    
    except:
        desc = ( "No description", None )

    zspin.stop()
                
    buttons = []
    
    buttons.append(zgui.Button(200-70, 310, "Show on Web", desc[1],   SHOW_ON_WEB))
    if svc.cfgname() == "zaploc":
        buttons.append(zgui.Button(385-70, 310, "Edit",        True,      EDIT_SPOT))
    else:
        buttons.append(zgui.Button(385-70, 310, "Make ZapLoc", True,      CONSOLIDATE))
    buttons.append(zgui.Button(570-70, 310, "Check In",    checkable, CHECK_IN))

    for b in buttons:
        b.draw(window)
        
        
    my_string = desc[0]
        
    my_rect = pygame.Rect((160, 180, 440, 110))    
    
    try:
        rendered_text = ztext.render_textrect(my_string, my_font, my_rect, (255,255,255), 0)    
    
        if rendered_text:
            window.blit(rendered_text, my_rect.topleft)            
    except:
        pass
    
    screen.set_clip(None)
            
    pos = - 800
    
    while working:
	zgps.get_location()
        for event in pygame.event.get():
            if event.type == QUIT:
                working = False
            if event.type == MOUSEBUTTONUP and event.button == 1:                

                do_something = None
                
                for b in buttons:
                    res = b.doevent(event)
                    if res:
                        do_something = res
                
                if do_something == SHOW_ON_WEB: 
                    if desc[1]:
                        zbrowse.open(desc[1])
                        working = False
                elif do_something == CONSOLIDATE: 
                    result = consolidate(screen, clicked_object, my_pos, center_pos, svc, svcs, desc)
                    working = False
                elif do_something == EDIT_SPOT: 
                    result  = edit_spot(screen, clicked_object, svcs)
                    working = False
                elif do_something == CHECK_IN:
                    result = check_in_dialog(screen, clicked_object, svc, config)
                    if result != None:
                        #wait  = pygame.image.load("gfx/download.png").convert()
                        #screen.set_clip(Rect(450,428,146,40))        
                        #screen.blit(wait, (450 - randint(1,100), 418))
                        #screen.set_clip(None)
                        #pygame.display.flip()

                        check_in(svc, clicked_object, my_pos, result[0], result[1], result[2], result[3])
                        result == CHECK_IN
                        working = False
                                                    
                if do_something == None:
                    working = False

        screen.blit(background, (0,0))
        screen.blit(window, (0,pos))
        
        pos *= 0.6
                
        clock.tick(30)
        pygame.display.flip()                                   
        
    pos = -5
    
    while pos > -800:
        for event in pygame.event.get():
            pass

        screen.blit(background, (0,0))
        screen.blit(window, (0,pos))                
        pos *= 1.5
                
        clock.tick(30)
        pygame.display.flip()                                   

    return result    

def setup_service(screen, service):
    if not service.is_authorized():
        do_auth(screen, service)
	# service.authorize() # TODO: TEST REMOVE
    if service.is_authorized():
        return ( 
            service, 
            pygame.image.load(service.onimg ()).convert_alpha(), 
            pygame.image.load(service.offimg()).convert_alpha()
        )
    else:
        return None

def main():
    global thread_busy, thread_result

    # TODO: Test this
    socket.setdefaulttimeout(SOCKET_TIMEOUT)
    
    config = zconfig.get()
    
    os.chdir("/opt/zaploc")
    #
    # Update old directory structure
    #
    if os.path.exists("/opt/zaploc/config.dat"):
        if not os.path.exists("/opt/zaploc/config.dat"):
            try:
                os.makedirs("/home/user/.zaploc")
            except:
                pass
        try:
            os.system("mv /opt/zaploc/*.dat /home/user/.zaploc")
            os.system("mv /opt/zaploc/*.db /home/user/.zaploc")
        except:
            pass
        
    pygame.init()
    pygame.font.init()
    
    info  = pygame.display.Info()
    displayflags = NOFRAME | HWSURFACE | DOUBLEBUF
    
    screen_x = info.current_w
    screen_y = info.current_h

    if screen_x <= 800 or screen_y <= 480:
        pygame.mouse.set_visible(False)    
	if config["fullscreen"]:
	    displayflags  |= FULLSCREEN
    
    screen = pygame.display.set_mode((800,480), displayflags )

    # We need key repeat for typin'
    pygame.key.set_repeat(150, 40)    
    
    logo   = pygame.image.load("gfx/titlecard.png")    
    screen.blit(logo, (0,0))
    pygame.display.flip()    
    logo   = None # Clear out from memory
    
    zoom = 15

    clock  = pygame.time.Clock()        
    
    dot    = pygame.image.load("gfx/dot.png")  .convert_alpha()
    close  = pygame.image.load("gfx/close.png").convert_alpha()

    wait  = pygame.image.load("gfx/download.png").convert()
    setup = pygame.image.load("gfx/setup.png").convert_alpha()
    plus  = pygame.image.load("gfx/plus.png").convert_alpha()
    minus = pygame.image.load("gfx/minus.png").convert_alpha()   

    cross  = pygame.image.load("gfx/crosshair.png").convert_alpha()       
    target = pygame.image.load("gfx/target.png").convert_alpha()       
    
    gpsbut = (
        pygame.image.load("gfx/gpsoff.png").convert_alpha(),
        pygame.image.load("gfx/gpson.png").convert_alpha(),
        pygame.image.load("gfx/gpstrack.png").convert_alpha()
    )
    
    zmap = zmaps.mapdisplay(screen)
    zmap.set_mode(config["mapmode"])    
    
    if not config["facebook"] and not config["gowalla"] and not config["facebook"] and not config["latitude"]:
        zbrowse.dialog("You must have at least one of the supported services configured and authorized before you can use ZapLoc")
        config_services(screen, config)

    gpsstate = config["gpsstate"]

    # Get last used position from config
    try:
        zgps.pos = ( config["lat"], config["lng"], 35, 50 )
    except:
        pass
    
    zgps.open()   
    zgps.enable(gpsstate)   
    my_pos = zgps.get_location()    

    # Off the map! Insanity! Restore Sanity!
    # ...where "Sanity" is defined as Fridstadstorget, Eskilstuna :)
    if my_pos[0] < -89 or my_pos[0] > 89 or my_pos[1] < -179 or my_pos[1] > 179:
	my_pos = (59.37096, 16.51406, 35, 50)
    
    # List of active services
    svcs = []

    # Load the database 
    zzaloc.get()
    
    x = setup_service(screen, zzaloc.Service())
    if x != None:
        svcs.append(x)
	
    '''
    try:        
        if config["gowalla"]:
            x = setup_service(screen, zgowalla.Service())
            if x != None:
                svcs.append(x)
    except:
        zbrowse.dialog("Error connecting to Gowalla")
    '''

    try:
        if config["foursquare"]:
            x = setup_service(screen, zfoursquare.Service())
            if x != None:
                svcs.append(x)
	    
	    zfoursquare.post_photos_to_venue = config["checkin-foursquare"]
    except:
        zbrowse.dialog("Error connecting to Foursquare")

    try:
        if config["facebook"]:
            x = setup_service(screen, zfacebook.Service())
            if x != None:
                svcs.append(x)
    except:
        zbrowse.dialog("Error connecting to Facebook")

    try:
        if config["latitude"]:
            x = setup_service(screen, zlatitude.Service())
            if x != None:
                 svcs.append(x)
    except:
        zbrowse.dialog("Error connecting to Latitude")

                
    svc = svcs[0][0]

    # Only one service (ZapLoc) - software is useless!!
    if len(svcs) == 1:
        zbrowse.dialog("You must have at least one of the supported services configured and authorized before you can use ZapLoc")

    zspin.start(screen)

    try:
	if config["daemon-enable"]:
            if test_if_running():
		print "Daemon is already running - good"
	    else:
		print "Daemon is not running - starting it"                
                os.system("/opt/zaploc/zaploc-daemon.py -d") # Launch it if it ISN'T running
        else:
            daemonize(1) # Kill it if it is running
    except:
        pass
        
    zspin.stop()
    
    # DEBUG:
    # show_info(screen, ( "Foo", my_pos[0], my_pos[1], "Testy Testlocation", pygame.image.load("gfx/fbplace.png").convert_alpha()), my_pos, svc, svcs)
    # config_dialog( screen, config, zmap ) 
        
    
    switch_to_service = None
    
    working      = True
    direction    = (0,0)
    dragging     = False
    dragging_pin = None

    down_pos = (0,0)
    
    center_pos   = my_pos        
    

    # print svcs[0][0].list_spots(my_pos, 50)
    
    map_pos = (0,0)

    have_searched = False
    update_count  = 5

    restart = False

    adjust_location = None
    adjust_image    = None
    adjust_id       = None
    unadjust_image  = None

    glow_effect       = None
    glow_effect_count = 0
    
    closest_spot_surface    = None
    closest_spot_surface_id = None
    spot_font = pygame.font.Font(None, 25)
    spot_rect = pygame.Rect(0,0,250,50)
    
    ui = []
    ui.append(zgui.Button    (200, 420, "OK",       True,  ADJUST_LOCATION))
    ui.append(zgui.Button    (450, 420, "Cancel.",  True,  -1))

    ui2 = []
    ui2.append(zgui.Button   (620, 350, "Check In", True,  CHECK_IN))
    
    while working:        
	for event in pygame.event.get():
            if event.type == QUIT:
                working = False

            if event.type == KEYDOWN:
                update_count = 5
                if event.unicode == '+':
                    if zoom <= zmap.maxzoom(): zoom += 1
                if event.unicode == '-':
                    if zoom >= zmap.minzoom(): zoom -= 1
		if event.unicode == 'f' or event.unicode == 'F':
		    displayflags ^= FULLSCREEN		    
		    screen = pygame.display.set_mode((800,480), displayflags)

		    if displayflags & FULLSCREEN:
			config["fullscreen"] = True
		    else:
			config["fullscreen"] = False
		    
                if event.unicode == 'n' or event.unicode == 'N':
                    zmap.next_mode()
                    if zoom > zmap.maxzoom(): zoom = zmap.maxzoom()
                    if zoom < zmap.minzoom(): zoom = zmap.minzoom()                    
		if event.unicode == '!':
		    zzaloc.desalinate()
                
            if event.type == MOUSEBUTTONDOWN and event.button == 1:
                down_pos = event.pos                    
                old_pos  = down_pos
                if event.pos[1] < 420:                    
                    if gpsstate == 0:
                        pxl = zmap.pos2pixel(my_pos)
                        if event.pos[0] > pxl[0] - 30 and event.pos[0] < pxl[0] + 30 and event.pos[1] > pxl[1] - 60 and event.pos[1] < pxl[1]:
			    try:
				clickpos = zmap.pixel2pos(event.pos)
				dragging_pin = ( clickpos[0] - my_pos[0], clickpos[1] - my_pos[1] )
			    except:
				pass
                        else:
                            dragging = True                                                
                    else:
                        dragging = True
                                        
            if event.type == MOUSEBUTTONUP and event.button == 1:
                dx = abs(down_pos[0] - event.pos[0])
                dy = abs(down_pos[1] - event.pos[1]) 
                dragging     = False                
                dragging_pin = None
                update_count = 5

                # Too short to be motion - assume a click
                if dx < 25 and dy < 25:
                      
                    # Check exit button click
                    if event.pos[0] > 740 and event.pos[1] < 50: # close
                        working = False
                    # check button-row clicks
                    elif event.pos[1] > 420:
                        if event.pos[0] > 660 and event.pos[0] < 724:
                            if zoom >= zmap.minzoom(): zoom -= 1
                        elif event.pos[0] > 724 and event.pos[0] < 800:
                            if zoom <= zmap.maxzoom(): zoom += 1
                        elif adjust_location:
                            for u in ui:
                                x = u.doevent(event)
                                if x == -1:
                                    # Snap view to old position
                                    center_pos = ( adjust_location[1], adjust_location[2] )
                                    # Disable adjustment mode
                                    adjust_location = None
                                    adjust_image    = None
                                    adjust_image2   = None
                                    adjust_id       = None
                                if x == ADJUST_LOCATION:
                                    for o in zzaloc.database:
                                        if o["id"] == adjust_location[0]:
                                            o["lat"] = center_pos[0]
                                            o["lng"] = center_pos[1]
                                    zzaloc.put()
                                    # Disable adjustment mode
                                    adjust_location = None
                                    adjust_image    = None
                                    adjust_image2   = None
                                    adjust_id       = None
                                    # Update the icons                                    
                                    switch_to_service = svcs[0][0]
                                    # Add some artsy glow
                                    glow_effect       = ( center_pos[0], center_pos[1] )
                                    glow_effect_count = 20                                
                        elif event.pos[0] > 596 and event.pos[0] < 660:
                            gpsstate += 1
                            if gpsstate > 2: 
                                gpsstate = 0
                            config["gpsstate"] = gpsstate
                            zgps.enable(gpsstate)                            
                        elif event.pos[0] > 380 and event.pos[0] < 380+64:
                            ret = config_dialog(screen, config, zmap)
			    if ret == CFG_RELOAD_DAEMON:
				if config["daemon-enable"]:
				    if test_if_running():
					print "Daemon configuration has changed - restarting Daemon"
				    else:
					print "Starting Daemon"
				    # (Re)Start Daemon
				    os.system("/opt/zaploc/zaploc-daemon.py -d") 
				else:
				    print "Stopping Daemon"
				    daemonize(1) # Kill it if it is running				
			    elif ret == CFG_CHECKINS:
				pass # Do nothing, config dialog already wrote the config file
                            elif ret == CFG_SERVICES:
				if config_services(screen, config):
				    working = False
				    restart = True
				    zbrowse.notification("Service configuration has changed - re-starting program")
                        else:
                            x_pos = 0
                            for service in svcs:
                                if event.pos[0] > x_pos and event.pos[0] < x_pos + 64:
                                    switch_to_service = service[0]
                                x_pos += 64
                                                        
                    else: # Above the bottom line and not exit - check objects
			if svc.poscheckin() and ui2[0].doevent(event) == CHECK_IN:
			    zspin.start(screen)
			    
			    try:
				result = svc.check_in(my_pos, "")
			    except:
				result = ( "Failed to check in to Latitude" )
				
			    zspin.stop()

			    if result != None:
				for line in result:
				    zbrowse.notification(line)
				    
				glow_effect       = (my_pos[0], my_pos[1])
				glow_effect_count = 15
			
                        clicked_object = None
                        
                        if not adjust_location:
                            for spot in thread_result:
                                # spot = item[1]
                                pxl = zmap.pos2pixel((spot[1], spot[2]))
                                if event.pos[0] > pxl[0]-40 and event.pos[0] < pxl[0] + 40 and event.pos[1] > pxl[1]-80 and event.pos[1] < pxl[1]:
                                    clicked_object = spot
                                   
                        if clicked_object != None:
                            direction = ( 0, 0 )

			    #glow_effect = (clocked_object[1], clicked_object[2])
			    #glow_effect_count = 4

			    screen.set_clip(Rect(0,0,800,420))
			    
			    pxl = zmap.pos2pixel((clicked_object[1], clicked_object[2]))
			    bottom_center_blit(screen, clicked_object[4], pxl, BLEND_RGBA_ADD)
			    new_spot_effect(screen, pxl, 4)
			    
			    pygame.display.flip()

			    screen.set_clip(None)
			    
                            ret = show_info(screen, clicked_object, my_pos, center_pos, svc, svcs, config)
                            
                            if type(ret) == type((0,0)):
                                switch_to_service = svcs[0][0]
                                glow_effect       = ret
                                glow_effect_count = 20
                                update_count      = 20

			    if ret == EDIT_SPOT:
				switch_to_service = svcs[0][0]
                                    
                            if ret == ADJUST_LOCATION:
                                adjust_location   = clicked_object
                                adjust_id         = clicked_object[0]
                                adjust_image      = pygame.transform.rotozoom(clicked_object[4], 0.0, 1.2)
                                adjust_image2     = make_adjust_image(clicked_object[4])
                                                                
                                # clicked_object  = ( clicked_object[0], clicked_object[1], clicked_object[2], clicked_object[3], make_adjust_image(clicked_object[4]) )
                                center_pos      = ( clicked_object[1], clicked_object[2] )
                            if ret == CFG_DELETE_SPOT:
                                zzaloc.remove(clicked_object[0])
                                glow_effect       = ( clicked_object[1], clicked_object[2] )
                                glow_effect_count = 20
                                update_count      = 20
                                switch_to_service = svcs[0][0]
                else:
                    have_searched = False
                            
            if event.type == MOUSEMOTION and event.pos[1] < 420: 
                if dragging:
		    try:
			map_pos     = zmap.pixel2pos(old_pos)
			new_map_pos = zmap.pixel2pos(event.pos)                
			old_pos     = event.pos
			direction   = ( map_pos[0] - new_map_pos[0], map_pos[1] - new_map_pos[1])    
		    except:
			pass			
                elif dragging_pin != None:
		    try:
			new_pos = zmap.pixel2pos(event.pos)
			my_pos  = ( new_pos[0] - dragging_pin[0], new_pos[1] - dragging_pin[1], my_pos[2], my_pos[3] )                    
			update_count = 5
		    except:
			pass

        if gpsstate > 0:
            pxlpos  = zmap.pos2pixel(my_pos)
            my_pos  = zgps.get_location()
            pxlpos2 = zmap.pos2pixel(my_pos)

            # Did the pin move? We need a screen update. Boohoo :)
            if abs(pxlpos[0]-pxlpos2[0]) > 2 or abs(pxlpos[1]-pxlpos2[1]) > 2:
                if pxlpos2[0] > 0 and pxlpos2[0] < 800 and pxlpos2[1] > 0 and pxlpos2[1] < 500:
                    update_count = 1
            
            if dragging: # When dragging, disable tracking
                gpsstate = 1
            if gpsstate == 2: # Tracking
                direction = ( (my_pos[0] - center_pos[0]) * 0.2, (my_pos[1] - center_pos[1]) * 0.2)
                
        screen.set_clip(Rect(0,0,800,420))

        center_pos = ( center_pos[0] + direction[0], center_pos[1] + direction[1])

	if center_pos[0] > 89: 
	    center_pos = ( 89, center_pos[1] )
	    direction  = ( -abs(direction[0] * 0.2), direction[1] )
	if center_pos[0] < -89: 
	    center_pos = ( -89, center_pos[1] )
	    direction  = (  abs(direction[0] * 0.2), direction[1] )
	if center_pos[1] > 179: 	    
	    center_pos = ( center_pos[0], 179 )
	    direction  = ( direction[0], -abs(direction[1]) * 0.2 )
	if center_pos[1] < -179: 
	    center_pos = ( center_pos[0], -179 )
	    direction  = ( direction[0],  abs(direction[1]) * 0.2 )
            
        direction  = ( direction[0] * 0.9, direction[1] * 0.9 )

        if switch_to_service != None and not thread_busy:
            # Time to switch service!
            svc = switch_to_service            
            switch_to_service = None
            # Clear out results from old service
            thread_result    = []
            # Start a new search
            have_searched = True
            searcher(svc, center_pos, False, zmap.radius()).start()
        
        # Scrolling slows to a crawl: Halt it, and do a search
        if abs(direction[0]) < 0.001 and abs(direction[1]) < 0.001 and not thread_busy and not dragging and not have_searched:
            have_searched = True
            searcher(svc, center_pos, False, zmap.radius()).start()                                                        
                
        if zmap.set_center(center_pos, zoom) or thread_busy:
            update_count = 10

        if update_count > 0:
            update_count -= 1
            zmap.display()                        

	    closest_spot = None
	    closest_dist = 0.0

	    for spot in thread_result:                
		dist = meter_distance(center_pos[0], center_pos[1], spot[1], spot[2])
		if closest_spot == None or dist < closest_dist:
		    closest_spot = spot
		    closest_dist = dist
	    
	    if svc.cfgname() == "zaploc":			
		if closest_spot != None and closest_spot[0] != adjust_id:
		    radius = (closest_spot[5] / (40000000 / (2.0 ** zmap.zoom)) * 512) / math.cos(math.radians(center_pos[1]))
		    if radius > 2:
			pxl    = zmap.pos2pixel((closest_spot[1], closest_spot [2]))
			pygame.draw.circle(screen, (32,200,255,0), ( int(pxl[0]), int(pxl[1]) ), int(radius), 1)
	    
            for spot in thread_result:                
                pxl = zmap.pos2pixel((spot[1], spot[2]))
                if spot[0] == adjust_id:

		    if spot[5] > 0.0:
			radius = (spot[5] / (40000000 / (2.0 ** zmap.zoom)) * 512) / math.cos(math.radians(center_pos[1]))
			if radius > 2:
			    pygame.draw.circle(screen, (32,200,255,0), (400,220), int(radius), 1)
		    
                    bottom_center_blit(screen, adjust_image2, pxl)
                else:
                    bottom_center_blit(screen, spot[4], pxl)

	    if closest_spot:
		if closest_spot_surface_id != closest_spot[0]:
		    try:
			closest_spot_surface = ztext.render_textrect(closest_spot[3], spot_font, spot_rect, (64,64,64), 1, -1, (255,255,255))    
		    except:
			pass
		    closest_spot_surface_id = closest_spot[0]

		pxl = zmap.pos2pixel((closest_spot[1], closest_spot[2]))
		if closest_spot_surface:
		    screen.blit(closest_spot_surface, (pxl[0]-spot_rect.width/2, pxl[1]))  

            pxl = zmap.pos2pixel(my_pos)

	    if svc.poscheckin():
		for u in ui2:
		    u.set_pos((pxl[0]-80,pxl[1]+32))
                    center_blit(screen, target, (pxl[0], pxl[1]-1))
		    u.draw(screen, 0)
		    
            bottom_center_blit(screen, dot, pxl)               

            if glow_effect:
                pxl = zmap.pos2pixel(glow_effect)
                new_spot_effect(screen, pxl, glow_effect_count)
                glow_effect_count -= 1
                if glow_effect_count <= 0:
                    glow_effect = None
                update_count = 5
            
            screen.blit(close, (745, 15))           

            if adjust_location:
                bottom_center_blit(screen, adjust_image, (400,210))
                screen.blit(target,(400-50, 220-50))           
            else:
                screen.blit(cross, (400-33, 220-35))           

		
		
	    #wifi = zgps.get_wifi()
	    #if wifi:
	    #   wifi_rect = pygame.Rect((0,0,250,22))
	    #   wifi_surface = ztext.render_textrect(wifi[0], spot_font, wifi_rect, (64,64,64), 0, -1, (255,255,255))
	    #   screen.blit(wifi_surface, (450,10))
		
            screen.set_clip(Rect(0,420,800,60))
            screen.fill(Color(220,200,170), Rect(0,420,800,60))
	    
            screen.blit(minus, (660, 416))
            screen.blit(plus,  (724,416))

            if adjust_location:
                for u in ui:
                    u.draw(screen, 0)
            else:
                screen.blit(gpsbut[gpsstate], (596,416))
                screen.blit(setup, (380,416))
                # Draw active service icons
                xpos = 0            
                for service in svcs:
                    if svc == service[0]:
                        pic = service[1]
                    else:
                        pic = service[2]                
                    screen.blit(pic, (xpos, 416))
                    xpos += 64            

            if thread_busy and not adjust_location:
                screen.set_clip(Rect(450,428,146,40))        
                screen.blit(wait, (450 - randint(1,100), 418))                    
                    
            clock.tick(30)
            pygame.display.flip()               
        else:
            clock.tick(10)
            pygame.display.flip()                           

    config["mapmode"] = zmap.get_mode()

    config["lat"] = center_pos[0]
    config["lng"] = center_pos[1]

    # If daemon set to "off", kill it when exiting
    
    if not config["daemon-enable"]: # config["daemon-never-stop"]:
	print "Stopping Daemon"
        daemonize(1)  # Kill it if it is running
    
    # Save the configuration    
    zconfig.put(config)
            
    print "Et tu, Brute..."
    
    pygame.display.quit()
    try:
        # Some shit pygame drops after itself
        os.remove("/opt/zaploc/music.raw")
    except:
        pass

    zgps.close()    

    return restart

if __name__ == '__main__': 
    while (main()):
        pass
