import sys
import time
import pickle
import zbrowse as webbrowser
import pygame

import zfoursquare
import zfacebook
import zgowalla

database = None

def get():
    global database
    try:
        f = open("/opt/zaploc/consolidated.db")
        database = pickle.load(f)
        f.close()        
        
        #for x in database:
        #    print x
    except:
        database = []
        
def put():
    global database

    if database == None:
        return
    
    try:
        f = open("/opt/zaploc/consolidated.db", "w")
        pickle.dump(database, f)
        f.close()        
    except:        
        webbrowser.dialog("Error saving ZapLoc database")    

def release():
    global database
    database = None

def add(item):
    global database

    svcs = ( "foursquare", "gowalla", "facebook" )

    for s in svcs:
        if s in item:    
            for x in database:
                if s in x and x[s] == item[s]:
                    database.remove(x)

    idnumber = 0
    
    for x in database:
        q = int(x["id"])
        if q > idnumber:
            idnumber = q
                    
    idnumber += 1
    item["id"] = "%d" % idnumber    

    # print item
    
    database.append(item)
    put()
    
    return item["id"]

def remove(item):
    global database
    
    for x in database:
        if item == x["id"]:
            database.remove(x)
    
    put()


def getlastcheckin():
    try:
        f = open("/opt/zaploc/lastcheckin.db")
        checkins = pickle.load(f)
        f.close()

        return checkins[-1]["id"]
    except:
        return None
    
def addcheckin(checkin):
    checkins = None

    checkin["checkintime"] = time.time()
    
    try:
        f = open("/opt/zaploc/lastcheckin.db")
        checkins = pickle.load(f)
        f.close()
    except:
        pass

    if checkins == None: 
        checkins = []
    
    # Add the checkin
    checkins.append(checkin)
    
    # More than 20 - kill the first (oldest) checkin
    if len(checkins) > 20:
        checkins.remove(checkins[0])
        
    try:
        f = open("/opt/zaploc/lastcheckin.db", "w")
        pickle.dump(checkins, f)
        f.close()        
    except:        
        webbrowser.dialog("Error saving ZapLoc checkin log")    

    
class Service():
        
    def is_authorized(self):            
        return True
        
    def authorize(self):                        
        pass

    def list_spots(self, my_pos, radius):
        global database

        output = []
        
        for spot in database:            
            # print spot
            output.append((
                spot["id"], 
                float(spot["lat"]), float(spot["lng"]), 
                spot["name"],                                    
                spot["image"],
                spot["scale"]                    
            ))
        
        return output
            
            

    def list_friends(self, my_pos):
        return []

    def get_description(self, spot):
        global database

        for o in database:
            if o["id"] == spot[0]:
                return ( o["description"], o["link"] )
            
        return ( "No Description", None )
    
    def check_in(self, spot, my_pos, text, twitter, facebook):
        global database        
        
        result = [ " Check in Failed for Some Reason(tm) " ]
        
        for item in database:
            if item["id"] == spot[0]:                
                result = [ "Doing Consolidated Check-in at " + spot[3] ]
                svcs = ( zgowalla.Service(), zfoursquare.Service(), zfacebook.Service() )

                for svc in svcs:
                    if svc.is_authorized():
                        cfgname = svc.cfgname()
                        if cfgname in item:
                            tw = 0
                            fb = 0
                            if item["tw_poster"] == cfgname:
                                tw = twitter
                            if item["fb_poster"] == cfgname:
                                fb = twitter
                            
                            res = svc.check_in((item[cfgname],item["lat"],item["lng"],item["name"]), my_pos, text, tw, fb)
                            
                            if res != None:
                                for a in res:
                                    result.append(a)                                    
                                twitter  = False
                                facebook = False                    
                                
                # Save it as "last checkin"
                addcheckin(item)
        
        return result

    def name(self):
        return "ZapLoc"
    
    def cfgname(self):
        return "zaploc"
    
    def onimg(self):
        return "gfx/zlon.png"
    
    def offimg(self):
        return "gfx/zloff.png"    
    
    def tweetable(self):
        return False
        
    def facebookable(self):
        return False
    