import pygame
import threading

spinning   = False

# Spinning wheel of Death
class spinner(threading.Thread):
    def __init__(self, screen):
        self.screen     = screen
        threading.Thread.__init__(self)
        
    def run(self):
        global spinning
        clock = pygame.time.Clock()

        angle = 0.0

        # Give it a few seconds w/o it...
        self.screen.set_clip(None)
        
        countdown = 10
        
        while spinning:
            if countdown > 0:
                countdown -= 1
                if countdown == 0:
                    self.spinner    = pygame.image.load("gfx/spin.png").convert_alpha()
                    self.background = pygame.Surface((200,200), 0, self.spinner)        
                    rect = pygame.Rect(400-100,200-100,200,200)        
                    self.background.blit(self.screen, (0,0), rect)                    
            else:
                angle += 15.0
                img = pygame.transform.rotozoom(self.spinner, angle, 1.0)
                imgr = img.get_rect()            
                self.screen.blit(self.background, (400-100, 200-100))
                self.screen.blit(img, (400 - imgr.width / 2, 200 - imgr.height/ 2))                            
                pygame.display.flip()
                
            clock.tick(20)                       
    
def start(screen):
    global spinning
    spinning = True
    spinner(screen).start()
    

def stop():
    global spinning
    spinning = False

