import pygame
import math
import os, pygame, math
import urllib, urllib2
from pygame.locals import *

import threading

XOFS =  400
YOFS =  220

cache = None
pic_loaded = False

urls = ( "http://mt.google.com/vt?z=%d&x=%d&y=%d",
         "http://mt.google.com/vt?lyrs=s&z=%d&x=%d&y=%d",         
         "http://c.andy.sandbox.cloudmade.com/tiles/cycle/%d/%d/%d.png",
         "http://tile.openstreetmap.org/%d/%d/%d.png",
         "http://tah.openstreetmap.org/Tiles/tile/%d/%d/%d.png"
)

cachefiles = (  
    "/home/user/MyDocs/.maps/Google Maps/%d/%d/%d.png",
    "/home/user/MyDocs/.maps/Google Satellite/%d/%d/%d.png",
    "/home/user/MyDocs/.maps/OpenCycleMap/%d/%d/%d.png",
    "/home/user/MyDocs/.maps/OpenStreetMap I/%d/%d/%d.png",
    "/home/user/MyDocs/.maps/OpenStreetMap II/%d/%d/%d.png"
)

maxzooms = (
    20,
    20,
    17,
    18,
    18
)

minzooms = (
    0,
    0,
    0,
    0,
    0
)

providers = (
    "Google Maps",
    "Google Sattelite",
    "Open Cycle Maps",
    "Open Streetmap",
    "Open Streetmap II"    
)

# Allowing searches to be multithreaded
class loader(threading.Thread):
    def __init__(self, x, y, zoom, mode):
        global cache
        self.cachenr = (x % 8) + (y % 4) * 8
        self.x       = x
        self.y       = y
        self.zoom    = zoom
        self.mode    = mode
        threading.Thread.__init__(self)
        
    def run(self):
        global cache
        global pic_loaded
        
        url       = urls[self.mode]       % (self.zoom, self.x, self.y)
        cachefile = cachefiles[self.mode] % (self.zoom, self.x, self.y)

        if not os.path.isfile(cachefile):    
            path = os.path.dirname(cachefile)
            if not os.path.exists(path):
                try:
                    os.makedirs(path)
                except:
                    pass
                
            result   = urllib.urlopen(url) 
            content  = result.read()    
            fout     = open(cachefile, "wb")
            fout.write(content)
            fout.close()

        # Don't stomp it if another thread has changed zoom level
        if cache[self.cachenr][0] == self.x and cache[self.cachenr][1] == self.y and cache[self.cachenr][3] == self.zoom:        
            try:
                cache[self.cachenr] = ( self.x, self.y, pygame.image.load(cachefile).convert(), self.zoom )
            except:
                os.remove(cachefile)
                # cache[self.cachenr] = ( 0, 0, self.empty )
            pic_loaded = True


def deg2num(lat_deg, lon_deg, zoom):
    lat_rad = math.radians(lat_deg)
    n = 2.0 ** zoom
    xpos  = (lon_deg + 180.0) / 360.0 * n
    ypos  = (1.0 - math.log(math.tan(lat_rad) + (1 / math.cos(lat_rad))) / math.pi) / 2.0 * n
    xtile = int(xpos)
    ytile = int(ypos)
    return(xtile, ytile, xpos-xtile, ypos-ytile)
    
def num2deg(xtile, ytile, zoom):
    n = 2.0 ** zoom
    lon_deg = xtile / n * 360.0 - 180.0
    lat_rad = math.atan(math.sinh(math.pi * (1 - 2 * ytile / n)))
    lat_deg = math.degrees(lat_rad)
    return(lat_deg, lon_deg)

class mapdisplay():
    def __init__(self, surface):
        global cache
        self.empty = pygame.image.load("gfx/loading.png").convert()
        cache = []
        for i in range(32):
            cache.append(( 0, 0, self.empty, 0 ))
        self.surface  = surface
        self.zoom     = 0
        self.lastzoom = 0
        self.mode     = 0
        self.lastcentpx = (0,0)
        self.centrect   = (0,0,0,0)
        
    def clear_cache(self):
        global cache
        for o in range(32):
            cache[o] = (0,0,self.empty,0)

    def get_mode(self):
        return self.mode
            
    def set_mode(self, mode):    
        if self.mode != mode:            
            self.mode = mode
            self.clear_cache()
            print "Map url " + urls[self.mode]
                
    def next_mode(self):
        new_mode = self.mode + 1
        if new_mode >= len(urls):
            new_mode = 0        
        self.set_mode(new_mode)
        
    def maxzoom(self):
        return maxzooms[self.mode]

    def minzoom(self):
        return minzooms[self.mode]
        
    def getrect(self, bx, by):
        global cache
        x  = self.centrect[0] + bx
        y  = self.centrect[1] + by
        xx = self.centrect[2] * 256
        yy = self.centrect[3] * 256
        
        cachenr = (x % 8) + (y % 4) * 8

        if cache[cachenr][0] != x or cache[cachenr][1] != y or cache[cachenr][3] != self.zoom:
            # Start as empty cache
            cache[cachenr] = ( x, y, self.empty, self.zoom )
            # If in range...

            xmax = 2.0 ** self.zoom
            ymax = xmax / 2.0
            
            if (x >= 0 and y >= 0 and x <= xmax and y <= ymax):
                x = loader(x, y, self.zoom, self.mode)
                x.start()
                    
        self.surface.blit(cache[cachenr][2], ((256*bx)-xx + XOFS,(256*by)-yy + YOFS))

    def rect2pixel(self, rect):
        return (int((rect[0] + rect[2]) * 256), int((rect[0] + rect[2]) * 256))
        
    def display(self):
        for x in range(-2,3):
            for y in range(-1,2):
                self.getrect(x, y)        
        
    def set_center(self, center, zoom):
        global cache, pic_loaded
        self.center = center
        self.zoom   = zoom        
        
        self.centrect = deg2num(center[0],center[1],zoom)

        changed = False

        if pic_loaded:
            pic_loaded = False
            changed = True
        
        centpx = self.rect2pixel(self.centrect)
        
        # Did we move at least one pixel?
        if centpx != self.lastcentpx:
            self.lastcentpx = centpx
            changed = True                
                        
        # Zoom changed - clear the cache
        if self.zoom != self.lastzoom:
            changed = True
            for f in cache:
                f = ( 0, 0, self.empty, -1 )
            
        self.lastzoom = self.zoom
        
        return changed

    def pos2pixel(self, pos):
        res = deg2num(pos[0], pos[1], self.zoom)            
        return ( (res[0]+res[2]-self.centrect[0]-self.centrect[2]) * 256 + XOFS, (res[1]+res[3]-self.centrect[1]-self.centrect[3]) * 256 + YOFS)

    def pixel2pos(self, pixel):
        pixel = ( (pixel[0]-XOFS)/256.0 + self.centrect[2]+self.centrect[0], (pixel[1]-YOFS)/256.0 + self.centrect[2]+self.centrect[1])

        try:
            res = num2deg(pixel[0], pixel[1], self.zoom)
        except:
            res = (0,0)                    
    
        return res
