from apiclient.discovery import build
import zbrowse as webbrowser
import BaseHTTPServer
import logging
import socket
import sys
import zurl

import httplib2
import pickle

from apiclient.discovery import build
from apiclient.oauth import FlowThreeLegged
from apiclient.ext.file import Storage

# Uncomment to get detailed logging
# httplib2.debuglevel = 4

def run(flow, storage):
  """
  Modified version of the google 'flow()' for Three-legged OAuth, now calling the
  actual system webbrowser
  """
  host_name = 'localhost'
  port_numbers = [8080, 8090]

  server_class = BaseHTTPServer.HTTPServer
  zurl.RedirectHandler.service = "Latitude"
  try:
    port_number = port_numbers[0]
    httpd = server_class((host_name, port_number), zurl.RedirectHandler)
  except socket.error:
    port_number = port_numbers[1]
    try:
      httpd = server_class((host_name, port_number), zurl.RedirectHandler)
    except socket.error:
      return False

  oauth_callback = 'http://%s:%s/' % (host_name, port_number)
  authorize_url = flow.step1_get_authorize_url(oauth_callback)

  webbrowser.open(authorize_url)

  httpd.handle_request()
  if 'error' in httpd.query_params:
    sys.exit('Authentication request was rejected.')
  if 'oauth_verifier' in httpd.query_params:
    code = httpd.query_params['oauth_verifier']

  try:
    credentials = flow.step2_exchange(code)
  except RequestError:
    sys.exit('The authentication has failed.')

  storage.put(credentials)
  credentials.set_store(storage.put)

  return credentials

class Service():
    def is_authorized(self):    
        storage = Storage('/opt/zaploc/latitude.dat')
        self.credentials = storage.get()
        if self.credentials is None or self.credentials.invalid == True:
            return False
        return True
        
    def authorize(self):                                
        auth_discovery = build("latitude", "v1").auth_discovery()
        storage = Storage('/opt/zaploc/latitude.dat')
        flow = FlowThreeLegged(auth_discovery,
                               # You MUST have a consumer key and secret tied to a
                               # registered domain to use the latitude API.
                               #
                               # https://www.google.com/accounts/ManageDomains
                               consumer_key='989316022849.apps.googleusercontent.com',
                               consumer_secret='Wlc_ppFDjGYpgsxAetT6lAWA',
                               user_agent='google-api-client-python-latitude/1.0',
                               domain='989316022849.apps.googleusercontent.com',
                               scope='https://www.googleapis.com/auth/latitude',
                               xoauth_displayname="Zap's Location Updater",
                               location='current',
                               granularity='best'
                               )
    
        self.credentials = run(flow, storage)

    def list_spots(self, my_pos, radius):
        return []

    def list_friends(self, my_pos):
        return []

    def get_description(self, spot):
        return ( "Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry's standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged.", None )
      
    def check_in(self, my_pos, text):
        http = httplib2.Http()
        http = self.credentials.authorize(http)
      
        service = build("latitude", "v1", http=http)
      
        body = {
            "data": {
                "kind": "latitude#location",
                "latitude":  my_pos[0],
                "longitude": my_pos[1],
                # "altitude":  my_pos[2],
                "accuracy":  my_pos[3]
                }
            }
        
        print service.currentLocation().insert(body=body).execute()

        return ["Checked you in at %g, %g on Latitude" % (my_pos[0], my_pos[1])]

    def name(self):
        return "Google Latitude"
    
    def cfgname(self):
        return "latitude"
    
    def onimg(self):
        return "gfx/lton.png"
    
    def offimg(self):
        return "gfx/ltoff.png"    

    def tweetable(self):
        return False
        
    def facebookable(self):
        return False
      