#!/usr/bin/python

#
# ZDaemon 0.9
# 
# Small portions of this code was borrowed from 
# Anssi Kolehmainen <anssi@aketzu.net>, although
# very little of that code is still left, some
# traces remain (like struct and function names
# and overall layout), all the code interfacing
# with Google Latitude is changed
#

import math

import zlatitude   # Zaps Google Latitude service
import zconfig     # ZapLoc configuration file manager
import zzaloc      # The ZapLoc (meta) service
import zbrowse
import time

try:
    import location
    import gobject
except:
    pass

import time
import socket
import os
import sys
import getopt
import signal

# These values are hardcoded
EPS               = 100   # Two points within this meter distance are ignored
UPDATE_AT_MOST    = 2     # NEVER send out more than every two minutes (only matters if some other app has the GPS on)
ACC_LIMIT         = 150   # Accuracy limit - never accept GPS positions with worse accuracy than this

# These values are read from the config file

# For google latitude; 
# even tho we DIDN'T move, update with AT LEAST this frequency (in minutes)
# This is to keep updates from becoming "stale" in the friends list
UPDATE_AT_LEAST   = 60    

# When getting a good GPS fix, we will sleep the GPS for this number of minutes and then re-awaken it
GPS_INTERVAL      = 5     


zlat   = None
zconf  = None


verbose=0
test   =0

def meter_distance( lata, lnga, latb, lngb ):
    dx  = lata - latb
    dy  = lnga - lngb
    dy *= math.sin(lata)
    dist  = math.sqrt(dx*dx+dy*dy)
    dist *= 40000000 / 360
    return dist    

def get_config(conf, name, default=0):
    try:
	return conf[name]
    except:
	return default

class LocationData:
    lat=0
    lng=0
    alt=0
    acc=0
    alt=0
    altacc=0
    head=0
    speed=0;

    prevlat=0
    prevlng=0
    prevalt=0
    prevacc=0

    prevupd=0
    prevupd2=0
    prevacc=9999

    last_spot_count      = 0
    last_spot_id         = None
    
    def push(self):
	global service
	global verbose
	global zconf
	
	if time.time() - self.prevupd < UPDATE_AT_MOST * 60: # and self.acc > self.prevacc:
	    # if verbose: print "Update not posted because not enough time has passed"
	    return True

	if self.lat == 0 or self.lng == 0:
	    return True

	#  First do Latitude, which we will do more often if we get updates more often
	
	if zlat:
	    if meter_distance(self.lat, self.lng, self.prevlat, self.prevlng) < EPS and time.time() - self.prevupd < UPDATE_AT_LEAST * 60:
		if verbose: print "Updates within %g meters - not sending" % EPS
	    else:
		if verbose: print "%s: Location update %f,%f (acc %f)" % (time.strftime('%Y-%m-%d %H:%M:%S'),self.lat,self.lng,self.acc)
		try:
		    if not test: zlat.check_in((self.lat, self.lng, self.alt, self.acc), "")
		except:
		    print "Error updating location", sys.exc_info()[0]
		    return True

	# With Latitude done, we want to make the other stuff at a gentler pace...
	# Make sure we hold it "GPS_INTERVAL" times apart, even though we may get here
	# more often (as most UPDATE_AT_MOST interval)
	
	if time.time() - self.prevupd2 > GPS_INTERVAL * 60 * 0.75: 
	    self.prevupd2 = time.time()
	    
	    if verbose: print "Searching for closest spot:"

	    # Check if any service is even on!
	    if get_config(zconf, "foursquare", True) or get_config(zconf, "gowalla", True) or get_config(zconf, "facebook", True):
		# Read in the spot database
		zzaloc.get()
    
		closest_item = None
		closest_dist = 5000
    
		# Find the closest spot in the database
		for item in zzaloc.database:
		    if item["auto-check"]:
			dist = meter_distance(item["lat"], item["lng"], self.lat, self.lng)
			if dist < closest_dist:
			    closest_dist = dist
			    closest_item = item
			    
		if closest_item != None:
		    if verbose: print "The closest AutoCheck spot is %s at %g meters" % ( closest_item["name"], closest_dist )
		    
		    maxdist = closest_item["auto-distance"]
		    
		    if closest_dist < maxdist:
			if zzaloc.getlastcheckin() == closest_item["id"]:
			    # If we are already checked in to this spot - do nothing
			    if verbose: print "We are already checked in at %s so we will do nothing" % closest_item["name"]
			else:
			    if self.last_spot_id == closest_item["id"]:
				# Increase the count of times we've been here
				self.last_spot_count += 1
				if verbose: print "We have now been at %s %d times" % ( closest_item["name"], self.last_spot_count)
				
				if self.last_spot_count > get_config(zconf,"daemon-autocheck-delay", 2):
				    self.last_spot_count = -1 # Mark as "we checked in"
				    if verbose:
					print "****************************************************"
					print "FINALLY: We are checking in at %s!" % closest_item["name"]
					print "****************************************************"

				    service = zzaloc.Service()
				    
				    if service.is_authorized():
					if test:
					    result = ( "Test mode:" , "No actual checkin performed" )
					    zzaloc.addcheckin(closest_item)
					else:
					    result = service.check_in(
						(closest_item["id"],
						 closest_item["lat"],
						 closest_item["lng"],
						 closest_item["name"]), 
						 (self.lat, self.lng ), 
						 closest_item["auto-message"], 
						 int(closest_item["auto-tweet"]),
						 int(closest_item["auto-facebook"])
					    )
					if result != None:
					    for line in result:
						zbrowse.notification(line)
						time.sleep(3)
			    else:
				# Sorry, different spot, reset spot count
				self.last_spot_count = 0
				if verbose: print "Freshly arrived at %s" % closest_item["name"]

			    # Now remember this for next time
			    self.last_spot_id = closest_item["id"]			
		    else:
			if verbose: print "Spot ignored because it is further than %g meters away" % maxdist

		# Throw away the memory for the list of spots
		zzaloc.release()			
	else:
	    if verbose: print "Below GPS interval - no checking nearest spot"
	    
	self.prevupd = time.time()
	self.prevacc = self.acc
	self.prevlat = self.lat
	self.prevlng = self.lng
	self.prevalt = self.alt

	return True
  
curloc = LocationData()

fix_tries = 0

def push_location():
    return curloc.push()

def update_loc(mode, lat, lng, acc, alt, altacc, head, speed, data):
    global verbose
    global acclimit
    global once
    global fix_tries

    if verbose: print "%s: Got loc data %f,%f (acc %f) alt %f (%f), head %f, speed %f, Mode %d, Try %d" % (time.strftime('%Y-%m-%d %H:%M:%S'),lat,lng,acc, alt, altacc, head, speed, mode, fix_tries)

    # Ignore cached or country-size measurements
    if mode < 2:
	return

    # Skip the NaN's in accuracy
    if acc != acc:
	return

    # I don't care about data of low accuracy
    if acc > ACC_LIMIT:
	return

    if altacc > 32000:
	altacc=0

    fix_tries += 1

    # Try at least three times to get a "type 3 fix"
    if mode < 3 and fix_tries < 3:
	return

    fix_tries = 0

    curloc.lat=lat
    curloc.lng=lng
    curloc.acc=acc
    curloc.alt=alt
    curloc.altacc=altacc
    curloc.head=head
    curloc.speed=speed

    curloc.push()

    if speed < 10 or speed != speed:
	data.stop()
	print "Sleeping GPS"

    return

def on_error(control, error, data):
    print "location error: %d..." % error

def on_changed(device, data):
    if not device:
        return
    if device.fix:
        if device.fix[1] & location.GPS_DEVICE_LATLONG_SET:
	    update_loc(device.fix[0], device.fix[4], device.fix[5], device.fix[6]/1000, device.fix[7], device.fix[8], device.fix[9], device.fix[11], data)
            #lat, lon, eph,  altitude, epv, track, speed

def restart_gpsd(control):
    global verbose
    if verbose: print "Starting GPS..."
    control.start()
    return True

def start_location(data):
    data.start()
    return False

def usage():
    print "ZapLoc Daemon - Zaps Location Updater Daemon v0.9"
    print " -h  This help message"
    print " -d  Run as Daemon (the normal thing to do)"
    print " -b  Launch as Daemon from boot"
    print " -t  Terminate Daemon (if running)"
    print " -s  Simulate (don't actually send any updates). Useful together w. 'verbose' for testing"
    print " -v  Verbose output"
    # print " -i  Install Daemon to run at boot"
    # print " -u  Uninstall Daemon from running at boot"

def init():
    socket.setdefaulttimeout(10)

    loop = gobject.MainLoop()
    control = location.GPSDControl.get_default()
    device = location.GPSDevice()
    control.set_properties(preferred_method=location.METHOD_USER_SELECTED, #ACWP
                           preferred_interval=location.INTERVAL_120S)

    control.connect("error-verbose", on_error, loop)
    device.connect("changed", on_changed, control)
    # control.connect("gpsd-stopped", on_stop, loop)

    gobject.idle_add(start_location, control)
    gobject.timeout_add(GPS_INTERVAL * 60000, restart_gpsd, control)
    loop.run()

def daemonize(on):
    # Kill any already running daemons...
    os.system("echo `ps -ef | grep \"python.*zdaemon.py\" | grep -v grep | awk '{print $1}'` > pids.txt")

    if not on:
	return

    fp = open("pids.txt")
    foo = fp.read()
    fp.close()

    os.remove("pids.txt")

    ary = foo.split(" ")
    for foo in ary:
	try:
	    p = int(foo)
	    if p>0 and p != os.getpid():
		os.kill(p, signal.SIGTERM)
	except:
	    pass

    pid = os.fork()
    if (pid == 0):
	os.setsid()
	pid = os.fork()
	if (pid == 0):
	    os.umask(0)
	else:
	    os._exit(0)
    else:
	os._exit(0)

    os.close(0);
    os.close(1);
    os.close(2);
"""
def install_daemon(ins):
    if ins:
	try:
	    f = open("/etc/event.d/zaploc", "w")
	    f.write("description \"ZapLoc - Zap's Location Updater\"\n")
	    f.write("start on started hildon-desktop\n")
	    f.write("stop on starting shutdown\n\n")
	    f.write("console none\n\n")
	    f.write("script\n")
	    f.write("    exec /bin/su - user -c "/opt/zaploc/zdaemon.py --boot\n")
	    f.write("end script\n")
	except:
	    print "Can't write /etc/event.d/zaploc"
    else:
	try:
	    os.remove("/etc/event.d/zaploc")
	except:
	    print "Can't delete /etc/event.d/zaploc"
"""

def main(argv):
    global verbose, service, once, zlat, test, zconf

    try:
	opts, args = getopt.getopt(argv, "hdvtbs", ["help", "verbose", "boot" ])
    except getopt.GetoptError:
	usage()
	sys.exit(2)

    # Read in the configuration
    zconf = zconfig.get()

    UPDATE_AT_LEAST   = (  99999, 1*60, 2*60, 6*60, 24*60)     [get_config(zconf, "daemon-interval", 1)]
    GPS_INTERVAL      = (      5,   10,   15,   30,    60,   0)[get_config(zconf, "daemon-latitude-freq", 1)]
    
    try: 
	if not zconf["daemon-enable"]:
	    print "Daemon is disabled in configuration - exiting"
	    return
    except:
	print "Configuration is damaged - exiting"
	return	    
    
    
    if zconf["latitude"] and zconf["daemon-latitude"]:
	zlat = zlatitude.Service()
	if not zlat.is_authorized():
	    zlat.authorize()	

    for opt,arg in opts:
	if opt in ("-h", "--help"):
	    usage()
	    sys.exit(0)
	elif opt in ("-d"):
	    daemonize(True)
	elif opt in ("-t"):
	    daemonize(False)
	if opt in ("-v"):
	    verbose=1
	if opt in ("-s"):
	    test=1
	if opt in ("-b", "--boot"):
	    try: 
		if not zconf["daemon-start-on-boot"]:
		    print "Daemon startup at boot disabled - exiting"
		    return
	    except:
		print "Configuration is damaged - exiting"
		return	    
	    daemonize(True)
	"""
	if opt in ("-i"):
	    install_daemon(True)
	if opt in ("-u"):
	    install_daemon(False)
	"""

    init()

if __name__ == '__main__': main(sys.argv[1:])
