# Load the configuration

import pickle
import os

def get():
    try:
        f = open("/opt/zaploc/config.dat")
        conf = pickle.load(f)
        f.close()        
    except:        
        conf = dict()
        conf["gowalla"]                = False
        conf["foursquare"]             = False
        conf["facebook"]               = False
        conf["latitude"]               = False
        conf["gpsstate"]               = 2    
        conf["mapmode"]                = 0

        conf["daemon-enable"]          = True
        conf["daemon-start-on-boot"]   = 0
        conf["daemon-never-stop"]      = 0

        conf["daemon-interval"]        = 1  #  5, 10, 15, 30, 60, CELLTOWER
        conf["daemon-autocheck"]       = False
        conf["daemon-autocheck-delay"] = 2
        conf["daemon-latitude"]        = False
        conf["daemon-latitude-freq"]   = 2

        conf["lat"] = 59.37096 
        conf["lng"] = 16.51406
    return conf

def put(conf):
    try:
        f = open("/opt/zaploc/config.dat", "w")
        pickle.dump(conf, f)
        f.close()        
    except:        
        os.remove("/opt/zaploc/zaploc.dat")
