pos = (59.37096, 16.51406, 35, 50)

control = None
device  = None


try:
    import gtk
    import location
    import gobject
    import threading

    def on_error(control, error, data):
        print "location error: %d... quitting" % error
     
    def on_changed(device, data):
        global pos
        if not device:
            return
        if device.fix:
            if device.fix[1] & location.GPS_DEVICE_LATLONG_SET:
                pos = device.fix[4:8]
                print pos
               
    def get_location():
        # Pump GTK events
        while gtk.events_pending(): 
            gtk.main_iteration()
        return pos
    
    def enable(state):
        global control
        if state:
            control.start()
        else:
            control.stop()    
        
    def open():
        global control, device
        
        control = location.GPSDControl.get_default()
        device  = location.GPSDevice()
        control.set_properties(preferred_method  =location.METHOD_AGNSS,
                               preferred_interval=location.INTERVAL_10S)
         
        control.connect("error-verbose", on_error)
        device.connect ("changed",       on_changed, control)      
        
    def close():
        global control, device
        control.stop()
        control = None
        device  = None
            
except:    
    def get_location():
        return pos
    
    def enable(state):
        pass
    
    def open():
        pass
    
    def close():
        pass
