# -*- coding: utf-8 -*-
from re import sub
import dbus, youtubedialogs
from PyQt4.QtGui import *
from PyQt4.QtCore import *
from PyQt4.phonon import Phonon
from PyQt4.QtMaemo5 import QMaemo5InformationBox
from youtubeservice import YouTubeDataService, YouTubeVideoFeed, YouTubeVideoDownloader
from youtubeconfig import VideoDownloadSettings
from Ui_videoplaybackwindow import Ui_VideoPlaybackWindow
from utilities import Utilities

class VideoPlaybackWindow(QMainWindow, Ui_VideoPlaybackWindow):
    def __init__(self, parent, video=None, playlist=None):
        QMainWindow.__init__(self, parent)
        self.setupUi(self)
        self.setAttribute(Qt.WA_Maemo5LandscapeOrientation, True)
        self.setAttribute(Qt.WA_DeleteOnClose)
        self.player = Phonon.VideoPlayer(Phonon.VideoCategory, self)
        self.player.setVisible(False)
        self.layout.addWidget(self.player)
        self.video = video
        self.playlist = playlist
        self.seekBar = Phonon.SeekSlider(self.player.mediaObject(), self.toolBar)
        self.toolBar.addWidget(self.seekBar)
        self.toolBar.addWidget(self.durationLabel)
        self.player.mousePressEvent = self.toggleControls
        self.timer = QTimer(self)
        self.player.mediaObject().setPrefinishMark(5000)
        self.player.mediaObject().setTickInterval(0)
        self.player.mediaObject().setTransitionTime(-2000)
        self.connect(self.timer, SIGNAL("timeout()"), self.toggleSwitch)
        self.connect(self.listWidget.horizontalScrollBar(), SIGNAL("valueChanged(int)"), self.resetTimer)
        self.connect(self.player.mediaObject(), SIGNAL("prefinishMarkReached(qint32)"), self.queueNextVideo)
        self.connect(self.player.mediaObject(), SIGNAL("currentSourceChanged(const Phonon::MediaSource&)"), self.displayCurrentVideoInfo)
        self.connect(self.player.mediaObject(), SIGNAL("stateChanged(Phonon::State, Phonon::State)"), self.stateChanged)
        self.connect(self.player.mediaObject(), SIGNAL("finished()"), self.on_stopButton_clicked)
        self.connect(self.player.mediaObject(), SIGNAL("tick(qint64)"), self.tick)
        self.currentVideo = 0
        self.showFullScreen()
        if self.video != None:
            mediasource = self.getMediaSource(self.video)
        else:
            mediasource = self.getMediaSource(self.playlist[0])
        self.player.play(mediasource)
        self.keepDisplayOn()
        for button in (self.playButton, self.pauseButton, self.stopButton, self.previousButton, self.nextButton):            
            button.setStyleSheet("background-color: rgb(0, 0, 0, 255)")
            self.connect(button,  SIGNAL("pressed()"), self.changeButtonStyleSheet)
            self.connect(button,  SIGNAL("released()"), self.changeButtonStyleSheet)
            
    def stateChanged(self, newState, oldState):
        if newState == Phonon.ErrorState:
            QMaemo5InformationBox.information(self, "Error")
            self.on_stopButton_clicked()           
        elif newState == Phonon.PlayingState:
            self.player.setVisible(True)
            self.loadingLabel.setVisible(False)
            if not self.player.mediaObject().hasVideo():
                QMaemo5InformationBox.information(self, "Unable to connect to YouTube")
                self.on_stopButton_clicked()

    def changeButtonStyleSheet(self):
        button = self.sender()
        if button.isDown():
            button.setStyleSheet("background-color: #4ABEFF")            
        else:
            button.setStyleSheet("background-color: rgb(0, 0, 0, 255)")
                    
    def tick(self, a):
        if a >= 10:            
            self.disconnect(self.player.mediaObject(), SIGNAL("tick(qint64)"), self.tick)
            self.connect(self.player.mediaObject(), SIGNAL("tick(qint64)"), self.ticking)
            if self.playlist != None:
                try:
                    self.showPlaylistBar()
                except:
                    pass
            else:
                try:
                    self.getVideoRelated()
                except:
                    pass

    def ticking(self, time):
        if time >= 3600000:
            hr = round(time / 3600000, 0)
            displayHr = "%d:" % hr
        else:
            displayHr = ""
        displayTime = QTime(0, (time / 60000) % 60, (time / 1000) % 60)
        self.elapsedtime.setText("%s%s" % (displayHr, displayTime.toString('mm:ss')))
        
    def keepDisplayOn(self):
        bus = dbus.SystemBus()
        mce = bus.get_object("com.nokia.mce", "/com/nokia/mce/request")
        mce.req_display_blanking_pause()
        QTimer.singleShot(9000, self.keepDisplayOn)
        
    def displayCurrentVideoInfo(self):
        self.likeAction.setVisible(True)
        self.dislikeAction.setVisible(True)
        self.toggleSwitch()
        if self.playlist == None:
            videoTitle = unicode(self.video.media.title.text, "utf-8")
            dT = Utilities.fT(float(self.video.media.duration.seconds))
            self.durationLabel.setText("%s" % dT)
        else:
            videoTitle = unicode(self.playlist[self.currentVideo].media.title.text, "utf-8")
            dT = Utilities.fT(float(self.playlist[self.currentVideo].media.duration.seconds))
            self.durationLabel.setText("%s" % dT)
        self.titleLabel.setText("%s" % videoTitle)
        self.setWindowTitle("%s" % videoTitle)
        QMaemo5InformationBox.information(self, "Playing \'%s\'" % videoTitle)       

    def toggleSwitch(self, a=False):
        if self.playlist != None:
            self.listWidget.setVisible(a)
            self.previousButton.setVisible(a)
            self.nextButton.setVisible(a)
        self.titleLabel.setVisible(a)
        self.toolBar.setVisible(a)
        self.stopButton.setVisible(a)
        self.playButton.setVisible((a and self.player.isPaused()))
        self.pauseButton.setVisible((a and self.player.isPlaying()))
        if a:
            self.player.mediaObject().setTickInterval(1000)            
        else:
            self.player.mediaObject().setTickInterval(0)
            
    def resetTimer(self):
        self.timer.stop()
        self.timer.start(10000)
        
    def toggleControls(self, event=None):
        if self.toolBar.isVisible():
            self.toggleSwitch()
            self.timer.stop()
        else:
            self.toggleSwitch(a=True)
            self.timer.start(10000)
                  
    def getMediaSource(self, video):
        filename = "%s/%s.mp4" % (VideoDownloadSettings.downloadFolder, sub('[\"<>:"/|?*\\\\]', "-", video.media.title.text).decode("utf-8"))
        if QFile.exists(filename):
            self.loadingLabel.setText(unicode("Please wait!\nStart loading video from device.", "utf-8"))
            mediasource = Phonon.MediaSource(filename)
            self.downloadAction.setVisible(False)
        else:            
            videoUrl = YouTubeDataService.getVideoUrl(video.media.video_id.text, True)
            if videoUrl == "":
                self.loadingLabel.setText(unicode("Error!\nVideo is only viewable on youtube website", "utf-8"))
                QTimer.singleShot(3000, self.on_stopButton_clicked)
            else:
                self.loadingLabel.setText(unicode("Please wait!\nStart loading video from YouTube.", "utf-8"))
                mediasource = Phonon.MediaSource(videoUrl)
                self.downloadAction.setVisible(True)
        return mediasource
            
    def queueNextVideo(self):
        if self.playlist != None and self.video == None:
            try:
                video = self.playlist[self.currentVideo + 1]
                mediasource = self.getMediaSource(video)
                self.player.mediaObject().enqueue(mediasource)
                self.currentVideo += 1
            except:
                pass

    @pyqtSignature("")
    def on_favplstAction_triggered(self):
        self.player.pause()
        self.player.setVisible(False)
        a = youtubedialogs.AddVideoToPlaylistFavoriteDialog(self, self.playlist[self.currentVideo])
        self.connect(a, SIGNAL("finished(int)"), self.player.play)
        self.toggleSwitch()
        self.timer.stop()

    @pyqtSignature("")
    def on_downloadAction_triggered(self):
        self.toggleSwitch()
        self.downloadAction.setVisible(False)
        try:
            YouTubeVideoDownloader.addTask(self.playlist[self.currentVideo])
            QMaemo5InformationBox.information(self, "\'%s\' has been added to your download queue" % unicode(self.playlist[self.currentVideo].media.title.text, "utf-8"))
            self.emit(SIGNAL("downloadsChanged(int)"), len(YouTubeVideoDownloader.taskQueue))
        except:
            QMaemo5InformationBox.information(self, "Unable to add video to your download queue")

    @pyqtSignature("")
    def on_likeAction_triggered(self):
        YouTubeDataService.addLikeOrDislike("like", self.playlist[self.currentVideo].media.video_id.text)
        self.toggleSwitch()
        self.likeAction.setVisible(False)
        self.dislikeAction.setVisible(False)

    @pyqtSignature("")
    def on_dislikeAction_triggered(self):
        YouTubeDataService.addLikeOrDislike("dislike", self.playlist[self.currentVideo].media.video_id.text)
        self.toggleSwitch()
        self.likeAction.setVisible(False)
        self.dislikeAction.setVisible(False)
            
    @pyqtSignature("")
    def on_previousButton_clicked(self):
        if self.playlist != None and self.player.currentTime() <= 5000:
            video = self.playlist[self.currentVideo - 1]
            mediasource = self.getMediaSource(video)
            if self.currentVideo > 0:
                self.currentVideo -= 1                
            else:
                self.currentVideo = len(self.playlist) - 1
            self.player.play(mediasource)
            self.listWidget.item(self.currentVideo).setSelected(True)
        else:
            self.player.seek(0)
            
    @pyqtSignature("")
    def on_nextButton_clicked(self):
        if self.playlist != None:
            try:
                video = self.playlist[self.currentVideo + 1]
                self.currentVideo += 1                
            except:
                video = self.playlist[0]
                self.currentVideo = 0
            mediasource = self.getMediaSource(video)
            self.player.play(mediasource)
            self.listWidget.item(self.currentVideo).setSelected(True)
            
    @pyqtSignature("")
    def on_stopButton_clicked(self):
        self.player.stop()
        if self.video != None:
            try:
                while self.yt.isRunning():
                    self.yt.wait()
            except:
                pass
        if self.playlist != None:
            self.emit(SIGNAL("dataLoaded(PyQt_PyObject)"), self.playlist[self.currentVideo])
        else:
            self.emit(SIGNAL("dataLoaded(PyQt_PyObject)"), self.video)        
        self.player.deleteLater()
        self.close()
        
    @pyqtSignature("")
    def on_pauseButton_clicked(self):
        self.player.pause()
        self.playButton.setVisible(True)
        self.pauseButton.setVisible(False)      
        self.timer.stop()
        
    @pyqtSignature("")
    def on_playButton_clicked(self):
        self.player.play()
        self.pauseButton.setVisible(True)
        self.playButton.setVisible(False)     
        self.timer.start(10000)
        
    @pyqtSignature("QListWidgetItem*")
    def on_listWidget_itemClicked(self):
        row = self.listWidget.currentRow()
        try:
            video = self.playlist[row]
            self.currentVideo = row
        except:
            video = self.playlist[0]
            self.currentVideo = 0
        mediasource = self.getMediaSource(video)
        self.player.play(mediasource)

    def showPlaylistBar(self):        
        for video in self.playlist:
            thumbUrl = video.media.thumbnail[0].url
            thumbnail = YouTubeDataService.getVideoThumbnail(thumbUrl)
            icon = QIcon()
            icon.addPixmap(thumbnail, QIcon.Normal, QIcon.Off)
            item = QListWidgetItem(self.listWidget)
            item.setIcon(icon)            
            self.listWidget.addItem(item)

    def getVideoRelated(self):
        for link in self.video.link:
            if link.rel.split("#")[-1] == "video.related":
                videoFeed = link.href
        self.yt = YouTubeVideoFeed(self, videoFeed, 20)
        self.connect(self.yt, SIGNAL("thumbnailLoaded(PyQt_PyObject)"), self.showVideoRelatedBar)
        self.connect(self.yt, SIGNAL("feedCompleted(bool)"), self.dataloaded)
        self.yt.start()
        
    def showVideoRelatedBar(self, thumbdata):
        row, thumbnail = thumbdata
        icon = QIcon()
        icon.addPixmap(thumbnail, QIcon.Normal, QIcon.Off)
        item = QListWidgetItem(self.listWidget)
        item.setIcon(icon)            
        self.listWidget.addItem(item)

    def dataloaded(self):
        self.playlist = self.yt.videoList
        self.playlist.insert(0, self.video)
        self.disconnect(self.yt, SIGNAL("feedCompleted(bool)"), self.dataloaded)
