from PyQt4.QtGui import *
from PyQt4.QtCore import *
from Ui_webviewwindow import Ui_WebViewWindow
from youtubeconfig import GeneralSettings


class WebViewWindow(QMainWindow, Ui_WebViewWindow):
    def __init__(self, parent, uri=None, title="FlashPlayer"):
        QMainWindow.__init__(self, parent)
        self.setupUi(self)
        self.setWindowTitle(title)        
        self.setAttribute(Qt.WA_Maemo5StackedWindow)
        self.setAttribute(Qt.WA_Maemo5AutoOrientation, GeneralSettings.autoOrientation)
        self.url = "%s?version=3&controls=0&autoplay=1&showinfo=0" % uri.replace("watch?v=", "v/")
        self.progressBar = QProgressBar(self)
        self.progressBar.setTextVisible(False)
        self.toolBar.addWidget(self.progressBar)
        self.connect(self.webView, SIGNAL("loadProgress(int)"), self.updateLoadProgress)
        self.connect(self.webView, SIGNAL("loadFinished(bool)"), self.loadFinished)
        if self.url != None:
            self.webView.load(QUrl(self.url))
        else:
            self.webView.load(QUrl("about:blank"))
        
    def updateLoadProgress(self, progress):
        self.progressBar.setValue(progress)

    def showLargerScreen(self):
        self.webView.setGeometry(QRect(0, 0, 480, 270))        
        
    def loadFinished(self):
        self.toolBar.setVisible(False)
        self.show()
        QTimer.singleShot(4000, self.showLargerScreen)

    def closeEvent(self,  event):
        try:
            self.webView.load(QUrl("about:blank"))
        except:
            pass
        
