#!/usr/bin/env python
# -*- coding: utf-8 -*-

import sys
import os
import string
import time
import pickle
import ConfigParser
from optparse import OptionParser
from optparse import OptionValueError
from urllib import urlencode
import gdata.youtube
import gdata.youtube.service

if os.geteuid() == 0:
  print "Don't run this as root, please..."
  sys.exit(1)


STATE_FILE = "/tmp/ytcli_state"
FEED_FILE  = "/tmp/ytcli_feed"
DL_LOG = "/tmp/ytcli_log"
Q_LOCK = "/tmp/ytcli_qlock"
Q_FILE = "/tmp/ytcli_q"
COOKIE_FILE = "/tmp/ytcli_cookies.txt"
D = "DEFAULT"
Q_PID = "/tmp/ytcli_qpid"

# create YouTubeService
yt_service = gdata.youtube.service.YouTubeService()
yt_service.developer_key = 'AI39si5PI-lgxP2o9_5dCqEUm7g5CwODmafNi4J8qY4SMdAxKVLlMdP9VkPfJHEtSnYk1qnBG59DRm7t9O4JRTXygHYUWRhpwQ'

# load state file
config = ConfigParser.SafeConfigParser({"index": "1"})
config.read(STATE_FILE)

# parse options
parser = OptionParser("usage: %prog [-a] {-f TERM|-r ID|-q ID|-p ID|-y YID|-s|-u|-k|-x REALLY} ")
parser.add_option("-f", "--find", action="store", dest="find",
                  help="do a search for TERM. Searching repeatedly for the \
                        same TERM will load 50 more results",
                  metavar="TERM", type="string")
parser.add_option("-q", "--queue", action="store", dest="queue",
                  help="queue the search result number ID for downloading",
                  metavar="ID", type="int")
parser.add_option("-a", "--authors", action="store_true", dest="authors",
                  help="also show authors of videos")
parser.add_option("-s", "--status", action="store_true", dest="status",
                  help="show the status of the download queue")
parser.add_option("-m", "--more", action="store_true", dest="more",
                  help="show up to 50 more results using the last search term")
parser.add_option("-p", "--play", action="store", dest="play",
                  help="play the video number ID as a direct stream",
                  metavar="ID", type="int")
#parser.add_option("-q")
parser.add_option("-y", "--play-youtube", action="store", dest="playYoutube",
                  help="play a video with youtube id YID",
                  metavar="YID", type="string") 
parser.add_option("-k", "--kill", action="store_true", dest="kill",
                  help="kill the queue downloader. Partially downloaded \
                        videos will be continued in the future.")
parser.add_option("-u", "--resume", action="store_true", dest="resume",
                  help="start the downloader and continue downloading")
parser.add_option("-r", "--remove", action="store", dest="remove",
                  help="Remove position ID from the download queue. Removing \
                  ID 0 cancels the current download.",
                  metavar="ID", type="int")
parser.add_option("-x", "--reset", action="store", dest="reset",
                  help="kill the queue and remove all ytcli temp files. \
                        Supply 'REALLY' as an argument to do this",
                  metavar="REALLY", type="string")
(options, args) = parser.parse_args()

# functions
def finish():
  '''save the current state and close all files'''
  configfile = open(STATE_FILE, 'wb')
  config.write(configfile)
  configfile.close() 
  sys.exit(0)

def print_dict_elements(d):
  '''print the titles of the supplied feed'''
  for entry in d:
    #print entry[0] + ": " + entry[1]
    print str(entry) + ": " + d[entry][0]

def load_retained_dict():
  '''unpickle the existing dict of results or return an empty dict'''
  try:
    f = open(FEED_FILE, "r")
    d = pickle.load(f)
    f.close()
    return d
  except IOError:
    return {}

def retain_dict(d):
  '''retain the dict in a pickled file'''
  f = open(FEED_FILE, "wb")
  f.truncate()
  pickle.dump(d, f)
  f.close()

def extract_video_id(entry):
  '''extract the last part of y typical youtube URL'''
  return string.split(entry.id.text, "/")[-1]

def make_dict_from_feed(feed, index):
  '''save list ids, displayed names and video ids in a dict'''
  d = {}
  counter = int(index)
  for entry in feed.entry:
    if options.authors:
      d[counter] = [entry.title.text + 
                    " (" +
                    str(entry.author[0].name.text) + 
                    ")",
                    extract_video_id(entry)]
    else:
      d[counter] = [entry.title.text,
                    extract_video_id(entry)]
    counter += 1
  return d

def acquire_lock():
  '''lock the queue file'''
  while True:
    try:
      lock = os.open(Q_LOCK, os.O_CREAT|os.O_EXCL|os.O_RDWR)
      return lock
    except:
      time.sleep(1)

def free_lock(lock):
  '''allow access to the queue file'''
  os.close(lock)
  os.remove(Q_LOCK)

def queue(id):
  '''add a video to the download queue and launch the downloader'''
  d = load_retained_dict()
  try: vid = d[id]
  except KeyError:
    print str(id) + " is not a valid key"
    sys.exit(1)
  lock = acquire_lock()
  try:
    l = {}
    if os.path.isfile(Q_FILE):
      f = open(Q_FILE, "r")
      l = pickle.load(f)
      f.close()
    l[len(l)] = vid
    f = open(Q_FILE, "w")
    f.truncate()
    pickle.dump(l, f)
    f.close()
    print "Added: " + vid[0]
  except IOError:
    print "There has been a fatal error handling " + Q_FILE
  finally:
    free_lock(lock)
    sys.stdout.flush()
    os.system("/usr/bin/python /opt/ytcli/ytcli_queue.py &")

def remove(id):
  '''remove a video from the queue. cancel the current download if necessary'''
  lock = acquire_lock()
  try:
    l = {}
    if os.path.isfile(Q_FILE):
      f = open(Q_FILE, "r")
      l = pickle.load(f)
      f.close()
    try:
      info = l[id][0]
      del l[id]
      print "Removed: " + info
    except:
      print str(id) + " is not in the download queue"
    f = open(Q_FILE, "w")
    f.truncate()
    pickle.dump(l, f)
    f.close()
  except IOError:
    print "There has been a fatal error handling " + Q_FILE
  finally:
    free_lock(lock)
  if id == 0:
    kill(True)
    sys.stdout.flush()
    os.system("/usr/bin/python /opt/ytcli/ytcli_queue.py &")
 

def status():
  lock = acquire_lock()
  try:
    l = {}
    if os.path.isfile(Q_FILE):
      f = open(Q_FILE, "r")
      l = pickle.load(f)
      f.close()
    else:
      print "No downloads in the queue"
      sys.exit(0)
    if len(l) == 0:
      print "No downloads in the queue"
      sys.exit(0)
    else:
      print ">> " + str(len(l)) + " downloads in the queue:"
      for vid in l:
        print str(vid) + ": " + l[vid][0]
  except IOError:
    print "There has been a fatal error handling " + Q_FILE
  finally:
    free_lock(lock)
  if os.path.isfile(DL_LOG):
    print ">> Current or most recent download log:"
    log = open(DL_LOG,"rb")
    print log.read()
    log.close()

def play(id):
  d = load_retained_dict()
  try: vid = d[id]
  except KeyError:
    print id + " is not a valid key"
    sys.exit(1)
  print "Fetching " + vid[0] 
  import subprocess
  import shlex
  call = ("youtube-dl --max-quality '34'  -g --cookies " + COOKIE_FILE + 
            " \"" + vid[1] + "\"")
  call = shlex.split(call)
  dlLink = subprocess.Popen(call, stdout=subprocess.PIPE)
  dlLink.wait()
  dlLink = dlLink.stdout.read()
  call = ("mplayer -ni -forceidx -mc 0 -fs -cookies -cookies-file " + COOKIE_FILE + " " + dlLink)
  call = shlex.split(call)
  player = subprocess.Popen(call)
  player.wait()
  
def play_youtube(yid):
  import subprocess
  import shlex
  call = ("youtube-dl --max-quality '34'  -g --cookies " + COOKIE_FILE + 
            " \"" + yid + "\"")
  call = shlex.split(call)
  dlLink = subprocess.Popen(call, stdout=subprocess.PIPE)
  dlLink.wait()
  dlLink = dlLink.stdout.read()
  call = ("mplayer -ni -forceidx -mc 0 -fs -cookies -cookies-file " + COOKIE_FILE + " " + dlLink)
  call = shlex.split(call)
  player = subprocess.Popen(call)
  player.wait()

def kill(cancel=False):
  print "Killing downloader"
  try:
    pidfile = open(Q_PID, "rb")
    pid = pidfile.read()
    pidfile.close()
  except:
    print "Problem reading pid file, downloader probably not running"
    return
  import signal
  try:
    if cancel:
      os.kill(int(pid), signal.SIGUSR2)
    else:
      os.kill(int(pid), signal.SIGUSR1)
    print "Downloader has been killed"
  except:
    print "Wrong PID (" + pid + ") or downloader already dead"
  os.remove(Q_PID)

def reset(really):
  if really != "REALLY":
    print "You need to supply 'REALLY' as an argument"
    sys.exit(0)
  kill()
  import re
  print "Removing all ytcli temp files (incl. queue)"
  for f in os.listdir("/tmp/"):
    if re.search("ytcli_*", f):
      os.remove(os.path.join("/tmp/", f))

def resume():
    print "Starting the downloader"
    sys.stdout.flush()
    os.system("/usr/bin/python /opt/ytcli/ytcli_queue.py &")

def more():
  '''show results for the last search term used'''
  try:
    previous_term = config.get(D, 'term')
  except:
    print "No previous search found. Run a search using -f first."
    sys.exit(1)
  find(previous_term) 

def find(term):
  '''show the results for term starting including privious results'''
  d = {}
  try:
    previous_term = config.get(D, 'term')
    if previous_term != term:
      index = "1"
    else:
      index = config.get(D, 'index')
      d = load_retained_dict()
  except ConfigParser.NoOptionError:
    index = "1"
 
  params = {
    'q': term,
    'strict': 'true',
    'racy': 'include',
    'orderby': 'relevance',
    'max-results': '50',
    'start-index': index,
  }
  if options.authors:
    params['fields'] = 'entry(id,title,author)' #,media:group(media:content(@yt:format))'
  else:
    params['fields'] = 'entry(id,title)' #,media:group(media:content(@yt:format))'

  params = urlencode(params)
  feed = yt_service.GetYouTubeVideoFeed("http://gdata.youtube.com/feeds/api/videos?%s" % params ) 
  current_d = make_dict_from_feed(feed, index)
  d = dict(d.items() + current_d.items()) 
  retain_dict(d)
  index = str(int(index)+50)
  config.set(D, 'term', term)
  config.set(D, 'index', index)
  print_dict_elements(d)
  finish()

# decide and do
if options.find:
  find(options.find)
elif options.more:
  more()
elif options.queue:
  queue(options.queue)
elif options.status:
  status()
elif options.play:
  play(options.play)
elif options.playYoutube:
  play_youtube(options.playYoutube)
elif options.reset:
  reset(options.reset)
elif options.kill:
  kill()
elif options.remove is not None:
  remove(options.remove)
elif options.resume:
  resume()
else:
  print "Missing arguments. See ytcli -h for help on how to use ytcli"
  sys.exit(1)
