import gtk
import gtk.gdk
from gtk import gdk
import hildon
import time
import xml.dom.minidom,os
from xml.dom.minidom import Node
import math
import osmgpsmap
import gobject
from threading import Thread
from h_UI_helper import *


class LoadTrackDialog( hildon.Program):
    def __init__(self, zoom=0, lat=0, lon=0):
        hildon.Program.__init__(self)
        self.app = hildon.Program()
        self.window = hildon.Window()

    def startIt(self):
        dlg = gobject.new(hildon.FileChooserDialog, action=gtk.FILE_CHOOSER_ACTION_OPEN)
        #hildon.FileChooserDialog(self.window, gtk.FILE_CHOOSER_ACTION_OPEN)
        dlg.set_current_folder("/home/user/MyDocs/trasy/")
        response = dlg.run()
        if response == gtk.RESPONSE_OK:
            tr = dlg.get_filename()
        else:
            tr = ""
        dlg.destroy()
        return tr


class GpxLoad(Thread):

    lines = []
    points = []

    def __init__(self, pa, fileToLoad):
        Thread.__init__(self)
        self.lines = []
        self.points = []
        self.file = fileToLoad
        self.pa = pa
        
    def run(self):
        t = time.time()
        self.doc = xml.dom.minidom.parseString( open( self.file,"r").read() )
        print "gpi_tracks load parse in ", (time.time()-t)

        t = time.time()
        try:
            for trkseg in self.doc.getElementsByTagName("trkseg"):
                line = []
                for point in trkseg.getElementsByTagName("trkpt"):
                    lat = float(point.getAttribute("lat"))
                    lon = float(point.getAttribute("lon"))
                    line.append( [ lat, lon ] )


                self.lines.append(line)
        except:
            print "lines error"

        try:
            for p in self.doc.getElementsByTagName("wpt"):
                file_name = "./maps/%s" % p.getElementsByTagName("sym")[0].childNodes[0].data.replace("/", "_")
                ico_cmd = "wget \"%s\" -O \"%s\"" % (p.getElementsByTagName("sym")[0].childNodes[0].data, file_name )

                if not os.path.exists( file_name ):
                    os.system(ico_cmd)
                point = [
                        float(p.getAttribute("lat")),
                        float(p.getAttribute("lon")),
                        p.getElementsByTagName("name")[0].childNodes[0].data,
                        file_name,
                         ]
                #print "point",point
                self.points.append( point )
        except:
            print "points error"
        
        print "gpi_tracks load parse2 in ", (time.time()-t)
    
        self.pa.on_load_done(self.lines,self.points)
        

class SaveTrackDialog( hildon.Program):
    def __init__(self, zoom=0, lat=0, lon=0):
        hildon.Program.__init__(self)
        self.app = hildon.Program()
        self.window = hildon.Window()

    def startIt(self):
        dlg = gobject.new(hildon.FileChooserDialog, action=gtk.FILE_CHOOSER_ACTION_SAVE)
        #hildon.FileChooserDialog(self.window, gtk.FILE_CHOOSER_ACTION_SAVE)
        czas = time.strftime("%Y%m%d_%H%M.gpx", time.localtime() )
        #dlg.set_current_folder("/home/user/MyDocs")
        dlg.set_current_name(czas)
        response = dlg.run()
        if response == gtk.RESPONSE_OK:
            tr = dlg.get_filename()
        else:
            tr = ""
        dlg.destroy()
        return tr

class MyZoomSelect(hildon.Dialog):

    def act_download(self,widget):
        self.p.zoom_min = int(self.h_min.get_value())
        self.p.zoom_max = int(self.h_max.get_value())
        self.destroy()

    def __init__(self, p):
        self.p = p

        gtk.Dialog.__init__(self)
        self.set_title("Select zoom to download")
        self.set_size_request(640, 480)

        self.h_min = gtk.HScale()
        self.h_min.set_range(1,18)
        self.h_min.set_value(11)
        self.vbox.pack_start( self.h_min, True,True,0)

        self.h_max = gtk.HScale()
        self.h_max.set_range(1,18)
        self.h_max.set_value(16)
        self.vbox.pack_start( self.h_max, True,True,0)

        bt_download = hildon.Button(gtk.HILDON_SIZE_AUTO_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT,
                           hildon.BUTTON_ARRANGEMENT_VERTICAL,"Download")
        bt_download.connect("clicked", self.act_download)
        self.vbox.pack_start( bt_download, True, True, 0)

        self.show_all()




class gpx_tracks( h_UI_helper):

    def __init__(self,osmMapa,CONFIG):
        self.osmMapa = osmMapa
        self.CONFIG = CONFIG

        self.CONFIG['track_record'] = 0

        try:
            if self.CONFIG['gpssec']:
                pass
        except:
            self.CONFIG['gpssec'] = 10


        if self.CONFIG['track_record']:
            self.ico = "gpx_record.png"
        else:
            self.ico = "gpx.png"

        self.sec_range = [ 2, 5, 10, 20, 30, 60, 120]
        self.zoom_min = 10
        self.zoom_max = 16
        self.from_zoom = 10
        self.tracks_gpx = []
        self.points_gpx = []

        self.osm_tracks = []

        self.track_info_distans = 0.0

        print "__init__ gpx tracks"

    def clear_my_layer(self):
        for t in self.osm_tracks:
            self.osmMapa.osm.track_remove(t)
        self.osm_tracks = []        
        self.osmMapa.marker_layer_clean( self.get_name() )

    def killIt(self):
        self.clear_my_layer()

    def makeInit(self):
        self.clear_my_layer()
        if self.CONFIG['gpxtrack'] and self.CONFIG['gpxfile']:
            print "parse track start"
            try:
                g = GpxLoad( self, self.CONFIG['gpxfile'] )
                g.start()
            except:
                self.clear_my_layer()
                pass

    def on_clean(self,widget, dialog):
        self.clear_my_layer()

        self.tracks_gpx = []
        self.points_gpx = []
        self.osmMapa.my_gps_track = []
        self.track_info_distans = 0.0

        try:
            self.osmMapa.osm.gps_clear()
        except:
            pass

        self.CONFIG['gpxtrack'] = 0
        self.CONFIG['gpxfile'] = ""

        dialog.destroy()

    def on_load(self,widget, dialog):
        print "load track start"
        track = LoadTrackDialog()
        file = track.startIt()
        print "file to load", file
        if file <> "":
            self.CONFIG['gpxtrack'] = 1
            self.CONFIG['gpxfile'] = file
            print "parse track start"
            g = GpxLoad( self, file )
            g.start()
            print "parse track start DONE"
            

        track = None
        dialog.destroy()
        print "load track start DONE"

    def on_load_done(self, tracks, points):
        self.tracks_gpx = tracks
        self.points_gpx = points
        
        if self.bt_offline.get_active():
            print "zoom_select start"
            zoom_select = MyZoomSelect(self)
            zoom_select.run()
            print "zoom_select done"

        t = time.time()
        self.track_point_rebuild( self.zoom_min, self.zoom_max )
        print "gpi_tracks rebuild in ", (time.time()-t)


    def on_save(self,widget, dialog):
        print "on  save"
        d = SaveTrackDialog()
        file = d.startIt()
        if file<>"":
            print "store in ",file
            f = open( file, "w")
            f.write("""<?xml version="1.0"?>
<gpx creator="yosmapa" version="1.0">
<trk>
    <name>Line 1</name>
    <trkseg>
""")
            for p in self.osmMapa.my_gps_track:
                f.write("        <trkpt lat=\"%f\" lon=\"%f\"></trkpt>\n"%(p[0],p[1]))
            f.write("""    </trkseg>
</trk>
</gpx>"""         )
            f.close()

        dialog.destroy()
        print "on save DONE"

    def on_bt_track_click( self, w, dialog):
        state = w.get_active()
        self.CONFIG['track_record'] = state
        if state:
            self.ico = "gpx_record.png"
            dialog.destroy()
        else:
            self.ico = "gpx.png"
            self.on_save(None, dialog)



    def track_point_rebuild(self, zoom_min = 10, zoom_max = 16):
        self.clear_my_layer()
        # track & download
        ll0 = 0,0
        ll1 = 0,0
        self.track_info_distans = 0.0
        for track in self.tracks_gpx:
            last_point = [0.0, 0.0]
            t = osmgpsmap.GpsMapTrack()
            t.props.line_width = 6
            t.props.color = gtk.gdk.color_parse("#0f0aff")
            self.osm_tracks.append( t )
            for p in track:
                point = osmgpsmap.point_new_degrees(p[0],p[1])

                if last_point == [0.0, 0.0]:
                    last_point = p
                else:
                    self.track_info_distans+= self.osmMapa.distance( last_point[0],last_point[1], p[0], p[1] )
                    last_point = p

                t.add_point( point )

                if self.bt_offline.get_active():
                    if ll0 == [0,0]:
                        ll0 = p
                    else:
                        ll1 = p
                        print "download_map push ! zoom ", zoom_min, zoom_max
                        self.osmMapa.osm.download_maps(
                                               ll0[0],ll0[1],
                                               ll0[0],ll0[1],
                                               zoom_min,zoom_max
                                               )
                        ll0 = ll1
            self.osmMapa.osm.track_add( t )
        print "gpx_track track_point_rebuild: distans off track:",self.track_info_distans
        self.osmMapa.showBanner("Track length: %f km" % self.track_info_distans )
        # points
        for p in self.points_gpx:
            img = gdk.pixbuf_new_from_file( p[3] )
            #self.osm_images.append( self.osmMapa.osm.image_add( p[0],p[1], img) )
            self.osmMapa.marker_add([
                p[0],
                p[1],
                self.get_name(),
                p[2],
                img,
                None,
                self.from_zoom
                ])
        print "track_point_rebuild DONE"

    def on_changed_sec (self,picker):
        str = picker.get_value()
        print "select:",str
        self.CONFIG['gpssec'] = str


    def get_menu_widgets(self, dialog):
        hbox = gtk.HBox()

        pack = True



        vbox = gtk.VBox()
        self.bt_offline = hildon.CheckButton(gtk.HILDON_SIZE_AUTO| gtk.HILDON_SIZE_FINGER_HEIGHT)
        self.bt_offline.set_label("Work offline")
        vbox.pack_start(self.bt_offline, pack)

        vbox.pack_start(self.bt("Load track", self.on_load, dialog),pack)

        hbox.pack_start( vbox, pack)

        vbox1 = gtk.VBox()
        vbox1.pack_start(self.bt("Clear track",self.on_clean, dialog),False)
        vbox1.pack_start(gtk.Label(),False)
        hbox.pack_start(vbox1,True)
        

        vbox = gtk.VBox()

        bt_track = hildon.CheckButton(gtk.HILDON_SIZE_AUTO| gtk.HILDON_SIZE_FINGER_HEIGHT)
        bt_track.set_label("Rec. track")
        try:
            if self.CONFIG['track_record']:
                bt_track.set_active( self.CONFIG['track_record'] )
        except:
            pass
        bt_track.connect("clicked", self.on_bt_track_click, dialog)
        vbox.pack_start(bt_track, pack)


        pb_iter = hildon.PickerButton(gtk.HILDON_SIZE_AUTO| gtk.HILDON_SIZE_FINGER_HEIGHT,
                                        hildon.BUTTON_ARRANGEMENT_HORIZONTAL)
        pb_iter.set_title("Every sec")
        selector_sec = hildon.TouchSelectorEntry(text=True)
        sec_set_id = 0
        iter_nr = 0
        for sec in self.sec_range:
            if ("%s"%sec) == self.CONFIG['gpssec']:
                sec_set_id = iter_nr
            else:
                iter_nr+=1
            selector_sec.append_text("%s"%sec)
        pb_iter.set_selector(selector_sec)
        pb_iter.set_active(sec_set_id)
        pb_iter.connect("value-changed",self.on_changed_sec)
        vbox.pack_start( pb_iter, pack )


        if self.CONFIG['track_record']:
            self.osmMapa.osm.gps_clear()
            for p in self.osmMapa.my_gps_track:
                self.osmMapa.osm.gps_add( p[0],p[1] )
                self.osmMapa.osm.gps_add( p[0],p[1],osmgpsmap.INVALID )



        hbox.pack_start( vbox, pack)

        vbox = gtk.VBox()
        vbox.pack_start( hbox, pack)

        if self.track_info_distans > 0.0:
            l_info = gtk.Label( "Loaded track length:\t%i km\npoints:\t%i\ntracks:\t%i" %( self.track_info_distans, len(self.points_gpx), len(self.tracks_gpx) ) )
            l_info.set_justify( gtk.JUSTIFY_LEFT )
            vbox.pack_start( l_info )

        if self.CONFIG['track_record']:
            dist = 0.0
            ll_old = [0.0,0.0]
            for p in self.osmMapa.my_gps_track:
                if ll_old == [0.0, 0.0]:
                    ll_old = p
                else:
                    dist+= self.osmMapa.distance( ll_old[0],ll_old[1],p[0],p[1] )
                    ll_old = p
            l_info = gtk.Label( "Recording track length:\t%i km\nkey track points:\t%i" %(dist, len(self.osmMapa.my_gps_track) ) )
            l_info.set_justify( gtk.JUSTIFY_LEFT )
            vbox.pack_start( l_info )


        return vbox

    def get_name(self):
        return "gpx track"




    def do_draw(self, gpsmap, gdkdrawable):
        if self.osmMapa.osm.props.zoom>13:
            t_lt, t_ln, b_lt, b_ln = self.osmMapa.osm.get_bbox()
            t_lt, t_ln, b_lt, b_ln = math.degrees(t_lt), math.degrees(t_ln), math.degrees(b_lt), math.degrees(b_ln)


            lat = self.osmMapa.osm.props.latitude
            lon = self.osmMapa.osm.props.longitude
            cr = gdkdrawable.cairo_create()
            size = gdkdrawable.get_size()
            screen_center = [ size[0]/2, size[1]/2 ]
            screen_distance = self.osmMapa.cal_dist( lat,lon,t_lt,lon )*0.7

            min_dis = 0.0
            ll = [0.0, 0.0]
            make_short_cut = 1
            for track in self.tracks_gpx:
                for p in track:
                    dis = self.osmMapa.cal_dist( lat, lon, p[0],p[1] )
                    if dis > screen_distance:
                        if min_dis == 0.0:
                            min_dis = dis
                            ll = p
                        elif min_dis>dis:
                            min_dis = dis
                            ll = p
                    else:
                        make_short_cut = 0
                        break
                if not make_short_cut:
                    min_dis = 0.0
                    break

            if min_dis <> 0.0 and ll <> [0.0, 0.0]:
                self.osmMapa.draw_arrow( gdkdrawable, ll[0], ll[1], [0.0, 0.0, 1.0, 0.7], [1.0,0.0,0.0, 0.9] )


            """
            for p in self.points_gpx:
                lt = p[0]
                ln = p[1]
                if t_ln < ln and b_ln > ln and t_lt > lt and b_lt < lt:
                    x,y = self.osmMapa.osm.geographic_to_screen(lt,ln)
                    self.osmMapa.draw_cloud( cr, x,y, p[2])
            """

    def do_button_press(self, gpsmap, gdkeventbutton):
        pass