import gtk
import hildon
import gobject
import evolution

import base64

class SelectContact( hildon.StackableWindow ):
    def __init__(self, osmMapa = None, str_to_send = None, action_after_select = None, value = None):
        hildon.StackableWindow.__init__(self)

        self.osmMapa = osmMapa
        self.str_to_send = str_to_send

        self.ico_man = None
        self.action_after_select = action_after_select
        self.value = value
        self.action = ""


    def get_address_for(self, str):
        tr = []
        adr = evolution.ebook.open_addressbook('default')
        res = adr.search(str)
        for i in res:
            vcard = i.get_vcard_string()
            print "vcard[",vcard,"]"

            fn = i.get_property('full-name')
            tel = self.search_for_phone( i )
            address = self.search_for_address(i)
            if self.ico_man == None:
                self.ico_man = gtk.gdk.pixbuf_new_from_file("./imgs/ico_man_32_32.png")
            if address:
                print "--------------get_address_for[",str,"]"
                print "FN[%s]" %fn
                print "address[%s]" %address
                tr.append([
                           None,
                           None,
                           "Contact",
                           fn,
                           self.ico_man,
                           None,
                           6,
                           {
                                'address': address,
                                'geoname_status' : 0,
                                'tel' : tel.replace(" ","")

                                }
                           ])
        return tr

    def search_for_address(self, card):
        address = None
        vcard = card.get_vcard_string()
        adr_tmp = vcard.split("\n")        
        for l in adr_tmp:
            if l.find("ADR:") <> -1 or l.find("ADR;") <> -1 :
                l = l.replace("ADR:", "").replace("ADR;", "").replace("\\,", ",").replace("\r", "").replace(";;",";").replace("TYPE=HOME:","").replace("TYPE=WORK:","")
                return l
                break
        return address

    def search_for_phone(self, card):
        phone_attributes = [
                "assistant-phone",
                "business-phone",
                "business-phone-2",
                "business-fax",
                "callback-phone",
                "car-phone",
                "company-phone",
                "home-phone",
                "home-phone-2",
                "home-fax",
                "isdn-phone",
                "mobile-phone",
                "other-phone",
                "other-fax",
                "pager",
                "primary-phone",
                "radio",
                "telex",
                "tty",
            ]

        tr = ""
        for p in phone_attributes:
            phone = card.get_property(p)
            if phone:
                return phone



        return tr

    def start_dialog(self):
        vbox = gtk.VBox()
        self.add( vbox )
        self.set_title("Select contact")
        adr = evolution.ebook.open_addressbook('default')
        res = adr.get_all_contacts()



        c = []
        for i in res:
            name = i.get_property('full-name')
            uid = i.get_uid()
            tel = self.search_for_phone( i )
            if self.action_after_select == "add address":
                addr = self.search_for_address(i)
            else:
                addr = ""
            if name<>"":
                c.append( [name, tel, uid, addr] )
        #print c
        c.sort()


        selector = hildon.TouchSelector()
        store = gtk.ListStore(gobject.TYPE_STRING,gobject.TYPE_STRING, gobject.TYPE_STRING, gobject.TYPE_STRING)
        for i in c:
            new_iter = store.append()
            if self.action_after_select == "add address" and i[3] <> None:
                store.set_value( new_iter,0, "%s\n\t%s" % (i[0], i[3].replace(";", " ")))
            else:
                store.set_value( new_iter,0, i[0])
            store.set_value( new_iter,1, i[1])
            store.set_value( new_iter,2, i[2])
            store.set_value( new_iter,3, i[3])

        renderer = gtk.CellRendererText()
        renderer.set_fixed_size( 30, 100)

        column = selector.append_column( store, renderer, text = 0 )

        selector.set_column_selection_mode(hildon.TOUCH_SELECTOR_SELECTION_MODE_SINGLE)
        column.set_property("text-column", 0)
        selector.connect("changed", self.on_selected, store)



        vbox.pack_start(selector, True)
        self.show_all()

        #elf.loop = gobject.MainLoop()

    def add_new_concat(self,fn, tel,address,img_pixbuff):
        
        img = ""
        try:
            i = img_pixbuff
            i.save( "/tmp/.yosm_pix.png", "png" )
            f = open("/tmp/.yosm_pix.png","r")
            l = f.read()
            base_img = base64.encodestring(l)
            img = """PHOTO;TYPE=PNG;ENCODING=BASE64:
    """+base_img.replace("\n","\n\t")+"""

"""
        except:
            pass
        
        vcard = """BEGIN:VCARD
VERSION:3.0
FN:"""+fn+"""
TEL;TYPE=CELL:"""+tel.replace(" ","")+"""
NOTE:add by yosmapa
ADR:;"""+address.replace("  "," ")+""";;;;;
"""+img+"""END:VCARD"""
        print "---- vcard ---\n",vcard,"\n-----------vcard------"

        addresses = evolution.ebook.open_addressbook('default')
        c = evolution.ebook.EContact(vcard)
        addresses.add_contact(c)
        self.osmMapa.showBanner("Contact added.")

    def on_d_set_action(self,w,action,dialog):
        self.action = action
        dialog.destroy()

    def on_selected(self,w,a,b):
        print "on_selected"
        store, iter = w.get_selected(a)
        print b.get_value( iter, 1)
        
        if self.action_after_select == None:
            #self.loop.quit()
            telNr = b.get_value( iter, 1)
            print telNr," str to send ",self.str_to_send
            self.osmMapa.send_to_contact_step2( telNr, self.str_to_send )
            
        elif self.action_after_select == "add address":
            uid = b.get_value(iter, 2)
            address_now = b.get_value(iter, 3)
            print "add address to uid[%s]" % uid
            adr = evolution.ebook.open_addressbook('default')
            c = adr.get_contact( uid )
            vcard = c.get_vcard_string()
            self.action = "add"
            if address_now:
                self.action = ""
                d = hildon.Dialog()
                d.set_title("Contact have address!")
                
                l = gtk.Label()
                l.set_markup(("Current address: <b>%s</b>"%address_now.replace(";"," ")))
                d.vbox.pack_start(l,False)
                
                d.vbox.pack_start(gtk.Label("Options:"),False)
                
                bt_do_nothing = hildon.Button(gtk.HILDON_SIZE_AUTO_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT,
                               hildon.BUTTON_ARRANGEMENT_VERTICAL,"Do nothing")
                bt_do_nothing.connect("clicked", self.on_d_set_action, "", d)
                d.vbox.pack_start( bt_do_nothing, False )
                
                bt_replace = hildon.Button(gtk.HILDON_SIZE_AUTO_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT,
                               hildon.BUTTON_ARRANGEMENT_VERTICAL,"Replace")
                bt_replace.connect("clicked", self.on_d_set_action, "replace",d)
                d.vbox.pack_start( bt_replace, False )
                
                
                d.show_all()
                print "d pressent address query"            
                d.run()    
                d.destroy()
                print "d pressent address destroy"
                
            if self.action <> "":
                vtmp = vcard.split("\r\n")
                address_to_add = "ADR:;%s;;;;;" % self.value.replace("  "," ")
                nvcard = []
                for i,l in enumerate(vtmp):
                    if i == 2:
                        nvcard.append(address_to_add)
                    if self.action == "replace":
                        if l.find("ADR:") <> -1 or l.find("ADR;") <> -1 :
                            self.action == ""
                        else:
                            nvcard.append(l)
                    else:
                        nvcard.append(l) 
                new_vcard = "\r\n".join(nvcard)
                new_c = evolution.ebook.EContact(new_vcard)
                adr.remove_contact_by_id( uid )
                adr.add_contact( new_c )
                self.osmMapa.showBanner("Contact address updated.")
                
                print "------------- vcard update ----------\nold----------------"
                print vcard
                print "------------new \n"
                print new_vcard
                print "---------------------------------------------------------"
            self.destroy()
