import math

class math_helper:
    
    
    def distance( self,lat1, lon1, lat2 = None, lon2 = None):
        if lat2 == None and lon2 == None:
            lat2,lon2 = self.get_may_current_ll()
        try:
            theta = lon1 - lon2
            dist = math.sin(math.radians(lat1)) * math.sin(math.radians(lat2)) +  math.cos(math.radians(lat1)) * math.cos(math.radians(lat2)) * math.cos(math.radians(theta))
            dist = math.acos(dist)
            dist = math.degrees(dist)
            return dist * 111.18957696
        except:
            return 0
        
    def cal_angle(self, lat0, lon0, lat1 = None, lon1 = None):
        if lat1 == None and lon1 == None:
            lat1,lon1 = self.get_may_current_ll()

        deltax = lat1-lat0
        deltay = lon0-lon1
        M_PI = 3.14159265
        angle_rad = math.atan2(deltax,deltay)+M_PI

        return [ angle_rad, 0 ]


    def cal_dist(self, lat0, lon0, lat1 = None, lon1 = None):
        if lat1 == None and lon1 == None:
            lat1,lon1 = self.get_may_current_ll()
        return math.sqrt((lon0 - lon1)**2 + (lat0 - lat1)**2)
    
    
    def dist_from_vector(self, pa,pb,pc):
        tr = 0.0

        a = (pb[1]-pa[1])/(pb[0]-pa[0])
        c = pa[1]-( pa[0]*( a  ) )
        b = (((-a)*pa[0])-c)/pa[1]

        d = a*pc[0]+b*pc[1]+c
        if d < 0:
            d = -d
        tr = d/( math.sqrt( (a*a)+(b*b) ) )

        return tr

    def angle_from_vector(self, pa, pb, pc):
        a0 = self.cal_angle(pc[0],pc[1], pb[0],pb[1]  )
        a1 = self.cal_angle(pa[0],pa[1], pb[0],pb[1]  )
        res = a0[0]-a1[0]
        if res == 0.0:
            return 10.0

        if res < 0:
            res = -res
        res -= 3.14159265
        if res < 0:
            res = -res
        return res