import hildon
import gtk
import gobject
import os

from h_UI_helper import *

class MainMenuDialog( hildon.StackableWindow, h_UI_helper ):



    def __init__(self, osmMapa, config, maps_source, autorotate,FremantleRotation):

        hildon.StackableWindow.__init__(self)
        self.osmMapa = osmMapa
        self.CONFIG = config
        self.osmMapa.set_autorotate_for_object(self)
        self.maps_source = maps_source
        self.autorotate = autorotate
        self.FremantleRotation = FremantleRotation
        self.set_title("Menu")
        self.set_size_request(640, 480)

        pack = True

        mvbox = gtk.VBox()

        self.vbox = gtk.VBox()
        self.add(self.vbox)


        panel = hildon.PannableArea()
        panel.add_with_viewport(mvbox)
        self.vbox.pack_start(panel, pack)

        for plugin in self.osmMapa.plugins_list:
            plugin_name = plugin[1]

            ico = None
            w = None
            try:
                w = plugin[0].get_menu_widgets(self)
            except Exception, e:
                print "plugin -> get_menu_widgets error 1 ", e

            try:
                ico = plugin[0].ico
            except:
                pass

            if (self.CONFIG[plugin_name] and w <> None and ico == None):
                addIt = 1
            else:
                addIt = 0
            try:
                if plugin[0].ui_menu_main == 1 and self.CONFIG[plugin_name] and w <> None:
                    addIt = 1
            except:
                pass

            if addIt:
                try:
                    pvbox = gtk.VBox()
                    label = gtk.Label( plugin[1]+":" )
                    label2 = gtk.Label()
                    phbox = gtk.HBox()
                    phbox.pack_start( label, False)
                    phbox.pack_start( label2, True)
                    pvbox.pack_start( phbox, True )
                    if ico:
                        hbox = gtk.HBox()
                        i = gtk.Image()
                        i.set_from_file( "./plugins/%s" % ico )
                        hbox.pack_start( i, False )
                        hbox.pack_start(w,pack)
                        pvbox.pack_start(hbox, False)
                    else:
                        pvbox.pack_start(w,pack)

                    mvbox.pack_start( pvbox, pack)

                except ValueError:
                    print "plugin -> get_menu_widgets error 2", ValueError


        

        hs = gtk.HSeparator()
        mvbox.pack_start( hs, pack )






        hbox = gtk.HBox()



        if self.autorotate:
            bt_rotate = hildon.CheckButton(gtk.HILDON_SIZE_AUTO)
            bt_rotate.set_label("rotate screen")
            try:
                if self.CONFIG['autorotate']:
                    bt_rotate.set_active( self.CONFIG['autorotate'] )
            except:
                pass
            bt_rotate.connect("clicked", self.on_bt_rotate_click)
            hbox.pack_start(bt_rotate, pack)

        hbox.pack_start(self.bt("(un)fullscreen", self.on_bt_full, self), pack)

        mvbox.pack_start( hbox, False )


        hbox = gtk.HBox()
        
        hbox.pack_start(self.bt("Donate", self.on_bt_donate), True)
        hbox.pack_start(self.bt("About", self.on_bt_about), True)

        bt_show = hildon.CheckButton(gtk.HILDON_SIZE_AUTO)
        bt_show.set_label("welcome screen")
        try:
            if self.CONFIG['welcome_screen']:
                bt_show.set_active( self.CONFIG['welcome_screen'] )
        except:
            self.CONFIG['welcome_screen'] = 1
            bt_show.set_active( self.CONFIG['welcome_screen'] )
            pass
        bt_show.connect("clicked", self.on_bt_show)
        hbox.pack_start(bt_show, True)

        mvbox.pack_start(hbox,False)


        hbox = gtk.HBox()

        pb_map_src = hildon.PickerButton(gtk.HILDON_SIZE_AUTO,
                                        hildon.BUTTON_ARRANGEMENT_HORIZONTAL)
        pb_map_src.set_title("Map source")
        selector_map = hildon.TouchSelectorEntry(text=True)
        map_set_id = 0
        iter_nr = 0
        for map_name in self.maps_source:
            if map_name[0] == self.CONFIG['engine_name']:
                map_set_id = iter_nr
            else:
                iter_nr+=1
            selector_map.append_text(map_name[1])
        pb_map_src.set_selector(selector_map)
        pb_map_src.set_active(map_set_id)
        pb_map_src.connect("value-changed",self.on_changed_map)
        hbox.pack_start( pb_map_src, False )

        # plugins menagment
        pb_plugs = hildon.PickerButton(gtk.HILDON_SIZE_AUTO_WIDTH,
                                        hildon.BUTTON_ARRANGEMENT_HORIZONTAL)
        pb_plugs.set_title("Plugins")
        sel_plugs = self.create_customized_selector_of_plugs()
        pb_plugs.set_selector( sel_plugs )
        pb_plugs.connect("value-changed", self.selection_plugs, sel_plugs)
        hbox.pack_start( pb_plugs, False )
        
        self.vbox.pack_start( hbox, False )
        # plugins menagment

        # test
        if 0:
            pass
        # test
        self.show_all()


    def on_bt_show(self,w):
        self.CONFIG['welcome_screen'] = w.get_active()

    def on_close(self,widget=None):
        self.destroy()


    def on_map_source(self, widget, map_source):
        #def load_map_clicked(self, button=None, uri=None, format=None)
        self.CONFIG['engine_name'] = map_source

        self.osmMapa.load_map_clicked()

        self.on_close()

    def on_changed_map (self,picker):
        str = picker.get_value()
        id = -1
        iter = 0
        for map_name in self.maps_source:
            if map_name[1] == str:
                id = iter
                break
            else:
                iter+=1


        if type( self.CONFIG['engine_name'] ) == int and type( self.maps_source[id][0] ) == int:
            print "selected source map: ", self.maps_source[id]," using fash switch"
            self.CONFIG['engine_name'] = self.maps_source[id][0]
            self.osmMapa.osm.props.map_source = self.maps_source[id][0]

        else:
            print "selected source map: ", self.maps_source[id]," using long switch"
            self.CONFIG['engine_name'] = self.maps_source[id][0]
            self.osmMapa.load_map_clicked()

        self.on_close()

    def on_bt_rotate_click( self, w):
        state = w.get_active()
        self.CONFIG['autorotate'] = state
        if state:
            self.osmMapa.window_rotate.set_mode( self.FremantleRotation.AUTOMATIC )
        else:
            self.osmMapa.window_rotate.set_mode( self.FremantleRotation.NEVER )


    def on_bt_full(self, w, dialog):
        dialog.destroy()
        self.osmMapa.fullscreen_toggle()
    def on_bt_donate(self,w):
        os.system("dbus-send --system --type=method_call --dest=\"com.nokia.osso_browser\" --print-reply /com/nokia/osso_browser/request com.nokia.osso_browser.load_url string:\"yoyo.ghost.pl/yosmapa/\"")
    def on_bt_about(self,w):
        d = hildon.Dialog()
        d.set_title("About")
        d.set_size_request(640, 480)

        mvbox = gtk.VBox()
        panel = hildon.PannableArea()
        panel.add_with_viewport(mvbox)

        label = gtk.Label("""Plugin oriented navigation application based on Open Street Map.

App version: """+self.osmMapa.get_version()+"""
Autor: Bartlomiej Ceglik <yoyoek[noSpam]wp.pl>""")
        mvbox.pack_start(label,True)

        hbox = gtk.HBox()
        img = gtk.Image()
        img.set_from_file("./imgs/ico_arrow_d_64_64.png")
        hbox.pack_start(img,False)
        hbox.pack_start(panel,True)
        d.vbox.pack_start(hbox, True)
        d.show_all()
        d.run()
        d.destroy()


    def create_customized_selector_of_plugs(self):
        selector = hildon.TouchSelector( text = True)
        selector.set_column_selection_mode(hildon.TOUCH_SELECTOR_SELECTION_MODE_MULTIPLE)

        iter = 0
        for plugin in self.osmMapa.plugins_list:
            name = plugin[1]
            selector.append_text( name )
            if self.CONFIG[name]:
                selector.select_iter(0, selector.get_model(0).get_iter(iter), False)
            else:
                selector.unselect_iter(0, selector.get_model(0).get_iter(iter))
            iter+=1
        return selector

    def selection_plugs(self,selector,a):

        s = a.get_current_text().replace("(","").replace(")","")
        p = s.split(",")

        active_list = []
        deactive_list = []

        for plugin in self.osmMapa.plugins_list:
            pn = plugin[1]
            deactive = 1
            for n in p:
                if n == pn:
                    if not self.CONFIG[pn]:
                        active_list.append(pn)

                    self.CONFIG[pn] = 1
                    deactive = 0
                    break
            if deactive:
                if self.CONFIG[pn]:
                   deactive_list.append(pn)
                self.CONFIG[pn] = 0


        for a in active_list:
            for plugin in self.osmMapa.plugins_list:
                pn = plugin[1]
                if pn == a:
                    try:
                        plugin[0].makeInit()
                        print "plugin state to active makeInit ",pn
                    except Exception, e:
                        print "plugin state to active makeInit ERROR",pn,e

                    break
        print "plugins killIt:",deactive_list

        self.osmMapa.do_draw_plugins = []
        self.osmMapa.do_button_release_plugins = []

        for a in deactive_list:
            for plugin in self.osmMapa.plugins_list:
                pn = plugin[1]
                if pn == a:
                    try:
                        plugin[0].killIt()
                        print "plugin state to active killIt ",pn
                    except Exception, e:
                        print "plugin state to active killIt ERROR",pn,e
                    break
        self.osmMapa.set_plugins_searchable()

        dialog = MainMenuDialog(self.osmMapa, self.CONFIG, self.maps_source, self.autorotate, self.FremantleRotation)
        self.destroy()
