import gtk
import gtk.gdk
from gtk import gdk
import hildon
import time
import xml.dom.minidom,os
from xml.dom.minidom import Node
import osmgpsmap
import math
import cairo


class POI:

    def __init__(self,osmMapa,CONFIG):
        self.CONFIG = CONFIG


        self.osmMapa = osmMapa
        self.CONFIG = CONFIG
        self.file = "/home/user/yosmapaPOI.xml"
        self.ico_poi = gdk.pixbuf_new_from_file("./plugins/POI.png")
        self.poi = []
        self.poi_images = []


        self.ico = "POI.png"
        self.ui_menu_main = 0
        self.ui_menu_left = 1
        self.ui_search = 1
        self.from_zoom = 7


        print "__init__ POI"


    def on_bt_add(self, w, dlg,dialog):
        id = time.strftime("%Y%m%d%H%M%S", time.localtime() )
        lat = float(self.osmMapa.osm.props.latitude)
        lon = float(self.osmMapa.osm.props.longitude)
        self.poi.append([int(id),
                         self.e_name.get_text(),
                         lat,
                         lon
                        ])
        self.osmMapa.marker_add([
                        float(lat),
                        float(lon),
                        self.get_name(),
                        self.e_name.get_text(),
                        self.ico_poi,
                        None,
                        self.from_zoom
                        ])
        self.saveXml()
        dlg.destroy()
        dialog.destroy()

    def on_add(self, w, dialog):
        dlg = gtk.Dialog("Add POI")

        self.e_name = gtk.Entry()
        dlg.vbox.pack_start(self.e_name, True)

        bt_add = hildon.Button(gtk.HILDON_SIZE_AUTO_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT,
                           hildon.BUTTON_ARRANGEMENT_VERTICAL,"Add")
        bt_add.connect("clicked", self.on_bt_add, dlg, dialog)
        dlg.vbox.pack_start(bt_add, True)

        dlg.show_all()

    def saveXml(self):
        f = open( self.file, "w")
        f.write("""<?xml version="1.0"?>
<points creator="yosmapa" version="1.0">
""")
        for p in self.poi:
            str = "    <poi lat=\"%f\" lon=\"%f\" id=\"%s\" name=\"%s\" />\n" % (float(p[2]),float(p[3]),p[0],p[1])
            f.write( str )
        f.write("""</points>"""         )
        f.close()



    def killIt(self):
        self.osmMapa.marker_layer_clean( self.get_name() )

    def makeInit(self):
        try:
            self.doc = xml.dom.minidom.parse(self.file)
            self.poi = []
            for p in self.doc.getElementsByTagName("poi"):
                
                self.osmMapa.marker_add([
                    float(p.getAttribute("lat")),
                    float(p.getAttribute("lon")),
                    self.get_name(),
                    p.getAttribute("name"),
                    self.ico_poi,
                    None,
                    self.from_zoom
                    ])
                
                self.poi.append( [
                    p.getAttribute("id"),
                    p.getAttribute("name"),
                    float(p.getAttribute("lat")),
                    float(p.getAttribute("lon"))
                                ])
            print "POI read poi xml found (",len(self.poi),") POI :)"
        except:
            print "POI read poi xml file error create clean one"
            self.saveXml()


    def on_bt_delete_poi(self,w,id, dialog):
        print "delete poi id:",id
        pNew = []
        for p in self.poi:
            if p[0] <> id:
                pNew.append(p)
        self.poi = []
        self.poi = pNew
        self.saveXml()
        self.poi = []
        self.osmMapa.marker_layer_clean(self.get_name())
        self.makeInit()        
        self.on_bt_edit(None)
        dialog.destroy()

    def on_bt_edit(self, w):
        d = hildon.Dialog()
        d.set_title("POI edit")

        mvbox = gtk.VBox()
        panel = hildon.PannableArea()
        panel.add_with_viewport(mvbox)
        d.vbox.pack_start( panel, True,True)
        panel.set_size_request(640, 280)

        for p in self.poi:
            hbox = gtk.HBox()
            l = gtk.Label(p[1])
            hbox.pack_start(l,False)
            l = gtk.Label("")
            hbox.pack_start(l,True)
            bt = hildon.Button(gtk.HILDON_SIZE_AUTO_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT,
                           hildon.BUTTON_ARRANGEMENT_VERTICAL,"del")
            bt.connect( "clicked", self.on_bt_delete_poi, p[0], d )
            hbox.pack_start(bt,False)
            mvbox.pack_start(hbox,False)

        d.show_all()
        d.run()
        d.destroy()

    def search_query(self, str):
        tr = []
        for p in self.poi:
            if p[1].find(str) <> -1:
                tr.append([
                    p[2],
                    p[3],
                    self.get_name(),
                    p[1],
                    self.ico_poi,
                    None,
                    self.from_zoom
                           ])
        return tr

    def get_menu_widgets(self, dialog):
        hbox = gtk.HBox()

        bt_add = hildon.Button(gtk.HILDON_SIZE_AUTO_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT,
                           hildon.BUTTON_ARRANGEMENT_VERTICAL,"Add")
        bt_add.connect("clicked", self.on_add, dialog)
        hbox.pack_start( bt_add, True)

        bt_edit = hildon.Button(gtk.HILDON_SIZE_AUTO_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT,
                           hildon.BUTTON_ARRANGEMENT_VERTICAL,"Actions(%i)"%len(self.poi))
        bt_edit.connect("clicked", self.on_bt_edit )
        hbox.pack_start( bt_edit, False)

        return hbox

    def get_name(self):
        return "POI"
    def do_button_press(self, gpsmap, gdkeventbutton):
        return False

