import gtk
import gtk.gdk
from gtk import gdk
import xml.dom.minidom,os
from xml.dom.minidom import Node
import httplib
import osmgpsmap
import gobject
import math
import cairo
import hildon

from threading import Thread

class geonamesDownloader(Thread):
    def __init__(self,geonames,str=""):
        Thread.__init__(self)
        self.geonames = geonames
        self.str = str



    def parseXml(self, xml_res):
        doc = xml.dom.minidom.parseString(xml_res)
        #t_lt, t_ln, b_lt, b_ln = self.geonames.osmMapa.osm.get_bbox()
        #t_lt, t_ln, b_lt, b_ln = math.degrees(t_lt), math.degrees(t_ln), math.degrees(b_lt), math.degrees(b_ln)
        try:
            self.tp = self.str
            box = doc.getElementsByTagName("location")[0]
            name = doc.getElementsByTagName("formatted_address")[0].childNodes[0].data
            lt = float(box.getElementsByTagName("lat")[0].childNodes[0].data)
            ln = float(box.getElementsByTagName("lng")[0].childNodes[0].data)
            #self.geonames.osmMapa.osm.set_center( lat, lon)
            #if t_ln < ln and b_ln > ln and t_lt > lt and b_lt < lt:
            if 1:
                self.geonames.poi.append( [
                    lt,
                    ln,
                    self.geonames.get_name(),
                    name,
                    self.geonames.ico_geo,
                    None,
                    1
                    ])
        except Exception, e:
            print "geonamesDownloader.parseXml Error",e
            #self.geonames.osmMapa.showBanner(("no results for:%s" % self.str))



    def downloadXml(self):
        conn = httplib.HTTPConnection("maps.googleapis.com")
        req = "/maps/api/geocode/xml?address=%s&sensor=true" % (self.str.replace(" ", "%20"))
        print req
        conn.request("GET", req)
        r = conn.getresponse()
        return r.read()


    def run(self):
        print "geonames downolad"
        res = self.downloadXml()
        print "geonames parse"
        self.parseXml( res )
        print "geonames downolad res(",len(self.geonames.poi),")"
        if len(self.geonames.poi) == 1:
            self.geonames.osmMapa.show_find_results.append( self.geonames.poi[0] )
            #self.geonames.osmMapa.recalculate_center_and_zoom()
            print "geonames add marker"
        print "goanames DONE"
        self.geonames.ui_thread = 2



class google_geonames:

    def __init__(self,osmMapa,CONFIG):
        self.CONFIG = CONFIG
        self.osmMapa = osmMapa

        self.ico = "google_maps.png"

        self.ui_menu_main = 0
        self.ui_menu_left = 0
        self.ui_search = 1
        self.ui_thread = 1

        self.timeout = 3
        self.draw = 0
        self.ll = 0,0
        self.poi = []

        self.ico_geo = gdk.pixbuf_new_from_file("./maps/ico_igla_32_32.png")

        try:
            print "google_geonames last search:", self.CONFIG['google_geonames_search']
        except:
            self.CONFIG['google_geonames_search'] = ""

        try:
            print "google_geonames download state:", self.CONFIG['google_geonames_download']
        except:
            self.CONFIG['google_geonames_download'] = 0

        print "__init__ google geonames"

    def makeInit(self):
        return None

    def search_query(self, str):
        # TODO
        self.ui_thread = 1
        self.poi = []
        self.CONFIG['google_geonames_search'] = str
        t = geonamesDownloader( self, self.CONFIG['google_geonames_search'])
        t.start()
        return []

    def get_name(self):
        return "Google - geonames"

    def get_menu_widgets(self, dialog):
        return None
    def do_button_press(self, gpsmap, gdkeventbutton):
        pass