import gtk
import gtk.gdk
from gtk import gdk
import xml.dom.minidom,os
from xml.dom.minidom import Node
import httplib
import osmgpsmap
import gobject
import math
import cairo
import hildon

from threading import Thread


class geonamesDownloader(Thread):
    def __init__(self,geonames,str="", lat=None, lon=None, return_to_ref_result = False):
        Thread.__init__(self)
        self.geonames = geonames
        self.str = str
        self.ll = [lat,lon]
        self.return_to_ref_result = return_to_ref_result

        self.geonames.ref_result = []

        print "geonamesDownloader __init__ "
        print "\tgeonames downolad \n\tstr[",self.str,"] \n\tlat[",self.ll[0],"] \n\tlon[",self.ll[1],"] \n\treturn[",self.return_to_ref_result,"]"


    def parseXml(self, xml_res):
        #print "--------------------\n",xml_res,"\n----------------------------"
        doc = xml.dom.minidom.parseString(xml_res)
        #t_lt, t_ln, b_lt, b_ln = self.geonames.osmMapa.osm.get_bbox()
        #t_lt, t_ln, b_lt, b_ln = math.degrees(t_lt), math.degrees(t_ln), math.degrees(b_lt), math.degrees(b_ln)
        if self.ll <> [None,None]:
            try:
                address = doc.getElementsByTagName("formatted_address")[0].childNodes[0].data
                print "geoname found address: [",address,"]"
                self.geonames.ref_result = ["-",
                                address,
                                "-"
                                ]
            except:
                self.geonames.ref_result.append(0)
        else:
            try:
                self.tp = self.str
                #box = doc.getElementsByTagName("location")[0]
                name = doc.getElementsByTagName("formatted_address")[0].childNodes[0].data
                lt = float(doc.getElementsByTagName("lat")[0].childNodes[0].data)
                ln = float(doc.getElementsByTagName("lng")[0].childNodes[0].data)
                #self.geonames.osmMapa.osm.set_center( lat, lon)
                #if t_ln < ln and b_ln > ln and t_lt > lt and b_lt < lt:
                if self.return_to_ref_result == False:
                    self.geonames.poi.append( [
                        lt,
                        ln,
                        self.geonames.get_name(),
                        name,
                        self.geonames.ico_geo,
                        None,
                        1
                        ])
                else:
                    self.geonames.ref_result = [
                        lt,
                        ln,
                        self.geonames.get_name(),
                        name,
                        self.geonames.ico_geo,
                        None,
                        1
                        ]

            except Exception, e:
                print "geonamesDownloader.parseXml Error []",e
                print "ERROR geonames downolad \n\tstr[",self.str,"] \n\tlat[",self.ll[0],"] \n\tlon[",self.ll[1],"] \n\treturn[",self.return_to_ref_result,"]"
                if self.return_to_ref_result == True:
                    self.geonames.ref_result = [0]
                #self.geonames.osmMapa.showBanner(("no results for:%s" % self.str))



    def downloadXml(self):
        conn = httplib.HTTPConnection("maps.googleapis.com")
        if self.ll <> [None,None]:
            req = "/maps/api/geocode/xml?latlng=%f,%f&sensor=true" % (self.ll[0],self.ll[1])
        else:
            req = "/maps/api/geocode/xml?address=%s&sensor=true" % (self.str.replace(" ", "%20"))

        print req
        conn.request("GET", req)
        r = conn.getresponse()
        return r.read()


    def run(self):
        res = self.downloadXml()
        print "geonames parse"
        self.parseXml( res )
        if self.ll == [None,None] and self.return_to_ref_result == False:
            print "geonames downolad res(",len(self.geonames.poi),")"
            if len(self.geonames.poi) == 1:
                self.geonames.osmMapa.show_find_results.append( self.geonames.poi[0] )
                #self.geonames.osmMapa.recalculate_center_and_zoom()
                print "geonames add marker"
            print "goanames DONE"
            self.geonames.ui_thread = 2



class google_geonames:

    def __init__(self,osmMapa,CONFIG):
        self.CONFIG = CONFIG
        self.osmMapa = osmMapa

        self.ico = "google_maps.png"

        self.ui_menu_main = 0
        self.ui_menu_left = 0
        self.ui_search = 1
        self.ui_thread = 1

        self.timeout = 3
        self.draw = 0
        self.ll = 0,0
        self.poi = []


        self.ref_result = []

        self.ico_geo = gdk.pixbuf_new_from_file("./maps/ico_igla_32_32.png")

        try:
            print "google_geonames last search:", self.CONFIG['google_geonames_search']
        except:
            self.CONFIG['google_geonames_search'] = ""

        try:
            print "google_geonames download state:", self.CONFIG['google_geonames_download']
        except:
            self.CONFIG['google_geonames_download'] = 0

        print "__init__ google geonames"

    def makeClone(self,osmMapa, config):
        return google_geonames( osmMapa, config )
    def makeInit(self):
        return None

    def ref_download_by_str(self,str):
        self.ref_result = []
        print "google_geonames -> ref_download_by_str [",str,"]"
        t = geonamesDownloader( self, str, None,None,True)
        t.start()

    def ref_dawnload(self,lat,lon):
        self.ref_result = []
        t = geonamesDownloader( self, None, lat,lon)
        t.start()

    def search_query(self, str):
        # TODO
        self.ui_thread = 1
        self.poi = []
        self.CONFIG['google_geonames_search'] = str
        t = geonamesDownloader( self, self.CONFIG['google_geonames_search'])
        t.start()
        return []

    def get_name(self):
        return "Google - geonames"

    def get_menu_widgets(self, dialog):
        return None
    def do_button_press(self, gpsmap, gdkeventbutton):
        pass