import pickle
import os

from h_deb import *

name = "yosmapa"

try:
    from win32com.shell import shellcon, shell
    home = ("%s\\.%s_%s.conf" % (shell.SHGetFolderPath(0, shellcon.CSIDL_APPDATA, 0, 0), name,"0.18") )
except ImportError: # quick semi-nasty fallback for non-windows/win32com case
    home =  ("%s/.%s_%s.conf"% (os.path.expanduser("~"), name,"0.18") )

def config_save( CONFIG ):
    global home
    deb( "config - saveing" )
    ts = []
    for b in CONFIG:
        ts.append([b, CONFIG[b]])

    f = open(home,"w")
    pickle.dump( ts, f )
    f.close()
    print "done"

def config_load( CONFIG ):
    global home

    try:
        if os.path.exists(home):
            deb( "config - loading ..." )
            f = open(home,"r")
            tp = pickle.load(f)
            f.close()
            for b in tp:
                CONFIG[b[0]] = b[1]

            print "done"
        else:
            print "config - config file not found :/"
            config_save( CONFIG )
    except:
        deb("config - found that file is broken :/ restoring")
        os.system("dbus-send --print-reply --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteDialog string:'Config file is broken :( Restoring settings to default.' uint32:0 string:'NAO OK!'")
        config_save( CONFIG )
        config_load( CONFIG )
