import time
from threading import Thread
import gobject

class GpsManager(Thread):
    def __init__(self, osmMapa, config, location):
        Thread.__init__(self)
        self.osmMapa = osmMapa
        self.CONFIG = config
        self.location = location

        self.lat = 0.0
        self.lon = 0.0
        self.heading = 0.0
        self.accuracy = 0.0
        self.last_iter_time = self.get_time()

        self.acc_scale = {
                          18: 70,
                          17: 100,
                          16: 200,
                          15: 500,
                          14: 1000,
                          13: 2000,
                          12: 4000,
                          11: 9000,
                          10: 10000,
                          9:  30000,
                          8:  70000,
                          7:  100000,
                          6:  200000,
                          5:  500000,
                          4:  1000000,
                          3:  2000000,
                          2:  4000000
                          }
    def get_time(self):
        return int(time.strftime("%Y%m%d%H%M%S", time.localtime() ))

    def on_error(self, control, error, data):
        print "location error: %d... quitting" % error
        data.quit()

    def on_changed(self,device, data):
        if not device:
            return
        if device.fix:
            if device.fix[1] & self.location.GPS_DEVICE_LATLONG_SET:
                self.lat, self.lon, self.heading, self.accuracy = device.fix[4], device.fix[5], device.fix[9], (device.fix[6]/100)
                #print "lat = %f, long = %f" % (lat,lon)


                if self.CONFIG['track_record'] == 0:
                    try:
                        self.osmMapa.osm.gps_clear()
                    except:
                        pass
                else:
                    #print "accuracy:[",self.accuracy,"]"
                    if self.accuracy<500:
                        t = self.get_time()
                        if (t-self.last_iter_time)>int( self.CONFIG['gpssec'] ):
                            #print "add to track"
                            self.last_iter_time = t
                            self.osmMapa.my_gps_track.append([self.lat,self.lon])


                if self.CONFIG['work_work_work']:
                    self.osmMapa.osm.gps_add( self.lat, self.lon, self.heading)
                    if self.osmMapa.get_gpslock() == 1:
                       self.osmMapa.osm.set_center( self.lat, self.lon )
                       self.CONFIG['lat'], self.CONFIG['lon'] = self.lat, self.lon
                # data.stop() commented out to allow continuous loop for a reliable fix - press ctrl c to break the loop, or program your own way of exiting)


    def on_stop(self,control, data):
        print "quitting"
        data.quit()
        print "data quit"
        self.loop.quit()
        print "data quit 1"
        return False
    def start_location(self,data):
        data.start()
        return False

    def join(self):
        print "in join"
        self.loop.quit()
        print "in join 1"
        return False
    def run(self):

        self.loop = gobject.MainLoop()
        self.control = self.location.GPSDControl.get_default()
        device = self.location.GPSDevice()
        self.control.set_properties(preferred_method=self.location.METHOD_USER_SELECTED,
                               preferred_interval=self.location.INTERVAL_DEFAULT)

        self.control.connect("error-verbose", self.on_error, self.loop)
        device.connect("changed", self.on_changed, self.control)
        self.control.connect("gpsd-stopped", self.on_stop, self.loop)

        gobject.idle_add(self.start_location, self.control)

        self.loop.run()

