import gtk
import gtk.gdk
from gtk import gdk
import hildon
import time
import xml.dom.minidom,os
from xml.dom.minidom import Node
import math
import osmgpsmap
import gobject


class results_view:

    def __init__(self,osmMapa,CONFIG):
        self.osmMapa = osmMapa
        self.CONFIG = CONFIG

        self.ico = "ico_profile_32_32.png"
        self.ui_menu_main = 0
        self.ui_menu_left = 1
        self.ui_stackable = 1
        self.ui_search = 0


        self.scroll_at = [0,0]

        print "__init__ results_view"

    def killIt(self):
        return None

    def makeInit(self):
        return None

    def get_label(self, str):
        hbox = gtk.HBox( spacing = 5 )
        l0 = gtk.Label()
        l0.set_line_wrap( True )
        l0.set_markup( str )
        hbox.pack_start( l0, False)

        l1 = gtk.Label()
        hbox.pack_start( l1, True)
        return hbox

    def get_menu_widgets(self, dialog):
        vbox = gtk.VBox()

        if len(self.osmMapa.show_find_results)>0:
            make_from = self.osmMapa.show_find_results
        else:
            make_from = self.osmMapa.markers


        t = []
        for m in make_from:
            if m[3]:
                dis = self.osmMapa.distance( m[0], m[1])
                t.append( [dis,m] )
        t.sort()

        make_from = []
        for m in t:
            make_from.append( m[1] )


        mvbox = gtk.VBox()
        self.panel = hildon.PannableArea()
        self.panel.add_with_viewport(mvbox)
        vbox.pack_start( self.panel, True)

        store = gtk.ListStore( str, str, str,str )
        for m in make_from:
            #print m
            if m[3]:
                osm = osmgpsmap.GpsMap()
                osm.set_center_and_zoom( m[0], m[1], 16 )
                osm.set_size_request(140, 140)
                osm.image_add( m[0], m[1], m[4] )
                osm.connect('button_release_event', self.on_map_clicked, m[0], m[1],dialog)
                osm.connect('button_press_event', self.on_map_clicked, m[0], m[1],dialog)

                dbox = gtk.VBox()
                l = self.get_label("<b>%s</b>"%m[3])
                dbox.pack_start( l, False)
                dis = self.osmMapa.distance_to_string( self.osmMapa.distance( m[0], m[1]) )
                info = "<small><u>%s</u>\t\t<i>%s</i></small>"% (dis, m[2])
                l1 = self.get_label( info )
                dbox.pack_start( l1, False)

                ibox = gtk.HBox(spacing=5)
                ibox.pack_start( osm, False)
                ibox.pack_start( dbox, False)

                ebox = gtk.EventBox()
                ebox.add( ibox )
                ebox.connect("button-press-event", self.on_ebox_click)
                ebox.connect("button-release-event", self.on_ebox_release_click, m,dialog)

                mvbox.pack_start( gtk.HSeparator(), False)
                mvbox.pack_start( ebox, False)



        mvbox.show_all()

        return vbox
    def on_ebox_click(self,w,a):
        self.scroll_at = [ self.panel.get_vadjustment().get_value(), self.panel.get_hadjustment().get_value() ]

    def on_ebox_release_click(self,w,a,point,dialog):
        print "re ebox"
        scroll_tmp = [ self.panel.get_vadjustment().get_value(), self.panel.get_hadjustment().get_value() ]
        if self.scroll_at == scroll_tmp:
            dialog.destroy()
            self.osmMapa.build_details( point )

    def on_map_clicked(self,osm,event, lat, lon,dialog):
        dialog.destroy()
        self.osmMapa.set_gpslock(False)
        self.osmMapa.osm.set_center_and_zoom( lat, lon, 16 )

    def get_name(self):
        return "Results view"

    def do_button_press(self, gpsmap, gdkeventbutton):
        pass