import gtk
import hildon
import gobject
import evolution

class SelectContact( hildon.StackableWindow ):
    def __init__(self, osmMapa, str_to_send):
        hildon.StackableWindow.__init__(self)

        self.osmMapa = osmMapa
        self.str_to_send = str_to_send
        vbox = gtk.VBox()
        self.add( vbox )



        adr = evolution.ebook.open_addressbook('default')
        res = adr.get_all_contacts()

        phone_attributes = [
                "assistant-phone",
                "business-phone",
                "business-phone-2",
                "business-fax",
                "callback-phone",
                "car-phone",
                "company-phone",
                "home-phone",
                "home-phone-2",
                "home-fax",
                "isdn-phone",
                "mobile-phone",
                "other-phone",
                "other-fax",
                "pager",
                "primary-phone",
                "radio",
                "telex",
                "tty",
            ]

        c = []
        for i in res:
            name = i.get_property('full-name')
            tel = ""
            for p in phone_attributes:
                phone = i.get_property(p)
                if phone:
                    tel = phone
                    break

            c.append( [name, tel] )
        print c



        selector = hildon.TouchSelector()
        store = gtk.ListStore(gobject.TYPE_STRING,gobject.TYPE_STRING)
        for i in c:
            new_iter = store.append()
            store.set_value( new_iter,0, i[0])
            store.set_value( new_iter,1, i[1])

        renderer = gtk.CellRendererText()
        renderer.set_fixed_size( 30, 100)

        column = selector.append_column( store, renderer, text = 0 )

        selector.set_column_selection_mode(hildon.TOUCH_SELECTOR_SELECTION_MODE_SINGLE)
        column.set_property("text-column", 0)
        selector.connect("changed", self.on_selected, store)



        vbox.pack_start(selector, True)
        self.show_all()

        #elf.loop = gobject.MainLoop()

    def on_selected(self,w,a,b):
        print "on_selected"
        store, iter = w.get_selected(a)
        print b.get_value( iter, 1)
        #self.loop.quit()
        self.destroy()
        telNr = b.get_value( iter, 1)
        print telNr," str to send ",self.str_to_send
        self.osmMapa.send_to_contact_step2( telNr, self.str_to_send )
