import gtk
import hildon
import osmgpsmap


class DetailsWindow(hildon.Dialog):

    def __init__(self, osmMapa, point, config):
        hildon.Dialog.__init__(self)
        
        
        self.point = point
        self.osmMapa = osmMapa
        self.CONFIG = config

        self.osmMapa.set_autorotate_for_object_same_as_UI(self)

        self.set_default_size(500, 500)
        self.set_title("Details")




        vbox = gtk.VBox()
        vbox0 = gtk.VBox()

        vbox.pack_start( self.get_label("<big>%s</big>" % point[3]) , False)


        osm = osmgpsmap.GpsMap()
        osm.set_center_and_zoom( point[0], point[1], 16 )
        osm.set_size_request(640, 160)
        osm.image_add( point[0], point[1], point[4]  )
        osm.connect('button_release_event', self.on_map_clicked, point[0], point[1])
        osm.connect('button_press_event', self.on_map_clicked, point[0], point[1])
        vbox.pack_start( osm, False)


        label = gtk.Label( "Lat: %f" % point[0] )
        vbox.pack_start( self.get_label(
            "<small>%s</small>" %  self.osmMapa.distance_to_string( self.osmMapa.distance( point[0], point[1]) )
            )
            , False)
        vbox.pack_start( self.get_label("Latitude: %f" % point[0]), False)
        vbox.pack_start( self.get_label("Longitude: %f" % point[1]), False)
        vbox.pack_start( self.get_label("Point from : %s" % point[2]), False)



        panel = hildon.PannableArea()
        panel.add_with_viewport(vbox)
        panel.set_size_request(640, 640)
        vbox0.pack_start( panel, True)


        bt_hbox = gtk.HBox()

        bt_mapa = hildon.Button(gtk.HILDON_SIZE_AUTO_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT,
                           hildon.BUTTON_ARRANGEMENT_VERTICAL,"Mapa")
        bt_mapa.connect("clicked", self.on_mapa)
        bt_hbox.pack_start( bt_mapa, True)
        
        
        
        
        if self.CONFIG['POI']:
            bt_poi = hildon.Button(gtk.HILDON_SIZE_AUTO_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT,
                           hildon.BUTTON_ARRANGEMENT_VERTICAL,"POI")
            bt_poi.connect("clicked",self.on_add_as_poi,point[0],point[1])
            bt_hbox.pack_start( bt_poi, True)

        if self.CONFIG['Google - routesearch']:
            bt_route = hildon.Button(gtk.HILDON_SIZE_AUTO_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT,
                           hildon.BUTTON_ARRANGEMENT_VERTICAL,"Route")
            bt_route.connect("clicked",self.on_route_to_it,point[0],point[1])
            bt_hbox.pack_start( bt_route, True)


        vbox0.pack_start(bt_hbox,False)
        

        self.vbox.pack_start(vbox0, True)

        self.show_all()
        
        
        
        self.run()
        self.destroy()

    def on_route_to_it(self, w, lat, lon):
        p = None
        for plugin in self.osmMapa.plugins_list:
            if plugin[1] == "Google - routesearch":
                p = plugin[0]
                break
        print "p:",p
        if p <> None:
            self.CONFIG['google_routesearch_from'] = "my current location"
            self.CONFIG['google_routesearch_to'] = "loc:%f+%f" %( lat, lon)
            p.search_action()
            self.destroy()
            
    def on_add_as_poi(self, w, lat, lon):
        poi = None
        for plugin in self.osmMapa.plugins_list:
            if plugin[1] == "POI":
                poi = plugin[0]
                break
        if poi <> None:
            self.osmMapa.osm.set_center( lat,lon)
            poi.on_add( None,None )
            self.destroy()

    def on_map_clicked(self,osm,event, lat, lon):
        osm.set_center_and_zoom( lat, lon, 16 )

    def on_mapa(self,w):
        self.destroy()


    def get_label(self, str):
        hbox = gtk.HBox( spacing = 5 )
        l0 = gtk.Label()
        l0.set_markup( str )
        hbox.pack_start( l0, False)

        l1 = gtk.Label()
        hbox.pack_start( l1, True)
        return hbox