import gtk
import gtk.gdk
from gtk import gdk
import xml.dom.minidom,os
from xml.dom.minidom import Node
import httplib
import osmgpsmap
import math
import cairo
from threading import Thread

class tangogps_friendDownloader(Thread):
    def __init__(self,pa):
        Thread.__init__(self)
        self.pa = pa

    def parseData(self, data_res):
        t = data_res.split( "|" )
        for f in t:
            i = f.split("#")
            if len(i) == 7:
                friend = [ i[1], float(i[2]),float(i[3]) ]
                self.pa.friend.append( friend )
        print "tangogps friend found ",len(self.pa.friend),"frend"

    def downloadData(self):
        # http://www.rcspot.pl/api_xml.php?p=eventy
        conn = httplib.HTTPConnection("www.tangogps.org")
        conn.request("GET", "/friends/update_pos.php")
        r = conn.getresponse()
        return r.read()


    def run(self):
        print "tangogps_friendDownloader downolad"
        data_res = self.downloadData()
        print "tangogps_friendDownloader parse"
        self.parseData(data_res)
        print "geonames downolad"
        self.pa.do_draw_friend()
        print "tangogps_friendDownloader DONE"


class tangogps_friend:

    def __init__(self,osmMapa,CONFIG):
        self.CONFIG = CONFIG
        self.osmMapa = osmMapa

        self.ico = "tangogps_ico.png"

        print "__init__ tangogps friend"

    def do_draw_friend(self):
        for e in self.friend:
            i = gdk.pixbuf_new_from_file( './plugins/tangogps-friend.png' )
            self.images.append( self.osmMapa.osm.image_add(e[1], e[2],i) )

    def clean_layer(self):
        self.friend = []
        for i in self.images:
            self.osmMapa.osm.image_remove( i )
        self.images = []

    def killIt(self):
        self.clean_layer()

    def makeInit(self):
        self.friend = []
        self.images = []
        t = tangogps_friendDownloader( self )
        t.start()

        return self



    def on_bt_update(self, w, dialog):
        self.clean_layer()
        self.makeInit()
        dialog.destroy()

    def get_menu_widgets(self, dialog):
        bt_update = gtk.Button("update")
        bt_update.connect("clicked", self.on_bt_update, dialog)
        return bt_update

    def get_name(self):
        return "tangogps friend"

    def do_draw(self, gpsmap, gdkdrawable):
        if self.osmMapa.osm.props.zoom>10:
            t_lt, t_ln, b_lt, b_ln = self.osmMapa.osm.get_bbox()
            t_lt, t_ln, b_lt, b_ln = math.degrees(t_lt), math.degrees(t_ln), math.degrees(b_lt), math.degrees(b_ln)
            cr = gdkdrawable.cairo_create()

            for p in self.friend:
                lt = p[1]
                ln = p[2]
                #print "lt:",t_lt,t_ln,"\t c:",lt,ln,"\tb:",b_lt,b_ln
                if t_ln < ln and b_ln > ln and t_lt > lt and b_lt < lt:
                    x,y = self.osmMapa.osm.geographic_to_screen(lt,ln)
                    self.osmMapa.draw_cloud( cr, x,y, p[0])


    def do_render(self, gpsmap):
        pass

    def do_busy(self):
        return False

    def do_button_press(self, gpsmap, gdkeventbutton):
        pass