import gtk
import gtk.gdk
from gtk import gdk
import xml.dom.minidom,os
from xml.dom.minidom import Node
import httplib
import osmgpsmap
import gobject
import math
import cairo
import hildon

from threading import Thread

class geonamesDownloader(Thread):
    def __init__(self,geonames,lat=0.0,lon=0.0,str=""):
        Thread.__init__(self)
        self.geonames = geonames
        self.tp = ""
        self.lat = lat
        self.lon = lon
        self.str = str


        self.action = "by ll"
        if self.str <> "":
            self.action = "by name"


    def parseXml(self, xml_res):
        doc = xml.dom.minidom.parseString(xml_res)
        if self.action == "by ll":
            self.tp = doc.getElementsByTagName("formatted_address")[0].childNodes[0].data
        elif self.action == "by name":
            try:
                self.tp = self.str
                box = doc.getElementsByTagName("location")[0]
                lat = float(box.getElementsByTagName("lat")[0].childNodes[0].data)
                lon = float(box.getElementsByTagName("lng")[0].childNodes[0].data)
                self.geonames.osmMapa.osm.set_center( lat, lon)
                self.geonames.poi = [self.str, lat, lon]
            except:
                self.geonames.osmMapa.showBanner(("no results for:%s" % self.str))



    def downloadXml(self):
        if self.action == "by ll":
            """
            http://maps.googleapis.com/maps/api/geocode/xml?latlng=52.40590109606264,16.92497491836548&sensor=true
            """

            conn = httplib.HTTPConnection("maps.googleapis.com")
            req = "/maps/api/geocode/xml?latlng=%f,%f&sensor=true" % (self.lat,self.lon)
            print req
            conn.request("GET", req)
            r = conn.getresponse()
            return r.read()
        elif self.action == "by name":
            conn = httplib.HTTPConnection("maps.googleapis.com")
            req = "/maps/api/geocode/xml?address=%s&sensor=true" % (self.str.replace(" ", "%20"))
            print req
            conn.request("GET", req)
            r = conn.getresponse()
            return r.read()


    def run(self):
        if self.action == "by name":
            self.geonames.osmMapa.showBanner(("searching:%s" % self.str))
        print "geonames downolad"
        res = self.downloadXml()
        print "geonames parse"
        self.parseXml( res )
        print "geonames downolad"
        self.geonames.tp = self.tp
        self.geonames.do_draw_address()
        print "goanames DONE"



class google_geonames:

    def __init__(self,osmMapa,CONFIG):
        self.CONFIG = CONFIG
        self.osmMapa = osmMapa

        self.ico = "google_maps.png"

        self.tp = ""
        self.timeout = 3
        self.draw = 0
        self.ll = 0,0
        self.poi = []

        try:
            print "google_geonames last search:", self.CONFIG['google_geonames_search']
        except:
            self.CONFIG['google_geonames_search'] = ""

        try:
            print "google_geonames download state:", self.CONFIG['google_geonames_download']
        except:
            self.CONFIG['google_geonames_download'] = 0

        print "__init__ google geonames"

    def makeTimeDelayLoop(self):
        self.timeout-=1
        #print self.timeout
        if self.timeout < 0:
            lat = float(self.osmMapa.osm.props.latitude)
            lon = float(self.osmMapa.osm.props.longitude)
            if self.ll <> [lat,lon]:
                self.timeout = 3
                print "geoname init download"
                self.tp = ""
                self.ll = [lat,lon]
                if self.CONFIG['google_geonames_download']:
                    t = geonamesDownloader( self, lat,lon)
                    t.start()
        gobject.timeout_add(1000, self.makeTimeDelayLoop)

    def makeInit(self):
        self.makeTimeDelayLoop()



    def do_draw_address(self):
        cr = self.draw.cairo_create()
        self.osmMapa.draw_cloud( cr, 10,12, self.tp, 20, False)


    def get_name(self):
        return "Google - geonames"

    def on_find(self,w, dialog,e_search):
        self.CONFIG['google_geonames_search'] = e_search.get_text()

        print "search for (",self.CONFIG['google_geonames_search'],")"

        t = geonamesDownloader( self, None, None, self.CONFIG['google_geonames_search'])
        t.start()

        dialog.destroy()

    def on_clean(self, w, e_search ):
        e_search.set_text("")

    def on_info_clikc(self, w):
        self.CONFIG['google_geonames_download'] = w.get_active()

    def get_menu_widgets(self, dialog):

        vbox = gtk.VBox()

        hbox = gtk.HBox()

        bt_c = gtk.Button("[x]")
        hbox.pack_start(bt_c, False)

        e_search = gtk.Entry()
        e_search.set_text(self.CONFIG['google_geonames_search'])
        hbox.pack_start(e_search, True)

        bt_c.connect("clicked", self.on_clean, e_search)

        bt_search = gtk.Button("Search")
        bt_search.connect("clicked", self.on_find, dialog, e_search)
        hbox.pack_start(bt_search, False)


        vbox.pack_start(hbox, False)
        bt_info = hildon.CheckButton(gtk.HILDON_SIZE_AUTO)
        bt_info.set_label("Downlad geonames")
        if self.CONFIG['google_geonames_download']:
            bt_info.set_active(True)
        bt_info.connect("clicked", self.on_info_clikc)
        vbox.pack_start(bt_info, False)


        return vbox

    def draw_info_place(self, str, lt, ln):
        cr = self.draw.cairo_create()
        x,y = self.osmMapa.osm.geographic_to_screen(lt,ln)
        self.osmMapa.draw_cloud( cr, x,y, str)


    def do_draw(self, gpsmap, gdkdrawable):
        if not self.draw:
            self.draw = gdkdrawable
        try:
            if self.poi[0]:
                self.draw_info_place(self.poi[0], self.poi[1], self.poi[2])
        except:
            pass


        self.timeout = 3



    def do_render(self, gpsmap):
        pass

    def do_busy(self):
        return False




    def do_button_press(self, gpsmap, gdkeventbutton):
        pass