import gtk
import gtk.gdk
from gtk import gdk
import hildon
import time
import xml.dom.minidom,os
from xml.dom.minidom import Node
import osmgpsmap
import math
import cairo
from PIL import Image


class photo_geotags:

    def __init__(self,osmMapa,CONFIG):
        self.CONFIG = CONFIG

        self.ico = "ico_cele_32_32.png"

        self.osmMapa = osmMapa
        self.CONFIG = CONFIG

        self.file = "/home/user/yosmapaPhotoGeotags.xml"
        self.imgs = []
        self.img_map = []

        print "__init__ photo_geotags"


    def on_bt_add(self, w, dlg,dialog):
        id = time.strftime("%Y%m%d%H%M%S", time.localtime() )
        lat = float(self.osmMapa.osm.props.latitude)
        lon = float(self.osmMapa.osm.props.longitude)
        self.poi.append([int(id),
                         self.e_name.get_text(),
                         lat,
                         lon
                        ])
        self.saveXml()
        self.poi_rebuild()
        dlg.destroy()
        dialog.destroy()

    def on_add(self, w, dialog):
        dlg = gtk.Dialog("Add POI")

        self.e_name = gtk.Entry()
        dlg.vbox.pack_start(self.e_name, True)

        bt_add = gtk.Button("Add")
        bt_add.connect("clicked", self.on_bt_add, dlg, dialog)
        dlg.vbox.pack_start(bt_add, True)


        dlg.show_all()





    def saveXml(self):
        f = open( self.file, "w")
        f.write("""<?xml version="1.0"?>
<points creator="yosmapa" version="1.0">
""")
        for p in self.poi:
            str = "    <poi lat=\"%f\" lon=\"%f\" id=\"%s\" name=\"%s\" />\n" % (float(p[2]),float(p[3]),p[0],p[1])
            f.write( str )
        f.write("""</points>"""         )
        f.close()



    def poi_rebuild(self):
        self.clean_layer()

        for pa in self.poi:
            i = gdk.pixbuf_new_from_file("./plugins/POI.png")
            self.poi_images.append( self.osmMapa.osm.image_add( float(pa[2]), float(pa[3]), i ) )
            print "POI - > add point on map"

    def clean_layer(self):
        for pr in self.poi_images:
            self.osmMapa.osm.image_remove(pr)
        self.poi_images = []

    def killIt(self):
        self.clean_layer()


    def getGeoTagFromFile(self, f ):
        img = Image.open(f)
        iter = 0
        exif = img._getexif()
        for i in exif:
            if i == 34853:
                print "[",exif[i],"]"
                tag = exif[i]
                lat = tag[2]
                lon = tag[4]
                lat = lat[0][0]+(60.00/lat[1][0])*0.1+(60.00/lat[2][0])*0.001
                lon = lon[0][0]+(60.00/lon[1][0])*0.1+(60.00/lon[2][0])*0.001

                print "lat: [",lat,"] lon:[",lon,"]"


    def makeInit(self):
        self.getGeoTagFromFile('/home/user/20110526_001.jpg')
        """
        try:
            self.doc = xml.dom.minidom.parse(self.file)

            for p in self.doc.getElementsByTagName("poi"):
                self.poi.append( [p.getAttribute("id"),
                                  p.getAttribute("name"),
                                  float(p.getAttribute("lat")),
                                  float(p.getAttribute("lon"))
                                ])
            print "POI read poi xml found (",len(self.poi),") POI :)"
        except:
            print "POI read poi xml file error create clean one"
            self.saveXml()


        self.poi_rebuild()
        """

    def get_menu_widgets(self, dialog):
        """
        hbox = gtk.HBox()

        bt_add = gtk.Button("Add")
        bt_add.connect("clicked", self.on_add, dialog)
        hbox.pack_start( bt_add, True)

        bt_edit = gtk.Button("Actions(%i)"%len(self.poi))
        hbox.pack_start( bt_edit, False)

        return hbox
        """
        return None
    def get_name(self):
        return "Photo geatags"



    def do_draw(self, gpsmap, gdkdrawable):
        if self.osmMapa.osm.props.zoom>10:
            t_lt, t_ln, b_lt, b_ln = self.osmMapa.osm.get_bbox()
            t_lt, t_ln, b_lt, b_ln = math.degrees(t_lt), math.degrees(t_ln), math.degrees(b_lt), math.degrees(b_ln)

            cr = gdkdrawable.cairo_create()

            for p in self.poi:
                lt = p[2]
                ln = p[3]
                #print "lt:",t_lt,t_ln,"\t c:",lt,ln,"\tb:",b_lt,b_ln
                if t_ln < ln and b_ln > ln and t_lt > lt and b_lt < lt:
                    x,y = self.osmMapa.osm.geographic_to_screen(lt,ln)
                    self.osmMapa.draw_cloud( cr, x,y, p[1] )


    def do_render(self, gpsmap):
        pass

    def do_busy(self):
        return False

    def do_button_press(self, gpsmap, gdkeventbutton):
        return False

