import gtk
import gtk.gdk
from gtk import gdk
import xml.dom.minidom,os
from xml.dom.minidom import Node
import httplib
import osmgpsmap
import math
import cairo
import hildon

from threading import Thread

class nominatimDownloader(Thread):
    def __init__(self,geonames,box,str="", more = False):
        Thread.__init__(self)
        self.geonames = geonames
        self.tp = ""
        self.box = box
        self.zoom_start = self.geonames.osmMapa.osm.props.zoom
        self.str = str
        self.more = more


        self.action = "by ll"
        if self.str <> "":
            self.action = "by name"


    def parseXml(self, xml_res):
        doc = xml.dom.minidom.parseString(xml_res)
        tr = []
        try:
            for p in doc.getElementsByTagName("place"):
                lat = float(p.getAttribute("lat"))
                lon = float(p.getAttribute("lon"))
                id = int(p.getAttribute("place_id"))
                name = p.getAttribute("display_name").split(",")[0]

                try:
                    ico_href = p.getAttribute("icon").replace("20.png", "32.png")
                    ico_name = "./maps/%s" % ico_href.replace("/", "_")
                    if not os.path.exists( ico_name ):
                        ico_cmd = "wget \"%s\" -O \"%s\"" % (ico_href, ico_name )
                        os.system(ico_cmd)
                    ico = gdk.pixbuf_new_from_file(ico_name)
                except:
                    ico_name = "./maps/ico_igla_32_32.png"
                    ico = gdk.pixbuf_new_from_file(ico_name)

                print "poi found in xml"

                add_it = 1
                for p in self.geonames.p:
                    if p[4] == id:
                        add_it = 0
                        break

                if add_it:
                    tr.append( [lat,lon,ico,name,id,ico_name] )

        except Exception, e:
            print "parseXml Error: ",e

        return tr


    def downloadXml(self):
        """
        http://nominatim.openstreetmap.org/search?viewbox= 16.73, 52.5  ,17.11, 52.3&q=fuel&format=xml&bounded=1&limit=10
        """
        more_url = ""
        if self.more:
            more_url = "&exclude_place_ids="
            for id in self.geonames.p:
                more_url = "%s%i," % (more_url, id[4])

        t_lt, t_ln, b_lt, b_ln = self.box
        t_lt, t_ln, b_lt, b_ln = math.degrees(t_lt), math.degrees(t_ln), math.degrees(b_lt), math.degrees(b_ln)
        #print t_lt, t_ln, b_lt, b_ln
        conn = httplib.HTTPConnection("nominatim.openstreetmap.org")
        req = "/search?viewbox=%f,%f,%f,%f&q=%s&format=xml&bounded=1%s&limit=15" % ( t_ln, t_lt, b_ln,b_lt, self.str.replace(" ","%20"),more_url )
        print req
        conn.request("GET", req)
        r = conn.getresponse()
        return r.read()


    def run(self):
        if self.more == False:
            self.geonames.osmMapa.showBanner(("searching:%s" % self.str))
        print "geonames downolad"
        res = self.downloadXml()
        print "geonames parse"
        tr = self.parseXml( res )
        print "geonames parse DONE len(",len(tr),")"

        if len(tr)==0 and self.geonames.osmMapa.osm.props.zoom > 5:
            self.geonames.osmMapa.osm.set_zoom( self.geonames.osmMapa.osm.props.zoom-1 )
            self.box = self.geonames.osmMapa.osm.get_bbox()
            print "make one more iter on less zoom"
            self.geonames.osmMapa.showBanner("looking on bigger area")
            self.run()
        elif len(tr)==0:
            self.geonames.osmMapa.osm.set_zoom( self.zoom_start )
            self.geonames.osmMapa.showBanner("no result in bigger area too :..(")
        else:
            self.geonames.osmMapa.osm.set_zoom( self.zoom_start )
            print "geonames downolad"
            self.geonames.do_draw_address( tr, self.more )
            print "goanames DONE"



class nominatim_geonames:

    def __init__(self,osmMapa,CONFIG):
        self.CONFIG = CONFIG
        self.osmMapa = osmMapa

        self.ico = "nominatim.png"

        self.box_old = 0,0,0,0

        self.draw = 0
        self.p = []
        self.p_on_map = []
        self.timeout = 3
        self.downloadMore = 0

        try:
            print "nominatim_geonames recent search for:\n",self.CONFIG['nominatim_geonames_recent_search'],"\n-----------"
        except:
            self.CONFIG['nominatim_geonames_recent_search'] = []

        try:
            print "nominatim_geonames search for:",self.CONFIG['nominatim_geonames_search']
        except:
            self.CONFIG['nominatim_geonames_search'] = ""

        try:
            if self.CONFIG['nomenatim_geonames_arrows']:
                pass
        except:
            self.CONFIG['nomenatim_geonames_arrows'] = 1

        print "__init__ nominatim_geonames"

        """
    def makeTimeDelayLoop(self):
        self.timeout-=1
        #print self.timeout
        if self.timeout < 0:
            self.box = self.osmMapa.osm.get_bbox()
            if self.box_old <> self.box:
                self.timeout = 3
                print "geoname init download"
                self.box_old = self.box
                if self.CONFIG['nominatim_geonames_search']<>"":
                    try:
                        t = nominatimDownloader( self, self.box, self.CONFIG['nominatim_geonames_search'])
                        t.start()
                    except:
                        print "downlaod error "

        gobject.timeout_add(1000, self.makeTimeDelayLoop)
        """

    def makeInit(self):
        pass

    def on_clean(self, w, e_search ):
        e_search.set_text("")

    def layer_clear(self):
        for p in self.p_on_map:
            self.osmMapa.osm.image_remove( p )
        self.p_on_map = []

    def do_draw_address(self, tr = [], more = False):
        if more == False:
            self.osmMapa.showBanner(("results:%i" % len(tr)))
        print "do_draw_address init with: (",len(tr),")"
        if tr <> self.p:
            print "do_draw_address"
            if more == False:
                self.layer_clear()
                self.p = tr
                for p in self.p:
                    self.p_on_map.append( self.osmMapa.osm.image_add( p[0],p[1],p[2] ) )
            else:
                for p in tr:
                    self.p.append( p )
                for p in tr:
                    self.p_on_map.append( self.osmMapa.osm.image_add( p[0],p[1],p[2] ) )



        reTmp = []
        reTmp.append( [self.CONFIG['nominatim_geonames_search'],p[5]] )
        for r in self.CONFIG['nominatim_geonames_recent_search']:
            if r[0] <> self.CONFIG['nominatim_geonames_search']:
                reTmp.append( r )
        self.CONFIG['nominatim_geonames_recent_search'] = []
        self.CONFIG['nominatim_geonames_recent_search'] = reTmp

        if len(self.p) == 1:
            self.osmMapa.osm.set_center( self.p[0][0], self.p[0][1] )


        """
        cr = self.draw.cairo_create()
        cr.set_source_rgb(0.0, 0.0, 0.0)
        cr.select_font_face("Georgia")
        cr.set_font_size(15)
        cr.move_to(10, 50)
        cr.show_text("%s" % self.tp)
        """

    def get_name(self):
        return "Nominatim - geonames"

    def find_res(self, more = False):
        self.layer_clear()
        self.box = self.osmMapa.osm.get_bbox()
        t = nominatimDownloader( self, self.box, self.CONFIG['nominatim_geonames_search'])
        t.start()

    def on_find(self,w, dialog, e_search):
        self.CONFIG['nominatim_geonames_search'] = e_search.get_text()
        print "search for (",self.CONFIG['nominatim_geonames_search'],")"
        self.find_res()
        self.downloadMore = 1
        dialog.destroy()

    def on_clear(self, w, dialog ):
        self.layer_clear()
        self.p = []
        self.downloadMore = 0
        dialog.destroy()

    def on_bt_arrow_click(self,w):
        if w.get_active():
            self.CONFIG['nomenatim_geonames_arrows'] = 1
        else:
            self.CONFIG['nomenatim_geonames_arrows'] = 0

    def on_recent_click(self, w, dialog):
        e = gtk.Entry()
        e.set_text(w.get_label())
        self.on_find( w, dialog, e)

    def get_menu_widgets(self, dialog):

        vbox = gtk.VBox()

        if len(self.CONFIG['nominatim_geonames_recent_search'])>0:
            mvbox = gtk.VBox()
            panel = hildon.PannableArea()
            panel.add_with_viewport(mvbox)
            vbox.pack_start( panel, True,True)
            panel.set_size_request(640, 280)

            for s in self.CONFIG['nominatim_geonames_recent_search']:
                hbox = gtk.HBox()
                if s[1] <> "":
                    img = gtk.Image()
                    img.set_from_file(s[1])
                    hbox.pack_start(img,False)
                b = gtk.Button(s[0])
                b.connect("clicked", self.on_recent_click, dialog)
                hbox.pack_start(b, True)
                mvbox.pack_start(hbox, False)


        hbox = gtk.HBox()

        bt_c = gtk.Button("[x]")
        hbox.pack_start(bt_c, False)

        e_search = gtk.Entry()
        e_search.set_text(self.CONFIG['nominatim_geonames_search'])
        hbox.pack_start(e_search, True)

        bt_c.connect("clicked", self.on_clean, e_search)

        bt_search = gtk.Button("Search")
        bt_search.connect("clicked", self.on_find, dialog, e_search)
        hbox.pack_start(bt_search, False)

        bt_c = gtk.Button("Clear")
        bt_c.connect("clicked", self.on_clear, dialog)
        hbox.pack_start(bt_c, False)



        vbox.pack_start(hbox, False)

        bt_arrow = hildon.CheckButton(gtk.HILDON_SIZE_AUTO)
        bt_arrow.set_label("show arrows")
        try:
            if self.CONFIG['nomenatim_geonames_arrows']:
                bt_arrow.set_active( self.CONFIG['nomenatim_geonames_arrows'] )
        except:
            pass
        bt_arrow.connect("clicked", self.on_bt_arrow_click)
        vbox.pack_start(bt_arrow, True)

        return vbox




    def do_draw(self, gpsmap, gdkdrawable):
        if self.osmMapa.osm.props.zoom>9:
            t_lt, t_ln, b_lt, b_ln = self.osmMapa.osm.get_bbox()
            t_lt, t_ln, b_lt, b_ln = math.degrees(t_lt), math.degrees(t_ln), math.degrees(b_lt), math.degrees(b_ln)

            cr = gdkdrawable.cairo_create()

            for p in self.p:
                lt = p[0]
                ln = p[1]

                if self.CONFIG['nomenatim_geonames_arrows']:
                    self.osmMapa.draw_arrow( gdkdrawable, lt,ln )

                #print "lt:",t_lt,t_ln,"\t c:",lt,ln,"\tb:",b_lt,b_ln
                if t_ln < ln and b_ln > ln and t_lt > lt and b_lt < lt:
                    self.osmMapa.draw_cloud_byll( cr, lt,ln, p[3])

    def do_render(self, gpsmap):
        pass

    def do_busy(self):
        return False

    def do_button_release(self, gpsmap, gdkeventbutton):
        """
        if self.downloadMore:
            print "nominatim_geonames download more !"
            self.box = self.osmMapa.osm.get_bbox()
            t = nominatimDownloader( self, self.box, self.CONFIG['nominatim_geonames_search'], True)
            t.start()
        """
        pass