#!/usr/bin/python

"""
Copyright (C) Hadley Rich 2008 <hads@nice.net.nz>
based on main.c - with thanks to John Stowers

This is free software: you can redistribute it and/or modify it
under the terms of the GNU General Public License
as published by the Free Software Foundation; version 2.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, see <http://www.gnu.org/licenses/>.



docs

gtk
    http://www.pygtk.org/reference.html
hildon
    http://pymaemo.garage.maemo.org/python_hildon_manual/hildonobjects.html
    http://maemomm.garage.maemo.org/docs/tutorial/html/index.html
    http://maemo.org/api_refs/5.0/5.0-final/hildon/
osmgpsmap
    http://nzjrs.github.com/osm-gps-map/docs/reference/html/index.html
    http://nzjrs.github.com/osm-gps-map/docs/reference/html/api-index-full.html


"""
import math
import time
import sys
import os.path
import gtk.gdk
import gobject
import imp
import pickle
from gtk import gdk
from threading import Thread
import xml.dom.minidom,os
from xml.dom.minidom import Node
import hildon
import dbus.glib
import cairo

gobject.threads_init()
from dbus import glib
glib.init_threads()

gtk.gdk.threads_init()


name = "yosmapa"
version = "0.18"
"""
0.18-2
    plugin[google_routesearch] add more icons
    clien up distanse recalculation
    plugin[POI] add delete action
0.18
    plugin[google_routesearch] support for espeak in turn by turn mode :)
0.17
    on clouds actions:
        center to
        distans
        add as POI
        search route :)
    plugin[nominatim_geonames] add recent search
        if one result center to it
0.16
    arrow system :)
    plugin[gps_tracks] add threshold for record track
        settings for recording resolution
        migrate to arrow system
    plugin[nominatim_geonames] migrate to arrow system as option
    plugin system less inits
0.15
    plugin[google_routesearch] export route to gpx file :)
0.14
    plugin[gpx_tracks] haha short cut creator :P app show you a closest point of
        defined track if you take a bead turn. no more zoom out ! :)
    plugin[taskswitcher] add it. if enabled start in full screen with icon
0.13
    plugin[nominatim geonames] make loop - zoom out if not results found. search in bigger area
    plugin[google_routesearch] my current location is now getting from gps if pressent not from screen center
    plugin[gpx_tracks] add loaded track info.
        add recording track info
0.12
    show ~accuracy on gps pointer
    on gps lock crosshair not shown
    plugin[gpx_tracks] no more save button :P save dialog activate when you disable record less clicks
        more hicontrast color on track and width line
0.11
    osd layer move to cairo from pixbuff
    add cloud system :P
    bugfix - working on "Xlib: unexpected async reply (sequence 0xblablabla)!" :/
    plugin[gpx_tracks] fix for dowload for offline work. download less area
    plugin[google_routesearch] add download for offline work
        add button [+] add location from map to focused field
    title queued move to main ui not in plugin
0.10
    plugin[google_routesearch] trawel mode selection
    bugfix - plugins have a problem with "self", no propper destroy
    plugin[google_routesearch] add decoder for polylines :)
        add clear old track
0.9
    auto rotation screen configurable :)
    plugin[gpx_tracks]ico monit state rec. or not :)
    plugins reorganization. new access methode. menu on the left border of the screen
    bugfix - after gps click set up lat lon not from gps track but from gps manager
        no need to wait to next fix to set center of screen
    plugin[nominatim geonames] geo names from nominatim
0.8
    icons from plugins in menu
    bugfix - after long time sleep screen don't turn on. fixed :)
    plugin[gpx_track] add on/off for record track
    plugin[fotoradary] :) load poi from file ./plugins/fotoradary.txt
        draw only poi on screen box not more
0.7
    plugins makeIt and killIt on the fly :) no restart needed
    less tiks on screen off :)
    speed up improwment on map click less stuff to do
0.6
    clean up plugins and stdout
    plugin[rcspot eventy] add thread :)
    plugin[tangogps_friend] add thread :)
0.5
    plugin[POI] add labels
    plugin[gpx_tracks] add info about downloading status
    plugin[geonames] :)
    plugin[routesearch]
"""


def deb(str):
    print "-------------------------\n",str,"\n-------------------------"


#Try static lib first
mydir = os.path.dirname(os.path.abspath(__file__))
libdir = os.path.join(mydir, ".libs")
sys.path.insert(0, libdir)

import osmgpsmap
deb("using library: %s" % osmgpsmap.__file__)


try:
    import location
    deb("gps found!")
    gpsPresent = 1
except Exception, e:
    print "FROM ERROR location ",e
    gpsPresent = 0


try:
    from portrait import *
    autorotate = 1
except Exception, e:
    print "FROM ERROR portriat ",e
    autorotate = 0


CONFIG = {
    'zoom':       3,
    'lat':        0.0,
    'lon':        0.0,

    'engine_name':    osmgpsmap.SOURCE_OPENSTREETMAP,

    'gpxtrack':     0,
    'gpxfile':      '',

    'gpslock':      0,

    }


maps_source = [
    [osmgpsmap.SOURCE_OPENSTREETMAP, "OpenStreetMap I"],
    [osmgpsmap.SOURCE_OPENSTREETMAP_RENDERER, "OpenStreetMap II"],
    [osmgpsmap.SOURCE_OPENAERIALMAP, "OpenAerialMap"],
#    [osmgpsmap.SOURCE_OPENCYCLEMAP, "OpenCycleMap"],
#    [osmgpsmap.SOURCE_OSM_PUBLIC_TRANSPORT, "Public Transport"],
#    [osmgpsmap.SOURCE_OSMC_TRAILS, "OSMC Trails"],
    [osmgpsmap.SOURCE_MAPS_FOR_FREE, "Maps-For-Free"],
    [osmgpsmap.SOURCE_GOOGLE_STREET, "Google Maps"],
    [osmgpsmap.SOURCE_GOOGLE_SATELLITE, "Google Satellite"],
    [osmgpsmap.SOURCE_GOOGLE_HYBRID, "Google Hybrid"],
    [osmgpsmap.SOURCE_VIRTUAL_EARTH_STREET, "Virtual Earth"],
    [osmgpsmap.SOURCE_VIRTUAL_EARTH_SATELLITE, "Virtual Earth Satellite"],
    [osmgpsmap.SOURCE_VIRTUAL_EARTH_HYBRID, "Virtual Earth Hybrid"],
    [osmgpsmap.SOURCE_YAHOO_STREET, "Yahoo Maps"],
    [osmgpsmap.SOURCE_YAHOO_SATELLITE, "Yahoo Satellite"],
    [osmgpsmap.SOURCE_YAHOO_HYBRID, "Yahoo Hybrid"]
               ]


try:
    from win32com.shell import shellcon, shell
    home = ("%s\\.%s_%s.conf" % (hell.SHGetFolderPath(0, shellcon.CSIDL_APPDATA, 0, 0), name,version) )
except ImportError: # quick semi-nasty fallback for non-windows/win32com case
    home =  ("%s/.%s_%s.conf"% (os.path.expanduser("~"), name,version) )

def config_save():
    global home
    print "config - saveing"
    ts = []
    for b in CONFIG:
        ts.append([b, CONFIG[b]])

    f = open(home,"w")
    pickle.dump( ts, f )
    f.close()
    print "done"

def config_load():
    global home
    global CONFIG

    if os.path.exists(home):
        print "config - loading ..."
        f = open(home,"r")
        tp = pickle.load(f)
        f.close()
        for b in tp:
            CONFIG[b[0]] = b[1]

        print "done"
    else:
        print "config - config file not found :/"
        config_save()

    print ("detect home path: [%s]" % home)


class MyDialog( hildon.Dialog ):

    def on_close(self,widget=None):
        self.destroy()


    def on_map_source(self, widget, map_source):
        #def load_map_clicked(self, button=None, uri=None, format=None)
        CONFIG['engine_name'] = map_source
        self.osmMapa.load_map_clicked()

        self.on_close()

    def on_changed_map (self,picker):
        str = picker.get_value()
        id = -1
        iter = 0
        for map_name in maps_source:
            if map_name[1] == str:
                id = iter
                break
            else:
                iter+=1
        print "selected source map: ", maps_source[id]
        CONFIG['engine_name'] = maps_source[id][0]

        self.osmMapa.osm.props.map_source = maps_source[id][0]
        self.on_close()

    def on_bt_rotate_click( self, w):
        state = w.get_active()
        CONFIG['autorotate'] = state
        if state:
            self.osmMapa.window_rotate.set_mode( FremantleRotation.AUTOMATIC )
        else:
            self.osmMapa.window_rotate.set_mode( FremantleRotation.NEVER )


    def on_bt_full(self, w, dialog):
        dialog.destroy()
        self.osmMapa.fullscreen_toggle()

    def __init__(self, osmMapa):

        gtk.Dialog.__init__(self)
        self.osmMapa = osmMapa
        self.set_title("Menu")
        self.set_size_request(640, 480)

        pack = True

        mvbox = gtk.VBox()
        panel = hildon.PannableArea()
        panel.add_with_viewport(mvbox)
        self.vbox.pack_start(panel, pack)

        for plugin in self.osmMapa.plugins_list:
            plugin_name = plugin[1]

            ico = None
            w = None
            try:
                w = plugin[0].get_menu_widgets(self)
            except Exception, e:
                print "plugin -> get_menu_widgets error 1 ", e

            try:
                ico = plugin[0].ico
            except:
                pass

            if CONFIG[plugin_name] and w <> None and ico == None:
                try:
                    pvbox = gtk.VBox()
                    label = gtk.Label( plugin[1]+":" )
                    label2 = gtk.Label()
                    phbox = gtk.HBox()
                    phbox.pack_start( label, False)
                    phbox.pack_start( label2, True)
                    pvbox.pack_start( phbox, True )
                    if ico:
                        hbox = gtk.HBox()
                        i = gtk.Image()
                        i.set_from_file( "./plugins/%s" % ico )
                        hbox.pack_start( i, False )
                        hbox.pack_start(w,pack)
                        pvbox.pack_start(hbox, True)
                    else:
                        pvbox.pack_start(w,pack)

                    mvbox.pack_start( pvbox, pack)

                except ValueError:
                    print "plugin -> get_menu_widgets error 2", ValueError


        hs = gtk.HSeparator()
        mvbox.pack_start( hs, pack )






        hbox = gtk.HBox()


        pb_map_src = hildon.PickerButton(gtk.HILDON_SIZE_AUTO,
                                        hildon.BUTTON_ARRANGEMENT_HORIZONTAL)
        pb_map_src.set_title("Map source")
        selector_map = hildon.TouchSelectorEntry(text=True)
        map_set_id = 0
        iter_nr = 0
        for map_name in maps_source:
            if map_name[0] == CONFIG['engine_name']:
                map_set_id = iter_nr
            else:
                iter_nr+=1
            selector_map.append_text(map_name[1])
        pb_map_src.set_selector(selector_map)
        pb_map_src.set_active(map_set_id)
        pb_map_src.connect("value-changed",self.on_changed_map)
        hbox.pack_start( pb_map_src, pack )

        if autorotate:
            bt_rotate = hildon.CheckButton(gtk.HILDON_SIZE_AUTO)
            bt_rotate.set_label("rotate screen")
            try:
                if CONFIG['autorotate']:
                    bt_rotate.set_active( CONFIG['autorotate'] )
            except:
                pass
            bt_rotate.connect("clicked", self.on_bt_rotate_click)
            hbox.pack_start(bt_rotate, pack)

        bt_full = gtk.Button("(un)fullscreen")
        bt_full.connect("clicked", self.on_bt_full, self)
        hbox.pack_start( bt_full, pack)

        mvbox.pack_start( hbox, False )

        # plugins menagment
        pb_plugs = hildon.PickerButton(gtk.HILDON_SIZE_AUTO_WIDTH,
                                        hildon.BUTTON_ARRANGEMENT_HORIZONTAL)
        pb_plugs.set_title("Plugins")
        sel_plugs = self.create_customized_selector_of_plugs()
        pb_plugs.set_selector( sel_plugs )
        pb_plugs.connect("value-changed", self.selection_plugs, sel_plugs)
        self.vbox.pack_start( pb_plugs, False )
        # plugins menagment

        # test
        if 0:
            pass
        # test
        self.show_all()


    def create_customized_selector_of_plugs(self):
        selector = hildon.TouchSelector( text = True)
        selector.set_column_selection_mode(hildon.TOUCH_SELECTOR_SELECTION_MODE_MULTIPLE)

        iter = 0
        for plugin in self.osmMapa.plugins_list:
            name = plugin[1]
            selector.append_text( name )
            if CONFIG[name]:
                selector.select_iter(0, selector.get_model(0).get_iter(iter), False)
            else:
                selector.unselect_iter(0, selector.get_model(0).get_iter(iter))
            iter+=1
        return selector

    def selection_plugs(self,selector,a):

        s = a.get_current_text().replace("(","").replace(")","")
        p = s.split(",")

        active_list = []
        deactive_list = []

        for plugin in self.osmMapa.plugins_list:
            pn = plugin[1]
            deactive = 1
            for n in p:
                if n == pn:
                    if not CONFIG[pn]:
                        active_list.append(pn)

                    CONFIG[pn] = 1
                    deactive = 0
                    break
            if deactive:
                if CONFIG[pn]:
                   deactive_list.append(pn)
                CONFIG[pn] = 0


        for a in active_list:
            for plugin in self.osmMapa.plugins_list:
                pn = plugin[1]
                if pn == a:
                    try:
                        plugin[0].makeInit()
                        print "plugin state to active makeInit ",pn
                    except Exception, e:
                        print "plugin state to active makeInit ERROR",pn,e

                    break
        print "plugins killIt:",deactive_list
        for a in deactive_list:
            for plugin in self.osmMapa.plugins_list:
                pn = plugin[1]
                if pn == a:
                    try:
                        plugin[0].killIt()
                        print "plugin state to active killIt ",pn
                    except Exception, e:
                        print "plugin state to active killIt ERROR",pn,e
                    break

        dialog = MyDialog(self.osmMapa)
        self.destroy()



class YosmapaOSD(gobject.GObject, osmgpsmap.GpsMapLayer):
    def __init__(self, osmMapa):
        gobject.GObject.__init__(self)
        self.osmMapa = osmMapa

        self.plugin_ico_yoffset = 50
        self.plugin_ico_h = 60
        self.plugin_ico_test = 48

    def do_draw(self, gpsmap, gdkdrawable):
        #return None

        self.size = gdkdrawable.get_size()

        cr = gdkdrawable.cairo_create()

        try:
            if self.pp_plus:
                pass
        except:
            self.pb_plus = cairo.ImageSurface.create_from_png( './imgs/i_plus.png' )
            self.pb_min = cairo.ImageSurface.create_from_png( './imgs/i_min.png' )
            self.pb_gps_on = cairo.ImageSurface.create_from_png( './imgs/i_gps_on.png' )
            self.pb_gps = cairo.ImageSurface.create_from_png( './imgs/i_gps.png' )
            self.pb_menu = cairo.ImageSurface.create_from_png( './imgs/ico_work_64_64.png' )

        #pb_c.render_to_drawable( gdkdrawable, gc, 0,0,100,100,pb_c.get_width(),pb_c.get_height(),0,0,0 )

        x = self.size[0]-64


        cr.set_source_surface( self.pb_plus, x,10 )
        cr.paint()

        if gpsPresent:
            if CONFIG['gpslock'] == 1:
                cr.set_source_surface( self.pb_gps_on, x,100 )
            else:
                cr.set_source_surface( self.pb_gps, x,100 )
            cr.paint()

            try:
               self.osmMapa.osm.props.gps_track_highlight_radius = (gps.accuracy/gps.acc_scale[self.osmMapa.osm.props.zoom])*10
            except:
                self.osmMapa.osm.props.gps_track_highlight_radius = 0
                print "GPS manager: accurasy is insain (",self.accuracy,")"


        cr.set_source_surface( self.pb_min, x,200 )
        cr.paint()
        cr.set_source_surface( self.pb_menu, x,self.size[1]-100 )
        cr.paint()


        plug_nr = 0
        for plugin in self.osmMapa.plugins_list:
            plugin_name = plugin[1]
            if CONFIG[plugin_name] and plugin[2]:
                if len(plugin) == 3:
                    plugin.append( plugin[0].get_menu_widgets(self) )
                if plugin[3] <> None:
                    cr.set_source_surface( plugin[2], 2, (plug_nr*self.plugin_ico_h)+self.plugin_ico_yoffset )
                    cr.paint()
                    plug_nr+=1




        if self.osmMapa.osm.props.tiles_queued != 0:
            str = "Downloading images (%i)" % self.osmMapa.osm.props.tiles_queued
            cr.set_source_rgb(0.0, 0.0, 0.0)
            cr.select_font_face("Georgia")
            cr.set_font_size(15)
            cr.move_to(10,15)
            cr.show_text(str)

        return None

    def do_render(self, gpsmap):
        pass

    def do_busy(self):
        return False

    def do_button_press(self, gpsmap, gdkeventbutton):
        #print "dummy event ",gpsmap, gdkeventbutton
        x = self.size[0]-64
        #print "x start",x,"bt press at",gdkeventbutton.x
        if gdkeventbutton.x >= x:
            if gdkeventbutton.y>10 and gdkeventbutton.y<74:
                print "bt plus"
                self.osmMapa.zoom_in_clicked(None)
            elif gdkeventbutton.y>100 and gdkeventbutton.y<164:
                print "bt gps"
                if CONFIG['gpslock']:
                    CONFIG['gpslock'] = 0
                    self.osmMapa.osd.props.show_crosshair = True
                else:
                    CONFIG['gpslock'] = 1
                    self.osmMapa.osd.props.show_crosshair = False
                    try:
                        if gpsPresent:
                            self.osmMapa.osm.set_center( gps.lat, gps.lon )
                    except:
                        print "gps get trac kupa"
            elif gdkeventbutton.y>200 and gdkeventbutton.y<264:
                print "bt min"
                self.osmMapa.zoom_out_clicked(None)
            elif gdkeventbutton.y>(self.size[1]-100) and  gdkeventbutton.y<(self.size[1]-34):
                print "bt menu"
                dialog = MyDialog(self.osmMapa)
                #print "response from dialog [",res,"]"

        elif gdkeventbutton.x <= 52:
            plug_nr = 0
            for plugin in self.osmMapa.plugins_list:
                plugin_name = plugin[1]
                if CONFIG[plugin_name]:
                    try:
                        ico = plugin[0].ico
                        w = plugin[0].get_menu_widgets(self)
                        y = (plug_nr*self.plugin_ico_h)+self.plugin_ico_yoffset
                        if gdkeventbutton.y < (y+self.plugin_ico_test) and gdkeventbutton.y > y:
                            print "clicked on plugin nr ",plug_nr," name:", plugin_name

                            try:
                                w.destroy()
                            except:
                                pass
                            try:
                                md.destroy()
                            except:
                                pass
                            try:
                                w2.destroy()
                            except:
                                pass

                            md = hildon.Dialog()
                            md.set_title( plugin_name )
                            w2 = plugin[0].get_menu_widgets(md)
                            md.vbox.pack_start( w2, True )
                            md.show_all()
                            #md.run()
                        if w <> None:
                            plug_nr+=1
                    except:
                        pass
        else:
            x = gdkeventbutton.x
            y = gdkeventbutton.y
            print "click at :",x,",",y
            for c in self.osmMapa.clikable_clouds:
                if x >= c[0] and y >= c[1] and x<= c[2] and y<= c[3]:
                    print "c:",c
                    m = gtk.Menu()
                    latc,lonc = self.osmMapa.get_may_current_ll()
                    dis = self.osmMapa.distance_to_string( self.osmMapa.distance( latc, lonc, c[4], c[5]) )

                    mi = gtk.MenuItem("___________Distans it: %s" % dis)
                    m.append(mi)

                    mi = gtk.MenuItem("___________Center to")
                    mi.connect("activate",self.on_set_center,c[4],c[5])
                    m.append(mi)

                    if CONFIG['POI']:
                        mi = gtk.MenuItem("___________Add as POI")
                        mi.connect("activate",self.on_add_as_poi,c[4],c[5])
                        m.append(mi)

                    if CONFIG['Google - routesearch']:
                        mi = gtk.MenuItem("___________Route to it")
                        mi.connect("activate",self.on_route_to_it,c[4],c[5])
                        m.append(mi)

                    m.show_all()
                    m.popup( None, None, None , 2, 0)


        return False

    def on_route_to_it(self, w, lat, lon):
        p = None
        for plugin in self.osmMapa.plugins_list:
            if plugin[1] == "Google - routesearch":
                p = plugin[0]
                break
        if p <> None:
            CONFIG['google_routesearch_from'] = "my current location"
            CONFIG['google_routesearch_to'] = "loc:%f+%f" %( lat, lon)
            p.search_action()

    def on_add_as_poi(self, w, lat, lon):
        poi = None
        for plugin in self.osmMapa.plugins_list:
            if plugin[1] == "POI":
                poi = plugin[0]
                break
        if poi <> None:
            self.osmMapa.osm.set_center( lat,lon)
            poi.on_add( None,None )


    def on_set_center(self, w,lat, lon):
        self.osmMapa.osm.set_center( lat,lon)
gobject.type_register(YosmapaOSD)







class UI(gtk.Window):

    def dont_sleep(self):
        f = open( "/sys/class/backlight/acx565akm/brightness", "r")
        content = f.read()
        f.close()
        if int(content) <> 0:
            CONFIG['work_work_work'] = 1
            if CONFIG['gpslock']:
                self.req.req_tklock_mode_change('unlocked')
        else:
            CONFIG['work_work_work'] = 0

            #req.req_tklock_mode_change('locked')

        if CONFIG['work_work_work']:
            time_loop = 15000
        else:
            time_loop = 25000


        gobject.timeout_add( time_loop, self.dont_sleep )

    def fullscreen_toggle(self):
        if self.window_is_fullscreen:
            self.unfullscreen()
            self.window_is_fullscreen = False
        else:
            self.fullscreen()
            self.window_is_fullscreen = True

    def on_key_down(self,widget,a):
        print "keydown", a.keyval
        if a.keyval == 102: # f
            self.fullscreen_toggle()
    def showBanner(self, str):
        print "showBanner push one: (",str,")"
        hildon.hildon_banner_show_information(self, "", str)

    def ben_iter_func(self):
        self.ben_iter-=1
        CONFIG['lat']-= 0.00003
        CONFIG['lon']-= 0.00003
        self.osm.set_center( CONFIG['lat'], CONFIG['lon'] )

        CONFIG['lat']= self.osm.props.latitude
        CONFIG['lon']= self.osm.props.longitude
        #print "ben_iter_funk to go:", self.ben_iter

        gobject.timeout_add( 50, self.ben_iter_func  )

        if self.ben_iter < 0:
            gtk.main_quit()


    def __init__(self):
        self.window_is_fullscreen = False

        gtk.Window.__init__(self, gtk.WINDOW_TOPLEVEL)
        self.connect('key-release-event', self.on_key_down)

        self.ben_iter = 100

        CONFIG['work_work_work'] = 1

        try:
            print "track record chk: ",CONFIG['track_record']
        except:
            CONFIG['track_record'] = 0

        try:
            print "autorotate mode: ",CONFIG['autorotate']
        except:
            CONFIG['autorotate'] = 1

        try:
            self.bus = dbus.SystemBus()
            self.req = self.bus.get_object('com.nokia.mce','/com/nokia/mce/request')

            self.dont_sleep()
        except:
            pass



        self.set_default_size(500, 500)
        self.connect('destroy', lambda x: gtk.main_quit())
        self.set_title("%s ver: %s"%(name, version))

        self.vbox = gtk.VBox(False, 0)
        self.add(self.vbox)

        self.my_gps_track = []
        self.baner_tmp = 0,0,""

        self.clikable_clouds = []


        if autorotate:
            if CONFIG['autorotate']:
                initial_mode = FremantleRotation.AUTOMATIC
            else:
                initial_mode = FremantleRotation.NEVER
            self.window_rotate = FremantleRotation(name, self, version, initial_mode)
            print "---------------------------------\nautorotate init!\n---------------------------------"


        try:
            self.osm.set_center_and_zoom( CONFIG['lat'], CONFIG['lon'], CONFIG['zoom'] )
        except:
            pass

        gobject.timeout_add(500, self.print_tiles)

    def set_plugins_list(self, plugins_list):
        self.plugins_list = plugins_list

    def get_may_current_ll(self):
        if gpsPresent:
            if gps.lat <> 0.0 and gps.lon <> 0.0:
                return [ gps.lat, gps.lon ]


        return [ self.osm.props.latitude, self.osm.props.longitude ]

    def distance( self,lat1, lon1, lat2, lon2):
        try:
            theta = lon1 - lon2
            dist = math.sin(math.radians(lat1)) * math.sin(math.radians(lat2)) +  math.cos(math.radians(lat1)) * math.cos(math.radians(lat2)) * math.cos(math.radians(theta))
            dist = math.acos(dist)
            dist = math.degrees(dist)
            return dist * 111.18957696
        except:
            return 0
    def distance_to_string(self, dis):
        if dis > 1.0:
            return "%.1f km"%dis
        else:
            dis*=1000
            return "%i m"%dis


    def cal_angle(self, lat0, lon0, lat1, lon1):
        deltax = lat1-lat0
        deltay = lon0-lon1
        M_PI = 3.14159265
        angle_rad = math.atan2(deltax,deltay)+M_PI

        return [ angle_rad, 0 ]


    def cal_dist(self, lat0, lon0, lat1, lon1):
        return math.sqrt((lon0 - lon1)**2 + (lat0 - lat1)**2)

    def draw_arrow(self, gdkdrawable, lat, lon,rgba=[0.9,0.2,0.9,0.7], borderRgba=[0.0,0.4,0.4,0.3] ):

        cr = gdkdrawable.cairo_create()
        t_lt, t_ln, b_lt, b_ln = self.osm.get_bbox()
        t_lt, t_ln, b_lt, b_ln = math.degrees(t_lt), math.degrees(t_ln), math.degrees(b_lt), math.degrees(b_ln)
        size = gdkdrawable.get_size()
        screen_center = [ size[0]/2, size[1]/2 ]
        latc = self.osm.props.latitude
        lonc = self.osm.props.longitude
        screen_distance = self.cal_dist( latc,lonc,t_lt,lonc )*0.7
        dis = self.cal_dist( latc, lonc, lat, lon )

        #print "dis:",dis,"screen_distance:",screen_distance

        if dis > screen_distance:
            a = self.cal_angle( latc, lonc, lat, lon)

            cr.arc(             screen_center[0], screen_center[1], 150,             a[0],   a[0]  )
            cr.arc(             screen_center[0], screen_center[1], 140,             a[0]+0.05,   a[0]+0.05  )
            cr.arc_negative(    screen_center[0], screen_center[1], 170,             a[0] ,      a[0]  )
            cr.arc(             screen_center[0], screen_center[1], 140,             a[0]-0.05,   a[0]-0.05 )
            cr.arc(             screen_center[0], screen_center[1], 150,             a[0],   a[0]  )

            cr.set_source_rgba (rgba[0],rgba[1],rgba[2],rgba[3])
            cr.fill_preserve ()
            cr.set_source_rgba (borderRgba[0],borderRgba[1],borderRgba[2],borderRgba[3])
            cr.set_line_width (1.0)
            cr.stroke ()

            cr.arc(             screen_center[0], screen_center[1], 180,             a[0],   a[0]  )
            cr.rotate( a[0] )
            cr.set_source_rgba(1.0, 1.0, 1.0, 0.7)
            cp = cr.get_current_point()
            cr.rectangle(cp[0]-3,cp[1]-10,40, 12)
            cr.move_to( cp[0], cp[1]+1)
            cr.fill_preserve ()
            #cr.set_source_rgba(0.0, 0.0, 0.0, 0.7)
            #cr.set_line_width (1.0)
            #cr.stroke ()

            cr.set_source_rgb(0.0, 0.0, 0.0)
            cr.select_font_face("Georgia")
            cr.set_font_size(12)
            #cr.move_to(x+2,y+line_height)


            dis = self.distance_to_string( self.distance( latc, lonc, lat, lon) )
            cr.show_text("%s"%dis)

    def draw_cloud(self, cr, x, y, str, font_size = 13, Fifek = True):
        if x<0 or y<0:
            return None
        rlat, rlon = self.osm.get_co_ordinates(int(x), int(y))
        if str == "":
            return None

        cr.select_font_face("Georgia")
        cr.set_font_size(font_size)
        xbearing, ybearing, width, height, xadvance, yadvance = cr.text_extents( str )

        line_height = height
        multiline = 0
        if str.find("\n") <> -1:
            multiline = 1
            tmp = str.split("\n")
            line_height = height
            width = 0
            height*=len(tmp)
            for l in tmp:
                xbearing, ybearing, width2, height2, xadvance, yadvance = cr.text_extents( l )
                if width2> width:
                    width = width2

        y+=3

        aspect = 1.0
        corner_radius = 3.0
        M_PI = 3.14159265

        radius = corner_radius / aspect
        degrees = M_PI / 180.0

        cr.new_sub_path ()
        if Fifek:
            cr.line_to( x,y )
            cr.line_to( x+5,y+10 )
        x-=5
        y+=10
        height+=4
        width+=4
        cr.arc (x + width - radius, y + radius, radius, -90 * degrees, 0 * degrees)
        cr.arc (x + width - radius, y + height - radius, radius, 0 * degrees, 90 * degrees)
        cr.arc (x + radius, y + height - radius, radius, 90 * degrees, 180 * degrees)
        cr.arc (x + radius, y + radius, radius, 180 * degrees, 270 * degrees)
        cr.close_path ()

        cr.set_source_rgb (1.0, 1.0, 1.0)
        cr.fill_preserve ()
        cr.set_source_rgb (0.0, 0.0, 0.0)
        cr.set_line_width (1.0)
        cr.stroke ()

        cr.set_source_rgb(0.0, 0.0, 0.0)
        cr.select_font_face("Georgia")
        cr.set_font_size(font_size)
        if multiline:
            line_nr = 0
            for l in tmp:
                cr.move_to(x+2,y+12+(line_nr*line_height))
                cr.show_text(l)
                line_nr+=1

        else:
            cr.move_to(x+2,y+line_height+1)
            cr.show_text(str)


        self.clikable_clouds.append( [ x,y,x+width,y+height, float(math.degrees(rlat)), float(math.degrees(rlon)) ] )



    def point_test(self, lat, lon, x,y):
        return False


    def load_map_clicked(self, button=None):

        try:
            if self.osm:
                #remove old map
                self.vbox.remove(self.osm)
        except:
            pass

        try:
            self.osm = osmgpsmap.GpsMap(
                    map_source=CONFIG['engine_name']
                    )

            self.osd = osmgpsmap.GpsMapOsd(show_crosshair=(not CONFIG['gpslock'] ))
            self.osm.layer_add(
                    self.osd
                    )

            self.osm.layer_add( PluginsLayer(self,self.plugins_list) )
            self.osm.layer_add( YosmapaOSD(self) )
            self.osm.connect('button_release_event', self.map_clicked)

            for plugin in self.plugins_list:
                plugin_name = plugin[1]
                if CONFIG[plugin_name]:
                    try:
                        plugin[0].makeInit()
                    except Exception, e:
                        print "plugin make init error ---- [",plugin_name,"], [",e,"]"
                        pass

            #connect keyboard shortcuts
        except Exception, e:
            print "ERROR:", e
            self.osm = osmgpsmap.GpsMap()

        self.vbox.pack_start(self.osm, True)
        #self.osm.connect('button-release-event', self.map_clicked)

        self.osm.show()
        self.osm.set_center( CONFIG['lat'], CONFIG['lon'])
        self.osm.set_zoom( CONFIG['zoom'] )



    def print_tiles(self):
        if self.osm.props.tiles_queued != 0:
            print self.osm.props.tiles_queued, 'tiles queued'
        self.download_max = 0
        return True

    def zoom_in_clicked(self, button):
        if self.osm.props.zoom < 18:
            self.osm.set_zoom(self.osm.props.zoom + 1)

    def zoom_out_clicked(self, button):
        if self.osm.props.zoom > 2:
            self.osm.set_zoom(self.osm.props.zoom - 1)


    def map_clicked(self, osm, event):
        if CONFIG['work_work_work']:
            print "config update"
            CONFIG['lat'] = self.osm.props.latitude
            CONFIG['lon'] = self.osm.props.longitude
            CONFIG['zoom'] = self.osm.props.zoom


            if event.button == 6:
                pass
            elif event.button == 8:
                rlat, rlon = self.osm.get_co_ordinates(int(event.x), int(event.y))
                self.osm.gps_add(
                        math.degrees(rlat),
                        math.degrees(rlon),
                        osmgpsmap.INVALID)
                self.my_gps_track.append( [ math.degrees(rlat), math.degrees(rlon) ] )

            for plugin in self.plugins_list:
                if CONFIG[plugin[1]]:
                    try:
                        plugin[0].do_button_release(osm,event)
                    except Exception, e:
                        print "UI map_release ERROR:", e




class GpsManager(Thread):
    def __init__(self, osmMapa):
        Thread.__init__(self)
        self.osmMapa = osmMapa

        self.lat = 0.0
        self.lon = 0.0
        self.heading = 0.0
        self.accuracy = 0.0
        self.last_iter_time = self.get_time()

        self.acc_scale = {
                          18: 70,
                          17: 100,
                          16: 200,
                          15: 500,
                          14: 1000,
                          13: 2000,
                          12: 4000,
                          11: 9000,
                          10: 10000,
                          9:  30000,
                          8:  70000,
                          7:  100000,
                          6:  200000,
                          5:  500000,
                          4:  1000000,
                          3:  2000000,
                          2:  4000000
                          }
    def get_time(self):
        return int(time.strftime("%Y%m%d%H%M%S", time.localtime() ))

    def on_error(self, control, error, data):
        print "location error: %d... quitting" % error
        data.quit()

    def on_changed(self,device, data):
        if not device:
            return
        if device.fix:
            if device.fix[1] & location.GPS_DEVICE_LATLONG_SET:
                self.lat, self.lon, self.heading, self.accuracy = device.fix[4], device.fix[5], device.fix[9], (device.fix[6]/100)
                #print "lat = %f, long = %f" % (lat,lon)


                if CONFIG['track_record'] == 0:
                    try:
                        self.osmMapa.osm.gps_clear()
                    except:
                        pass
                else:
                    #print "accuracy:[",self.accuracy,"]"
                    if self.accuracy<500:
                        t = self.get_time()
                        if (t-self.last_iter_time)>int(CONFIG['gpssec']):
                            #print "add to track"
                            self.last_iter_time = t
                            self.osmMapa.my_gps_track.append([self.lat,self.lon])


                if CONFIG['work_work_work']:
                    self.osmMapa.osm.gps_add( self.lat, self.lon, self.heading)
                    if CONFIG['gpslock'] == 1:
                       self.osmMapa.osm.set_center( self.lat, self.lon )
                       CONFIG['lat'], CONFIG['lon'] = self.lat, self.lon
                # data.stop() commented out to allow continuous loop for a reliable fix - press ctrl c to break the loop, or program your own way of exiting)


    def on_stop(self,control, data):
        print "quitting"
        data.quit()
        print "data quit"
        self.loop.quit()
        print "data quit 1"
        return False
    def start_location(self,data):
        data.start()
        return False

    def join(self):
        print "in join"
        self.loop.quit()
        print "in join 1"
        return False
    def run(self):

        self.loop = gobject.MainLoop()
        self.control = location.GPSDControl.get_default()
        device = location.GPSDevice()
        self.control.set_properties(preferred_method=location.METHOD_USER_SELECTED,
                               preferred_interval=location.INTERVAL_DEFAULT)

        self.control.connect("error-verbose", self.on_error, self.loop)
        device.connect("changed", self.on_changed, self.control)
        self.control.connect("gpsd-stopped", self.on_stop, self.loop)

        gobject.idle_add(self.start_location, self.control)

        self.loop.run()

def gps_emulator_iter():
    print "threshold:",u.osm.props.auto_center_threshold
    u.osm.props.auto_center = True
    try:
        f = open("../gps_emu.var", "r")
        d = f.read()
        f.close()
        lat, lon, acu, dir = d.split(",")
        lat = float( lat )
        lon = float( lon )
        dir = float(dir)

        u.osm.gps_add( lat, lon, dir)


        u.osm.props.gps_track_highlight_radius = (float(acu)/gps.acc_scale[u.osm.props.zoom])*10
        print "gps_add"
    except Exception, e:
            print "ERROR:", e

    gobject.timeout_add( 1000, gps_emulator_iter )
    print "gps_emulator_iter DONE"


class PluginsLayer(gobject.GObject, osmgpsmap.GpsMapLayer):
    def __init__(self, osmMapa, plugins):
        gobject.GObject.__init__(self)
        self.osmMapa = osmMapa
        self.plugins = plugins

    def do_draw(self, gpsmap, gdkdrawable):
        if CONFIG['work_work_work']:
            self.osmMapa.clikable_clouds = []
            for plugin in self.plugins:
                if CONFIG[plugin[1]]:
                    try:
                        plugin[0].do_draw(gpsmap, gdkdrawable)
                    except Exception, e:
                        print "PluginsLayer do_draw ERROR (",plugin[1],"):", e


    def do_render(self, gpsmap):
        pass

    def do_busy(self):
        return False

    def do_button_press(self, gpsmap, gdkeventbutton):

        return False
gobject.type_register(PluginsLayer)



class BuildPluginsList():

    def my_import(self,name):
        mod = __import__(name)
        components = name.split('.')
        for comp in components[1:]:
            mod = getattr(mod, comp)
        return mod

    def __init__(self, osmMapa):
        self.plugins = []

        for dirname, dirnames, filenames in os.walk( "./plugins/", topdown=True):
            for filename in filenames:
                if filename<>"plugin_proto.py" and filename.find(".pyo") == -1 and filename.find(".png") == -1 and filename.find(".txt") == -1 and filename.find("dont_") == -1:
                    name = filename.replace(".py", "")
                    path = "plugins.%s" % name
                    module = __import__("plugins/%s"%name)
                    the_class = getattr(module, name)
                    c = the_class( osmMapa, CONFIG )
                    plugin_name = c.get_name()

                    try:
                        if CONFIG[plugin_name]:
                            print "CONFIG ",plugin_name,"--> plugin active"
                    except:
                        print "CONFIG ",plugin_name,"-- >plugin not store in config, add it ",plugin_name
                        CONFIG[plugin_name] = 0

                    try:
                        ico = cairo.ImageSurface.create_from_png( "./plugins/%s" % c.ico )
                    except:
                        ico = None


                    self.plugins.append([c,plugin_name, ico])


    def get_plugins_list(self):
        return self.plugins




if __name__ == "__main__":
    config_load()
    u = UI()
    u.show_all()
    plugs = BuildPluginsList(u)
    u.set_plugins_list( plugs.get_plugins_list() )
    u.load_map_clicked()

    if gpsPresent:
        print "GPS init"
        gps = GpsManager(u)
        gps.start()
        print "GPS init DONE"

    if 0:
        u.osm.props.auto_center = True
        gps_emulator_iter()

    if 0: # ben
        CONFIG['lat'] = 52.404198
        CONFIG['lon'] = 16.970615
        u.ben_iter_func()

    if os.name == "nt": gtk.gdk.threads_enter()
    gtk.main()
    if os.name == "nt": gtk.gdk.threads_leave()
    config_save()

    if gpsPresent:
        print "GPS kill it"

        gps.loop.quit()
        gps.control.stop()
        gtk.gdk.threads_leave()
        gtk.gdk.threads_leave()
        gtk.gdk.threads_leave()

        print "GPS kill it DONE"


