#include <glib.h>
#include <pulse/simple.h>

#include "audio.h"

//#define DEBUG_AUDIO

struct yaspot_audio_t {
    pa_simple *simple;
};

yaspot_audio_t* yaspot_audio_init() {
    yaspot_audio_t *a;
    pa_sample_spec ss;
    pa_channel_map map;
    pa_buffer_attr buffer;
    pa_simple *s;

    ss.format = PA_SAMPLE_S16NE;
    ss.channels = 2;
    ss.rate = 44100;

    /* 750ms */
    buffer.maxlength = pa_usec_to_bytes(750000, &ss);
    buffer.tlength = -1;
    buffer.prebuf = -1;
    buffer.minreq = -1;

    pa_channel_map_init_stereo(&map);

    s = pa_simple_new(NULL,               // Use the default server.
                      "yaspot",         // Our application's name.
                      PA_STREAM_PLAYBACK,
                      NULL,               // Use the default device.
                      "media",            // Description of our stream.
                      &ss,                // Our sample format.
                      &map,
                      &buffer,
                      NULL                // Ignore error code.
                      );

    if (s) {
        a = g_new0(yaspot_audio_t, 1);
        a->simple = s;
        g_print("audio: init\n");
        return a;
    } else {
        g_print("audio: failed to init\n");
        return NULL;
    }
}

void yaspot_audio_cleanup(yaspot_audio_t *a) {

    g_print("audio: flush\n");
    pa_simple_flush(a->simple, NULL);

    g_print("audio: free\n");
    pa_simple_free(a->simple);

    g_free(a);
}

int yaspot_audio_write(yaspot_audio_t *a, char *buf, gint len) {
#ifdef DEBUG_AUDIO
    g_print("audio: write %d\n", len);
#endif
    pa_simple_write(a->simple, buf, len, NULL);

    return 0;
}

// vim: expandtab shiftwidth=4

