#include <hildon/hildon.h>
#include "userdata.h"
#include "playlist.h"


GtkTreeView* yaspot_playlist_view_new() {

    GtkTreeView *treeview;
    GtkCellRenderer *renderer;
    GtkTreeModel *model;
    GtkTreeViewColumn *col;

    /* total 790 px */
    const gint track_width = 50;
    const gint title_width = 300;
    const gint artist_width = 240;
    const gint album_width = 200;

    treeview = GTK_TREE_VIEW( hildon_gtk_tree_view_new(HILDON_UI_MODE_NORMAL) );
    renderer = gtk_cell_renderer_text_new();
    model = (GtkTreeModel*)gtk_list_store_new(PLAYLIST_NUM_COLS, G_TYPE_UINT, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING);

    col = gtk_tree_view_column_new_with_attributes(
            "#",
            renderer,
            "text",
            PLAYLIST_COL_TRACK,
            NULL);
    gtk_tree_view_column_set_max_width(col, track_width);
    gtk_tree_view_column_set_min_width(col, track_width);
    gtk_tree_view_column_set_visible(col, FALSE);
    gtk_tree_view_append_column(GTK_TREE_VIEW(treeview), col);

    col = gtk_tree_view_column_new_with_attributes(
            "Title",
            renderer,
            "text",
            PLAYLIST_COL_TITLE,
            NULL);
    gtk_tree_view_column_set_max_width(col, title_width);
    gtk_tree_view_column_set_min_width(col, title_width);
    gtk_tree_view_append_column(GTK_TREE_VIEW(treeview), col);

    col = gtk_tree_view_column_new_with_attributes(
            "Artist",
            renderer,
            "text",
            PLAYLIST_COL_ARTIST,
            NULL);
    gtk_tree_view_column_set_max_width(col, artist_width);
    gtk_tree_view_column_set_min_width(col, artist_width);
    gtk_tree_view_append_column(GTK_TREE_VIEW(treeview), col);

    col = gtk_tree_view_column_new_with_attributes(
            "Album",
            renderer,
            "text",
            PLAYLIST_COL_ALBUM,
            NULL);
    gtk_tree_view_column_set_max_width(col, album_width);
    gtk_tree_view_column_set_min_width(col, album_width);
    gtk_tree_view_append_column(GTK_TREE_VIEW(treeview), col);

    gtk_tree_view_set_model(GTK_TREE_VIEW(treeview), model);

    /* treeview has reference to model, we can free ours. */
    g_object_unref(model);

    return treeview;
}

GtkTreeView* yaspot_playlists_view_new() {

    GtkTreeView *treeview;
    GtkCellRenderer *renderer;
    GtkTreeModel *model;
    GtkTreeViewColumn *col;

    /* total 790 px */
    const gint num_width = 50;
    const gint name_width = 540;
    const gint author_width = 200;

    treeview = GTK_TREE_VIEW( hildon_gtk_tree_view_new(HILDON_UI_MODE_NORMAL) );
    renderer = gtk_cell_renderer_text_new();
    model = (GtkTreeModel*)gtk_list_store_new(PLAYLISTS_NUM_COLS, G_TYPE_UINT, G_TYPE_STRING, G_TYPE_STRING);

    col = gtk_tree_view_column_new_with_attributes(
            "#",
            renderer,
            "text",
            PLAYLISTS_COL_NUM,
            NULL);
    gtk_tree_view_column_set_max_width(col, num_width);
    gtk_tree_view_column_set_min_width(col, num_width);
    gtk_tree_view_column_set_visible(col, FALSE);
    gtk_tree_view_append_column(GTK_TREE_VIEW(treeview), col);

    col = gtk_tree_view_column_new_with_attributes(
            "Playlist Name",
            renderer,
            "text",
            PLAYLISTS_COL_NAME,
            NULL);
    gtk_tree_view_column_set_max_width(col, name_width);
    gtk_tree_view_column_set_min_width(col, name_width);
    gtk_tree_view_append_column(GTK_TREE_VIEW(treeview), col);

    col = gtk_tree_view_column_new_with_attributes(
            "Author",
            renderer,
            "text",
            PLAYLISTS_COL_AUTHOR,
            NULL);
    gtk_tree_view_column_set_max_width(col, author_width);
    gtk_tree_view_column_set_min_width(col, author_width);
    gtk_tree_view_append_column(GTK_TREE_VIEW(treeview), col);

    gtk_tree_view_set_model(GTK_TREE_VIEW(treeview), model);
    //gtk_tree_view_set_headers_visible(GTK_TREE_VIEW(treeview), TRUE);

    /* treeview has reference to model, we can free ours. */
    g_object_unref(model);

    return treeview;
}

GtkTreeView* yaspot_playlist_album_new() {
    GtkTreeView *treeview;
    GtkCellRenderer *renderer;
    GtkTreeModel *model;
    GtkTreeViewColumn *col;

    /* total 790 px */
    const gint num_width = 50;
    const gint title_width = 340;
    const gint length_width = 80;

    treeview = GTK_TREE_VIEW( hildon_gtk_tree_view_new(HILDON_UI_MODE_NORMAL) );
    renderer = gtk_cell_renderer_text_new();
    model = (GtkTreeModel*)gtk_list_store_new(ALBUM_NUM_COLS, G_TYPE_UINT, G_TYPE_STRING, G_TYPE_STRING);

    col = gtk_tree_view_column_new_with_attributes(
            "#",
            renderer,
            "text",
            ALBUM_COL_TRACK,
            NULL);
    gtk_tree_view_column_set_max_width(col, num_width);
    gtk_tree_view_column_set_min_width(col, num_width);
    gtk_tree_view_append_column(GTK_TREE_VIEW(treeview), col);

    col = gtk_tree_view_column_new_with_attributes(
            "Title",
            renderer,
            "text",
            ALBUM_COL_TITLE,
            NULL);
    gtk_tree_view_column_set_max_width(col, title_width);
    gtk_tree_view_column_set_min_width(col, title_width);
    gtk_tree_view_append_column(GTK_TREE_VIEW(treeview), col);

    col = gtk_tree_view_column_new_with_attributes(
            "Length",
            renderer,
            "text",
            ALBUM_COL_LENGTH,
            NULL);
    gtk_tree_view_column_set_max_width(col, length_width);
    gtk_tree_view_column_set_min_width(col, length_width);
    gtk_tree_view_append_column(GTK_TREE_VIEW(treeview), col);

    gtk_tree_view_set_model(GTK_TREE_VIEW(treeview), model);
    gtk_tree_view_set_headers_visible(GTK_TREE_VIEW(treeview), FALSE);

    /* treeview has reference to model, we can free ours. */
    g_object_unref(model);

    return treeview;
}

GtkTreeView* yaspot_playlist_queue_new() {
    GtkTreeView *treeview;
    GtkCellRenderer *renderer;
    GtkTreeModel *model;
    GtkTreeViewColumn *col;

    /* total 790 px */
    const gint num_width = 50;
    const gint title_width = 360;
    const gint artist_width = 300;
    const gint length_width = 80;

    treeview = GTK_TREE_VIEW( hildon_gtk_tree_view_new(HILDON_UI_MODE_EDIT) );
    renderer = gtk_cell_renderer_text_new();
    model = (GtkTreeModel*)gtk_list_store_new(QUEUE_NUM_COLS, G_TYPE_UINT, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING);

    col = gtk_tree_view_column_new_with_attributes(
            "#",
            renderer,
            "text",
            QUEUE_COL_TRACK,
            NULL);
    gtk_tree_view_column_set_max_width(col, num_width);
    gtk_tree_view_column_set_min_width(col, num_width);
    gtk_tree_view_append_column(GTK_TREE_VIEW(treeview), col);

    col = gtk_tree_view_column_new_with_attributes(
            "Title",
            renderer,
            "text",
            QUEUE_COL_TITLE,
            NULL);
    gtk_tree_view_column_set_max_width(col, title_width);
    gtk_tree_view_column_set_min_width(col, title_width);
    gtk_tree_view_append_column(GTK_TREE_VIEW(treeview), col);

    col = gtk_tree_view_column_new_with_attributes(
            "Artist",
            renderer,
            "text",
            QUEUE_COL_ARTIST,
            NULL);
    gtk_tree_view_column_set_max_width(col, artist_width);
    gtk_tree_view_column_set_min_width(col, artist_width);
    gtk_tree_view_append_column(GTK_TREE_VIEW(treeview), col);

    col = gtk_tree_view_column_new_with_attributes(
            "Length",
            renderer,
            "text",
            QUEUE_COL_LENGTH,
            NULL);
    gtk_tree_view_column_set_max_width(col, length_width);
    gtk_tree_view_column_set_min_width(col, length_width);
    gtk_tree_view_append_column(GTK_TREE_VIEW(treeview), col);

    gtk_tree_view_set_model(GTK_TREE_VIEW(treeview), model);
    gtk_tree_view_set_headers_visible(GTK_TREE_VIEW(treeview), FALSE);

    /* treeview has reference to model, we can free ours. */
    g_object_unref(model);

    return treeview;
}

// vim: expandtab shiftwidth=4

