#include <glib.h>
#include <pulse/simple.h>

#include "audio.h"

struct yaspot_audio_t {
    pa_simple *simple;
};

yaspot_audio_t* yaspot_audio_init() {
    yaspot_audio_t *a;
    pa_sample_spec ss;
    pa_simple *s;

    a = g_new0(yaspot_audio_t, 1);


    ss.format = PA_SAMPLE_S16NE;
    ss.channels = 2;
    ss.rate = 44100;

    s = pa_simple_new(NULL,               // Use the default server.
                      "yaspot",         // Our application's name.
                      PA_STREAM_PLAYBACK,
                      NULL,               // Use the default device.
                      "Music",            // Description of our stream.
                      &ss,                // Our sample format.
                      NULL,               // Use default channel map
                      NULL,               // Use default buffering attributes.
                      NULL                // Ignore error code.
                      );

    a->simple = s;

    return a;
}

void yaspot_audio_cleanup(yaspot_audio_t *a) {

    g_print("audio: drain\n");
    pa_simple_drain(a->simple, NULL);

    g_print("audio: free\n");
    pa_simple_free(a->simple);

    g_free(a);
}

int yaspot_audio_write(yaspot_audio_t *a, char *buf, gint len) {
    //g_print("audio: calling write %d\n", len);

    pa_simple_write(a->simple, buf, len, NULL);
    //int pa_simple_write(pa_simple *s, const void*data, size_t bytes, gint *error);

    return 0;
}

// vim: expandtab shiftwidth=4

